/*
 * Decompiled with CFR 0.152.
 */
package net.tejty.gamediscs.games.controls;

import net.tejty.gamediscs.games.controls.Button;
import net.tejty.gamediscs.games.util.Game;

public class Controls {
    private boolean up;
    private boolean down;
    private boolean left;
    private boolean right;
    private boolean button1;
    private boolean button2;
    private boolean was_up;
    private boolean was_down;
    private boolean was_left;
    private boolean was_right;
    private boolean was_b1;
    private boolean was_b2;
    private final Game game;

    public Controls(Game game) {
        this.game = game;
    }

    public void setButton(Button button, boolean isDown) {
        boolean callEvent = false;
        switch (button) {
            case UP: {
                if (!this.up && isDown) {
                    callEvent = true;
                    this.was_up = true;
                }
                this.up = isDown;
                break;
            }
            case DOWN: {
                if (!this.down && isDown) {
                    callEvent = true;
                    this.was_down = true;
                }
                this.down = isDown;
                break;
            }
            case LEFT: {
                if (!this.left && isDown) {
                    callEvent = true;
                    this.was_left = true;
                }
                this.left = isDown;
                break;
            }
            case RIGHT: {
                if (!this.right && isDown) {
                    callEvent = true;
                    this.was_right = true;
                }
                this.right = isDown;
                break;
            }
            case BUTTON1: {
                if (!this.button1 && isDown) {
                    callEvent = true;
                    this.was_b1 = true;
                }
                this.button1 = isDown;
                break;
            }
            case BUTTON2: {
                if (!this.button2 && isDown) {
                    callEvent = true;
                    this.was_b2 = true;
                }
                this.button2 = isDown;
            }
        }
        if (isDown) {
            if (callEvent) {
                this.game.buttonDown(button);
            }
        } else {
            this.game.buttonUp(button);
        }
    }

    public boolean isButtonDown(Button button) {
        return switch (button) {
            default -> throw new IncompatibleClassChangeError();
            case Button.UP -> this.up;
            case Button.DOWN -> this.down;
            case Button.LEFT -> this.left;
            case Button.RIGHT -> this.right;
            case Button.BUTTON1 -> this.button1;
            case Button.BUTTON2 -> this.button2;
        };
    }

    public boolean wasButtonDown(Button button) {
        boolean toReturn = false;
        switch (button) {
            case UP: {
                toReturn = this.was_up;
                this.was_up = false;
                break;
            }
            case DOWN: {
                toReturn = this.was_down;
                this.was_down = false;
                break;
            }
            case LEFT: {
                toReturn = this.was_left;
                this.was_left = false;
                break;
            }
            case RIGHT: {
                toReturn = this.was_right;
                this.was_right = false;
                break;
            }
            case BUTTON1: {
                toReturn = this.was_b1;
                this.was_b1 = false;
                break;
            }
            case BUTTON2: {
                toReturn = this.was_b2;
                this.was_b2 = false;
            }
        }
        return toReturn;
    }
}

