/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModSpriteSets;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.SplashParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SplashParticle
extends FlatPlaneParticle {
    private final boolean translucent;
    private final boolean glowing;
    private final TagKey<Fluid> fluidTag;
    private final SpriteSet mainSprites;
    @Nullable
    private final SpriteSet overlaySprites;
    private final SpriteSet bottomSprites;
    private final boolean hasRipple;
    private final boolean hasOverlay;
    private final BlockPos.MutableBlockPos pos;
    private float xScale;
    private final float yScale;
    private TextureAtlasSprite overlaySprite;
    private TextureAtlasSprite bottomSprite;
    private boolean isRipplePhase = false;
    private float overlayRCol = 1.0f;
    private float overlayGCol = 1.0f;
    private float overlayBCol = 1.0f;

    protected SplashParticle(ClientLevel level, double x, double y, double z, boolean translucent, boolean glowing, TagKey<Fluid> fluidTag, SpriteSet mainSprites, @Nullable SpriteSet overlaySprites, SpriteSet bottomSprites, SplashParticleOptions options) {
        super(level, x, y, z);
        this.translucent = translucent;
        this.glowing = glowing;
        this.fluidTag = fluidTag;
        this.mainSprites = mainSprites;
        this.overlaySprites = overlaySprites;
        this.bottomSprites = bottomSprites;
        this.pos = BlockPos.m_274561_((double)x, (double)y, (double)z).m_122032_();
        this.hasOverlay = overlaySprites != null && ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue() > 0.0f;
        this.f_107225_ = 15;
        this.hasRipple = options.hasRipple();
        this.xScale = options.xScale() / 2.0f;
        this.yScale = options.yScale() / 2.0f;
        this.f_107663_ = this.xScale;
        this.m_107250_(this.xScale, this.yScale);
        this.setSpriteFromAge();
        this.setBottomSpriteFromAge();
    }

    public ParticleRenderType m_7556_() {
        if (this.translucent) {
            return ParticleRenderType.f_107431_;
        }
        return ParticleRenderType.f_107430_;
    }

    protected int m_6355_(float partialTick) {
        if (this.glowing) {
            return 240;
        }
        return super.m_6355_(partialTick);
    }

    public void m_5989_() {
        this.pos.m_122169_(this.f_107212_, this.f_107213_, this.f_107214_);
        if (!this.f_107208_.m_6425_((BlockPos)this.pos).m_205070_(this.fluidTag) && !Util.getCauldronFluid(this.f_107208_.m_8055_((BlockPos)this.pos)).m_205067_(this.fluidTag)) {
            this.m_107274_();
            return;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            if (!this.hasRipple || this.isRipplePhase) {
                this.m_107274_();
                return;
            }
            this.isRipplePhase = true;
            this.f_107225_ = 20;
            this.f_107224_ = 0;
        }
        this.xScale += 0.005f;
        if (this.isRipplePhase) {
            this.setBottomSpriteFromAge();
            return;
        }
        this.setSpriteFromAge();
    }

    private void setSpriteFromAge() {
        this.f_108321_ = this.mainSprites.m_5819_(this.f_107224_, this.f_107225_);
        if (this.hasOverlay) {
            this.overlaySprite = this.overlaySprites.m_5819_(this.f_107224_, this.f_107225_);
        }
    }

    private void setBottomSpriteFromAge() {
        this.bottomSprite = this.bottomSprites.m_5819_(this.f_107224_, this.f_107225_);
    }

    @Override
    protected void renderQuad(VertexConsumer consumer, Camera camera, float partialTicks, Quaternionf rotation) {
        Vec3 cameraPos = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cameraPos.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cameraPos.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cameraPos.m_7094_());
        float overlayAlpha = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayAlpha.get()).floatValue();
        if (this.hasRipple) {
            this.renderQuad(consumer, new Quaternionf().rotateX(1.5707964f), partialTicks, x, y, z, false, this.bottomSprite.m_118409_(), this.bottomSprite.m_118411_(), this.bottomSprite.m_118410_(), this.bottomSprite.m_118412_(), this.xScale, this.xScale, this.overlayRCol, this.overlayGCol, this.overlayBCol, overlayAlpha);
        }
        if (!this.isRipplePhase) {
            this.renderBox(consumer, partialTicks, x, y, z, this.m_5970_(), this.m_5951_(), this.m_5952_(), this.m_5950_(), this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_);
            if (this.hasOverlay) {
                this.renderBox(consumer, partialTicks, x, y, z, this.overlaySprite.m_118409_(), this.overlaySprite.m_118411_(), this.overlaySprite.m_118410_(), this.overlaySprite.m_118412_(), this.overlayRCol, this.overlayGCol, this.overlayBCol, overlayAlpha);
            }
        }
    }

    private void renderBox(VertexConsumer consumer, float partialTicks, float x, float y, float z, float u0, float v0, float u1, float v1, float red, float green, float blue, float alpha) {
        this.renderDoubleQuads(consumer, new Quaternionf(), partialTicks, x, y + this.yScale, z + this.xScale, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
        this.renderDoubleQuads(consumer, new Quaternionf().rotateY(1.5707964f), partialTicks, x - this.xScale, y + this.yScale, z, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
        this.renderDoubleQuads(consumer, new Quaternionf().rotateY((float)Math.PI), partialTicks, x, y + this.yScale, z - this.xScale, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
        this.renderDoubleQuads(consumer, new Quaternionf().rotateY(-1.5707964f), partialTicks, x + this.xScale, y + this.yScale, z, u0, v0, u1, v1, this.xScale, this.yScale, red, green, blue, alpha);
    }

    protected void renderDoubleQuads(VertexConsumer consumer, Quaternionf rotation, float partialTicks, float x, float y, float z, float u0, float v0, float u1, float v1, float quadWidthSize, float quadHeightSize, float red, float green, float blue, float alpha) {
        this.renderQuad(consumer, rotation, partialTicks, x, y, z, false, u0, v0, u1, v1, quadWidthSize, quadHeightSize, red, green, blue, alpha);
        this.renderQuad(consumer, rotation, partialTicks, x, y, z, true, u0, v0, u1, v1, quadWidthSize, quadHeightSize, red, green, blue, alpha);
    }

    protected void renderQuad(VertexConsumer consumer, Quaternionf rotation, float partialTicks, float x, float y, float z, boolean renderInverted, float u0, float v0, float u1, float v1, float quadWidthSize, float quadHeightSize, float red, float green, float blue, float alpha) {
        int packedLight = this.m_6355_(partialTicks);
        int i = renderInverted ? 1 : -1;
        int i2 = renderInverted ? -1 : 1;
        this.renderVertex(consumer, rotation, x, y, z, i, -1.0f, quadWidthSize, quadHeightSize, u1, v1, packedLight, red, green, blue, alpha);
        this.renderVertex(consumer, rotation, x, y, z, i, 1.0f, quadWidthSize, quadHeightSize, u1, v0, packedLight, red, green, blue, alpha);
        this.renderVertex(consumer, rotation, x, y, z, i2, 1.0f, quadWidthSize, quadHeightSize, u0, v0, packedLight, red, green, blue, alpha);
        this.renderVertex(consumer, rotation, x, y, z, i2, -1.0f, quadWidthSize, quadHeightSize, u0, v1, packedLight, red, green, blue, alpha);
    }

    protected void renderVertex(VertexConsumer buffer, Quaternionf rotation, float x, float y, float z, float xOffset, float yOffset, float quadWidthSize, float quadHeightSize, float u, float v, int packedLight, float red, float green, float blue, float alpha) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)rotation).mul(quadWidthSize, quadHeightSize, quadWidthSize).add(x, y, z);
        buffer.m_5483_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_7421_(u, v).m_85950_(red, green, blue, alpha).m_85969_(packedLight).m_5752_();
    }

    public record LavaProvider(SpriteSet sprites) implements ParticleProvider<SplashParticleOptions>
    {
        public Particle createParticle(SplashParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new SplashParticle(level, x, y, z, false, true, (TagKey<Fluid>)FluidTags.f_13132_, this.sprites, null, (SpriteSet)ModSpriteSets.LAVA_SPLASH_BOTTOM, options);
        }
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SplashParticleOptions>
    {
        public Particle createParticle(SplashParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SplashParticle particle = new SplashParticle(level, x, y, z, true, false, (TagKey<Fluid>)FluidTags.f_13131_, this.sprites, (SpriteSet)ModSpriteSets.WATER_SPLASH_OVERLAY, (SpriteSet)ModSpriteSets.WATER_SPLASH_BOTTOM, options);
            int waterColor = ((Biome)level.m_204166_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_203334_()).m_47560_();
            float colorIntensity = ((Float)ModConfigs.ENTITIES.splashes.splashOverlayTint.get()).floatValue();
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            if (colorIntensity > 0.0f) {
                float whiteIntensity = 1.0f - colorIntensity;
                particle.overlayRCol = whiteIntensity + colorIntensity * red;
                particle.overlayGCol = whiteIntensity + colorIntensity * green;
                particle.overlayBCol = whiteIntensity + colorIntensity * blue;
            }
            particle.m_107253_(red, green, blue);
            return particle;
        }
    }
}

