/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.particle.FlatPlaneParticle;
import einstein.subtle_effects.particle.option.DirectionParticleOptions;
import einstein.subtle_effects.util.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EggSplatParticle
extends FlatPlaneParticle {
    private final Direction direction;

    protected EggSplatParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites, Direction direction) {
        super(level, x, y, z);
        this.direction = direction;
        this.rotation = direction.m_253075_().rotateX((float)Math.PI);
        this.m_108335_(sprites);
        this.f_107225_ = 120;
        this.f_107663_ = 0.2f;
        if (direction.m_122434_().m_122478_()) {
            this.rotation.rotateY((float)(90 * this.f_107223_.m_188503_(3)) * ((float)Math.PI / 180));
        }
    }

    public void m_5989_() {
        super.m_5989_();
        BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        if (this.f_107208_.m_8055_(pos.m_121945_(this.direction)).m_60795_()) {
            this.m_107274_();
            return;
        }
        if (Util.isSolidOrNotEmpty((Level)this.f_107208_, pos)) {
            this.m_107274_();
            return;
        }
        int i = this.f_107225_ / 3 * 2;
        if (this.f_107224_ == i && this.direction.m_122434_().m_122479_()) {
            this.f_107226_ = 0.05f;
        }
        if (this.f_107224_ >= i) {
            this.f_107230_ = Mth.m_14036_((float)(this.f_107230_ - 0.0125f), (float)0.0f, (float)1.0f);
        }
    }

    @Override
    protected void renderVertex(VertexConsumer buffer, Quaternionf rotation, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, 0.0f, yOffset).rotate((Quaternionfc)rotation).mul(quadSize).add(x, y, z);
        buffer.m_5483_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z()).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(packedLight);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<DirectionParticleOptions>
    {
        public Particle createParticle(DirectionParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EggSplatParticle(level, x, y, z, this.sprites, options.direction());
        }
    }
}

