/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.networking.clientbound;

import einstein.subtle_effects.configs.ReplacedParticlesDisplayType;
import einstein.subtle_effects.init.ModAnimalFedEffectSettings;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.mixin.client.entity.AbstractHorseAccessor;
import einstein.subtle_effects.networking.clientbound.ClientBoundAnimalFedPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundBlockDestroyEffectsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundCompostItemPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundDispenseBucketPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundDrankPotionPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityFellPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntityLandInFluidPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundEntitySpawnSprintingDustCloudsPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundFallingBlockLandPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundMooshroomShearedPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundSheepShearPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundSpawnSnoreParticlePacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundStonecutterUsedPayload;
import einstein.subtle_effects.networking.clientbound.ClientBoundVillagerWorkPacket;
import einstein.subtle_effects.networking.clientbound.ClientBoundXPBottleEffectsPacket;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.particle.option.SheepFluffParticleOptions;
import einstein.subtle_effects.particle.option.SplashEmitterParticleOptions;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ClientPacketHandlers {
    private static final List<Block> MASON_STONECUTTER_USE_BLOCKS = List.of(Blocks.f_50069_, Blocks.f_50225_, Blocks.f_50333_, Blocks.f_50334_, Blocks.f_50228_, Blocks.f_50122_);
    private static final List<DyeColor> COMMON_SHEPHERD_WOOL_COLORS = List.of(DyeColor.WHITE, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN);

    public static void handle(ClientBoundEntityFellPacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(packet.entityId());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ParticleSpawnUtil.spawnEntityFellParticles(livingEntity, packet.y(), packet.distance(), packet.fallDamage(), ClientPacketHandlers.getEntityFellConfig(packet));
        }
    }

    public static void handle(ClientBoundEntitySpawnSprintingDustCloudsPacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(packet.entityId());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int ySpeedModifier = 5;
            if (livingEntity instanceof Ravager) {
                ySpeedModifier = 20;
            }
            ParticleSpawnUtil.spawnCreatureMovementDustClouds(livingEntity, (Level)level, livingEntity.m_217043_(), ySpeedModifier);
        }
    }

    public static void handle(ClientBoundSpawnSnoreParticlePacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (ModConfigs.BLOCKS.beehivesHaveSleepingZs) {
            level.m_7106_((ParticleOptions)ModParticles.SNORING.get(), packet.x(), packet.y(), packet.z(), 0.0, 0.0, 0.0);
        }
    }

    public static void handle(ClientBoundBlockDestroyEffectsPacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (ClientPacketHandlers.getBlockDestroyEffectConfig(packet)) {
            BlockPos pos = packet.pos();
            BlockState state = Block.m_49803_((int)packet.stateId());
            SoundType soundType = state.m_60827_();
            level.m_142052_(pos, state);
            level.m_245747_(pos, soundType.m_56775_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f, false);
        }
    }

    public static void handle(ClientBoundXPBottleEffectsPacket packet) {
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockPos pos = packet.pos();
        Vec3 vec3 = Vec3.m_82539_((Vec3i)pos);
        RandomSource random = level.m_213780_();
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.VANILLA) {
            level.m_46796_(2002, pos, PotionUtils.m_43559_((Potion)Potions.f_43599_));
        }
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.BOTH || ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < (Integer)ModConfigs.ITEMS.projectiles.xpBottleParticlesDensity.get(); ++i) {
                double d = random.m_188500_() * 4.0;
                double d1 = random.m_188500_() * Math.PI * 2.0;
                double xPower = Math.cos(d1) * d;
                double zPower = Math.sin(d1) * d;
                level.m_7106_((ParticleOptions)new FloatParticleOptions(ModParticles.EXPERIENCE.get(), (float)d), vec3.f_82479_ + xPower * 0.1, vec3.f_82480_ + 0.3, vec3.f_82481_ + zPower * 0.1, xPower, 0.01 + random.m_188500_() * 0.5, zPower);
            }
        }
        if (ModConfigs.ITEMS.projectiles.xpBottleParticlesDisplayType == ReplacedParticlesDisplayType.DEFAULT) {
            for (i = 0; i < 8; ++i) {
                level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42736_)), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, random.m_188583_() * 0.15, random.m_188500_() * 0.2, random.m_188583_() * 0.15);
            }
            level.m_245747_(pos, SoundEvents.f_12436_, SoundSource.NEUTRAL, 1.0f, random.m_188501_() * 0.1f + 0.9f, false);
        }
    }

    public static void handle(ClientBoundFallingBlockLandPayload payload) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockPos pos = payload.pos();
        BlockState state = Block.m_49803_((int)payload.stateId());
        Block block = state.m_60734_();
        if (ModConfigs.BLOCKS.fallingBlocks.onLandSound && !(block instanceof AnvilBlock)) {
            SoundType soundType = state.m_60827_();
            Util.playClientSound(pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        }
        if (ModConfigs.BLOCKS.fallingBlocks.onLandDust && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)block)) {
            boolean isInWater = payload.isInWater() && ModConfigs.BLOCKS.fallingBlocks.replaceDustWithBubblesUnderwater;
            RandomSource random = level.m_213780_();
            SimpleParticleType options = isInWater ? ParticleTypes.f_123795_ : ClientPacketHandlers.getParticleForFallingBlock((Level)level, pos, state);
            for (int i = 0; i < 25; ++i) {
                boolean bool = random.m_188499_();
                int xSign = MathUtil.nextSign(random);
                int zSign = MathUtil.nextSign(random);
                level.m_7106_((ParticleOptions)options, (double)pos.m_123341_() + 0.5 + (bool ? 0.55 * (double)xSign : MathUtil.nextNonAbsDouble(random, 0.55)), (double)pos.m_123342_() + MathUtil.nextDouble(random, 0.3), (double)pos.m_123343_() + 0.5 + (!bool ? 0.55 * (double)zSign : MathUtil.nextNonAbsDouble(random, 0.55)), bool ? (isInWater ? MathUtil.nextDouble(random, 0.5) : 50.0) * (double)xSign : 0.0, 0.3, !bool ? (isInWater ? MathUtil.nextDouble(random, 0.5) : 50.0) * (double)zSign : 0.0);
            }
        }
    }

    public static void handle(ClientBoundCompostItemPayload payload) {
        if (ModConfigs.BLOCKS.compostingItemParticles && (!payload.wasFarmer() || ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles)) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            RandomSource random = level.m_213780_();
            ParticleSpawnUtil.spawnCompostParticles((Level)level, payload.pos(), (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, payload.stack()), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
        }
    }

    public static void handle(ClientBoundStonecutterUsedPayload payload) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockPos pos = payload.pos();
        ParticleSpawnUtil.spawnStonecutterParticles((Level)level, payload.stack(), pos, level.m_8055_(pos));
    }

    public static void handle(ClientBoundVillagerWorkPacket payload) {
        block14: {
            BlockState state;
            BlockPos pos;
            RandomSource random;
            int professionLevel;
            VillagerProfession profession;
            ClientLevel level;
            block17: {
                block16: {
                    block15: {
                        if (!ModConfigs.ENTITIES.villagerWorkAtWorkstationParticles) {
                            return;
                        }
                        level = Minecraft.m_91087_().f_91073_;
                        if (level == null) {
                            return;
                        }
                        Entity entity = level.m_6815_(payload.villagerId());
                        if (!(entity instanceof Villager)) break block14;
                        Villager villager = (Villager)entity;
                        VillagerData villagerData = villager.m_7141_();
                        profession = villagerData.m_35571_();
                        professionLevel = villagerData.m_35576_();
                        random = level.m_213780_();
                        pos = payload.pos();
                        state = level.m_8055_(pos);
                        if (profession != VillagerProfession.f_35593_) break block15;
                        if (!ModConfigs.BLOCKS.cauldronUseParticles) {
                            return;
                        }
                        double fluidHeight = Util.getCauldronFillHeight(state);
                        ParticleOptions particle = Util.getCauldronParticle(state);
                        if (!(fluidHeight > 0.0) || particle == null) break block14;
                        for (int i = 0; i < 16; ++i) {
                            level.m_7106_(particle, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + fluidHeight, (double)pos.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
                        }
                        break block14;
                    }
                    if (profession != VillagerProfession.f_35599_) break block16;
                    ParticleSpawnUtil.spawnGrindstoneUsedParticles((Level)level, pos, state, random);
                    break block14;
                }
                if (profession != VillagerProfession.f_35598_) break block17;
                if (!ModConfigs.BLOCKS.smithingTableUseParticles) break block14;
                ParticleSpawnUtil.spawnHammeringWorkstationParticles(pos, random, (Level)level);
                break block14;
            }
            if (profession == VillagerProfession.f_35595_) {
                ParticleSpawnUtil.spawnStonecutterParticles((Level)level, new ItemStack((ItemLike)MASON_STONECUTTER_USE_BLOCKS.get(random.m_188503_(MASON_STONECUTTER_USE_BLOCKS.size()))), pos, state);
            } else if (profession == VillagerProfession.f_35597_) {
                SheepFluffParticleOptions particle = new SheepFluffParticleOptions(ClientPacketHandlers.getColorForShepherdWoolFluff(professionLevel, random), -1, false);
                for (int i = 0; i < 10; ++i) {
                    level.m_7106_((ParticleOptions)particle, (double)pos.m_123341_() + random.m_188500_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + random.m_188500_(), MathUtil.nextNonAbsDouble(random), random.m_188500_(), MathUtil.nextNonAbsDouble(random));
                }
            } else if (profession == VillagerProfession.f_35592_) {
                for (int i = 0; i < 8; ++i) {
                    level.m_7106_((ParticleOptions)ModParticles.CHICKEN_FEATHER.get(), (double)pos.m_123341_() + random.m_188500_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + random.m_188500_(), MathUtil.nextNonAbsDouble(random, 0.1), MathUtil.nextDouble(random, 0.1), MathUtil.nextNonAbsDouble(random, 0.1));
                    level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42484_)), (double)pos.m_123341_() + random.m_188500_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + random.m_188500_(), MathUtil.nextNonAbsDouble(random, 0.25), MathUtil.nextDouble(random, 0.25), MathUtil.nextNonAbsDouble(random, 0.25));
                }
            } else if ((profession == VillagerProfession.f_35587_ || profession == VillagerProfession.f_35586_) && state.m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                Block block = state.m_60734_();
                BlockState litState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true));
                TickerManager.schedule(10, () -> ClientPacketHandlers.lambda$handle$0(block, litState, (Level)level, pos, random));
                for (int i = 0; i < 2; ++i) {
                    block.m_214162_(litState, (Level)level, pos, random);
                }
            }
        }
    }

    public static void handle(ClientBoundMooshroomShearedPacket payload) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(payload.entityId());
        if (entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            if (!ModConfigs.ENTITIES.improvedMooshroomShearingEffects) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, mooshroom.m_20185_(), mooshroom.m_20227_(0.5), mooshroom.m_20189_(), 0.0, 0.0, 0.0);
                return;
            }
            RandomSource random = mooshroom.m_217043_();
            ItemParticleOption particle = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)(mooshroom.m_28554_() == MushroomCow.MushroomType.BROWN ? Blocks.f_50180_ : Blocks.f_50181_)));
            for (int i = 0; i < 20; ++i) {
                level.m_7106_((ParticleOptions)particle, mooshroom.m_20208_(1.0), mooshroom.m_20187_(), mooshroom.m_20262_(1.0), MathUtil.nextNonAbsDouble(random, 0.15), MathUtil.nextDouble(random, 0.15), MathUtil.nextNonAbsDouble(random, 0.15));
            }
            mooshroom.m_21373_();
        }
    }

    public static void handle(ClientBoundAnimalFedPacket payload) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(payload.animalId());
        ItemStack stack = payload.stack();
        if (entity instanceof Animal || entity instanceof Dolphin || entity instanceof Tadpole) {
            float volume;
            LivingEntity livingEntity = (LivingEntity)entity;
            RandomSource random = level.m_213780_();
            ModAnimalFedEffectSettings.Settings settings = ModAnimalFedEffectSettings.getSetting(entity.m_6095_());
            if (ModConfigs.ENTITIES.animalFeedingParticles) {
                for (int i = 0; i < 16; ++i) {
                    ParticleSpawnUtil.spawnEntityFaceParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, (ItemStack)settings.stackReplacer().apply(stack)), livingEntity, (Level)level, random, settings.offset(), Util.getPartialTicks());
                }
            }
            if ((volume = ((Float)ModConfigs.ENTITIES.animalFeedingSoundVolume.get()).floatValue()) > 0.0f && !entity.m_20067_()) {
                Util.playClientSound(entity, ClientPacketHandlers.getEatSound(livingEntity, stack, settings), entity.m_5720_(), volume, livingEntity.m_6100_());
            }
        }
    }

    public static void handle(ClientBoundDrankPotionPayload payload) {
        LivingEntity livingEntity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(payload.entityId());
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_()) {
            ParticleSpawnUtil.spawnPotionRings(livingEntity);
        }
    }

    public static void handle(ClientBoundDispenseBucketPayload payload) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        BlockPos pos = payload.pos();
        BlockState state = level.m_8055_(pos);
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            pos = pos.m_121945_(direction);
        }
        ParticleSpawnUtil.spawnBucketParticles((Level)level, pos, payload.stack());
    }

    public static void handle(ClientBoundSheepShearPayload payload) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(payload.entityId());
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            if (ModConfigs.ENTITIES.sheepShearFluff) {
                ParticleSpawnUtil.sheep(sheep);
            }
        }
    }

    public static void handle(ClientBoundEntityLandInFluidPayload payload) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(payload.entityId());
        if (entity != null) {
            ParticleType<SplashEmitterParticleOptions> particleType = payload.isLava() ? ModParticles.LAVA_SPLASH_EMITTER.get() : ModParticles.WATER_SPLASH_EMITTER.get();
            ParticleSpawnUtil.spawnSplashEffects(entity, (Level)level, particleType, payload.y(), payload.yVelocity());
        }
    }

    private static SoundEvent getEatSound(LivingEntity entity, ItemStack stack, ModAnimalFedEffectSettings.Settings settings) {
        AbstractHorse horse;
        SoundEvent horseEatSound;
        Supplier<SoundEvent> overrideSound = settings.sound();
        if (overrideSound != null) {
            return overrideSound.get();
        }
        if (entity instanceof AbstractHorse && (horseEatSound = ((AbstractHorseAccessor)(horse = (AbstractHorse)entity)).getEatSound()) != null && !horseEatSound.equals(SoundEvents.f_11912_)) {
            return horseEatSound;
        }
        SoundEvent eatSound = entity.m_7866_(stack);
        SoundEvent stackEatSound = stack.m_41616_();
        if (!eatSound.equals(SoundEvents.f_11912_) && !eatSound.equals(stackEatSound)) {
            return eatSound;
        }
        if (entity instanceof Strider) {
            return SoundEvents.f_12465_;
        }
        if (entity instanceof Parrot) {
            return SoundEvents.f_12190_;
        }
        return stackEatSound;
    }

    private static DyeColor getColorForShepherdWoolFluff(int professionLevel, RandomSource random) {
        if (professionLevel >= 2 && random.m_188500_() < 0.5) {
            return DyeColor.values()[random.m_188503_(DyeColor.values().length)];
        }
        return COMMON_SHEPHERD_WOOL_COLORS.get(random.m_188503_(COMMON_SHEPHERD_WOOL_COLORS.size()));
    }

    private static ParticleOptions getParticleForFallingBlock(Level level, BlockPos pos, BlockState state) {
        if (Block.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_())) {
            int color = ClientPacketHandlers.getFallingBlockDustColor(level, state.m_60734_(), state, pos);
            return new DustParticleOptions(new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f), 1.0f);
        }
        return new BlockParticleOption(ParticleTypes.f_123814_, state);
    }

    private static int getFallingBlockDustColor(Level level, Block block, BlockState state, BlockPos pos) {
        BrushableBlock brushableBlock;
        Block turnsIntoBlock;
        if (block instanceof FallingBlock) {
            FallingBlock fallingBlock = (FallingBlock)block;
            return fallingBlock.m_6248_(state, (BlockGetter)level, pos);
        }
        if (block instanceof BrushableBlock && (turnsIntoBlock = (brushableBlock = (BrushableBlock)block).m_277074_()) != block) {
            return ClientPacketHandlers.getFallingBlockDustColor(level, turnsIntoBlock, state, pos);
        }
        return Minecraft.m_91087_().m_91298_().m_92582_(state, level, pos);
    }

    private static boolean getBlockDestroyEffectConfig(ClientBoundBlockDestroyEffectsPacket packet) {
        return switch (packet.config()) {
            default -> throw new IncompatibleClassChangeError();
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.LEAVES_DECAY -> ModConfigs.BLOCKS.leavesDecayEffects;
            case ClientBoundBlockDestroyEffectsPacket.TypeConfig.FARMLAND_DESTROY -> ModConfigs.BLOCKS.farmlandDestroyEffects;
        };
    }

    private static boolean getEntityFellConfig(ClientBoundEntityFellPacket packet) {
        return switch (packet.config()) {
            default -> throw new IncompatibleClassChangeError();
            case ClientBoundEntityFellPacket.TypeConfig.ENTITY -> ModConfigs.ENTITIES.dustClouds.mobFell;
            case ClientBoundEntityFellPacket.TypeConfig.PLAYER -> ModConfigs.ENTITIES.dustClouds.playerFell;
            case ClientBoundEntityFellPacket.TypeConfig.MACE -> ModConfigs.ENTITIES.dustClouds.landMaceAttack;
            case ClientBoundEntityFellPacket.TypeConfig.ELYTRA -> ModConfigs.ENTITIES.dustClouds.flyIntoWall;
        };
    }

    private static /* synthetic */ void lambda$handle$0(Block block, BlockState litState, Level level, BlockPos pos, RandomSource random) {
        block.m_214162_(litState, level, pos, random);
    }
}

