/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.common.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.networking.clientbound.ClientBoundAnimalFedPacket;
import einstein.subtle_effects.platform.Services;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public class MobMixin {
    @Unique
    private final Mob subtleEffects$mob = (Mob)this;

    @WrapOperation(method={"spawnAnim"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;getX(D)D")})
    private double getX(Mob mob, double scale, Operation<Double> original) {
        return mob.m_20208_(scale);
    }

    @Inject(method={"spawnAnim"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void onSpawnAnim(CallbackInfo ci) {
        Level level = this.subtleEffects$mob.m_9236_();
        if (level.f_46443_ && this.subtleEffects$mob.m_204029_(FluidTags.f_13131_) && ModConfigs.ENTITIES.underwaterEntityPoofBubbles) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123774_, this.subtleEffects$mob.m_20208_(1.0), this.subtleEffects$mob.m_20187_(), this.subtleEffects$mob.m_20262_(1.0), 0.0, 0.0, 0.0);
        }
    }

    @WrapOperation(method={"interact"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult onMobInteract(Mob mob, Player player, InteractionHand hand, Operation<InteractionResult> original) {
        ItemStack stack = player.m_21120_(hand).m_41777_();
        InteractionResult result = (InteractionResult)original.call(new Object[]{mob, player, hand});
        Level level = mob.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (result.m_19077_() && MobMixin.subtleEffects$isFood(mob, stack)) {
                ItemStack stackCopy = stack.m_41777_();
                ItemStack handStack = player.m_21205_().m_41777_();
                stack.m_41774_(1);
                if (!stackCopy.m_41619_() && (ItemStack.m_150942_((ItemStack)stack, (ItemStack)handStack) && stack.m_41613_() == handStack.m_41613_() || player.m_7500_())) {
                    Services.NETWORK.sendToClientsTracking(serverLevel, mob.m_20183_(), new ClientBoundAnimalFedPacket(mob.m_19879_(), stack.m_41619_() ? stackCopy : stack));
                }
            }
        }
        return result;
    }

    @Unique
    private static boolean subtleEffects$isFood(Mob mob, ItemStack stack) {
        if (mob instanceof Animal) {
            Animal animal = (Animal)mob;
            return animal.m_6898_(stack) || animal instanceof Wolf && stack.m_150930_(Items.f_42500_) || animal instanceof Parrot && (stack.m_150930_(Items.f_42572_) || Parrot.f_29357_.contains(stack.m_41720_()));
        }
        if (mob instanceof Dolphin) {
            return stack.m_204117_(ItemTags.f_13156_);
        }
        if (mob instanceof Tadpole) {
            return Frog.f_218455_.test(stack);
        }
        return false;
    }
}

