/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.blaze3d.vertex.VertexConsumer;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.EnchantmentTableParticleAccessor;
import einstein.subtle_effects.util.LifetimeAlpha;
import einstein.subtle_effects.util.ParticleAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.EnchantmentTableParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={EnchantmentTableParticle.class})
public abstract class EnchantmentTableParticleMixin
extends TextureSheetParticle
implements EnchantmentTableParticleAccessor {
    @Unique
    private LifetimeAlpha subtleEffects$lifetimeAlpha;
    @Unique
    private boolean subtleEffects$glowing = false;

    protected EnchantmentTableParticleMixin(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @ModifyReturnValue(method={"getLightColor"}, at={@At(value="RETURN")})
    private int getLightColor(int lightColor) {
        return this.subtleEffects$glowing ? 240 : lightColor;
    }

    public void m_5744_(VertexConsumer consumer, Camera camera, float partialTicks) {
        if (this.subtleEffects$lifetimeAlpha != null) {
            this.subtleEffects$lifetimeAlpha.currentAlphaForAge(this.f_107224_, this.f_107225_, partialTicks);
        }
        super.m_5744_(consumer, camera, partialTicks);
    }

    @ModifyReturnValue(method={"getRenderType"}, at={@At(value="RETURN")})
    private ParticleRenderType getRenderType(ParticleRenderType original) {
        if (this.subtleEffects$lifetimeAlpha != null) {
            return ParticleRenderType.f_107431_;
        }
        return original;
    }

    @Override
    public void subtleEffects$setLifetimeAlpha(LifetimeAlpha alpha) {
        this.subtleEffects$lifetimeAlpha = alpha;
    }

    @Override
    public void subtleEffects$setGlowing(boolean glowing) {
        this.subtleEffects$glowing = glowing;
    }

    @Mixin(value={EnchantmentTableParticle.Provider.class})
    public static class ProviderMixin {
        @ModifyReturnValue(method={"createParticle(Lnet/minecraft/core/particles/SimpleParticleType;Lnet/minecraft/client/multiplayer/ClientLevel;DDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="RETURN")})
        private Particle init(Particle particle) {
            EnchantmentTableParticleAccessor accessor = (EnchantmentTableParticleAccessor)particle;
            if (ModConfigs.GENERAL.glowingEnchantmentParticles) {
                accessor.subtleEffects$setGlowing(true);
            }
            if (ModConfigs.GENERAL.translucentEnchantmentParticles) {
                accessor.subtleEffects$setLifetimeAlpha(new LifetimeAlpha(0.0f, 0.5f, 0.0f, 1.0f));
                ((ParticleAccessor)particle).setAlpha(0.5f);
            }
            if (ModConfigs.GENERAL.disableRandomizedShading) {
                particle.m_107253_(1.0f, 1.0f, 1.0f);
            }
            return particle;
        }
    }
}

