/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.particle;

import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.init.ModSounds;
import einstein.subtle_effects.particle.option.FloatParticleOptions;
import einstein.subtle_effects.util.DripParticleAccessor;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.Util;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.DripParticle;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DripParticle.class})
public abstract class DripParticleMixin
extends TextureSheetParticle
implements DripParticleAccessor {
    @Shadow
    protected boolean f_106048_;
    @Shadow
    @Final
    private Fluid f_106049_;
    @Unique
    private boolean subtleEffects$dripIntoFluidEffectsPlayed;
    @Unique
    private boolean subtleEffects$isLava;
    @Unique
    private boolean subtleEffects$isSilent = false;

    protected DripParticleMixin(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(ClientLevel level, double x, double y, double z, Fluid fluid, CallbackInfo ci) {
        this.subtleEffects$isLava = this.f_106049_.m_205067_(FluidTags.f_13132_);
        if (ModConfigs.GENERAL.glowingLavaDrops && this.subtleEffects$isLava) {
            this.f_106048_ = true;
        }
    }

    @Inject(method={"tick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/material/Fluids;EMPTY:Lnet/minecraft/world/level/material/Fluid;")})
    private void tick(CallbackInfo ci) {
        BlockPos pos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        BlockState state = this.f_107208_.m_8055_(pos);
        FluidState fluidState = this.f_107208_.m_6425_(pos);
        double fluidHeight = Math.max(Util.getCauldronFillHeight(state), (double)fluidState.m_76155_((BlockGetter)this.f_107208_, pos));
        double fluidSurface = (double)pos.m_123342_() + fluidHeight + 0.01;
        if (fluidHeight > 0.0 && this.f_107213_ <= fluidSurface) {
            Fluid fluid;
            Fluid fluid2 = fluid = fluidState.m_76178_() ? Util.getCauldronFluid(state) : fluidState.m_76152_();
            if (ModConfigs.GENERAL.fluidDropsEvaporate && (fluid.m_205067_(FluidTags.f_13132_) && !this.subtleEffects$isLava || fluid.m_205067_(FluidTags.f_13131_) && this.subtleEffects$isLava)) {
                this.f_107208_.m_7106_((ParticleOptions)ModParticles.STEAM.get(), this.f_107212_, fluidSurface, this.f_107214_, 0.0, 0.0, 0.0);
                if (((Float)ModConfigs.GENERAL.fluidDropsEvaporationVolume.get()).floatValue() > 0.0f && !this.subtleEffects$isSilent) {
                    this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, SoundEvents.f_12031_, SoundSource.BLOCKS, Mth.m_216283_((RandomSource)this.f_107223_, (float)0.3f, (float)1.0f) * ((Float)ModConfigs.GENERAL.fluidDropsEvaporationVolume.get()).floatValue(), 2.6f + (this.f_107223_.m_188501_() - this.f_107223_.m_188501_()) * 0.8f, false);
                }
                this.m_107274_();
                return;
            }
            if (!this.subtleEffects$dripIntoFluidEffectsPlayed) {
                if (((Float)ModConfigs.GENERAL.dropLandSoundVolume.get()).floatValue() > 0.0f && !this.subtleEffects$isSilent) {
                    Supplier<SoundEvent> sound = this.subtleEffects$isLava ? ModSounds.DRIP_LAVA_INTO_FLUID : ModSounds.DRIP_WATER_INTO_FLUID;
                    this.f_107208_.m_7785_(this.f_107212_, this.f_107213_, this.f_107214_, sound.get(), SoundSource.BLOCKS, Mth.m_216283_((RandomSource)this.f_107223_, (float)0.3f, (float)1.0f) * ((Float)ModConfigs.GENERAL.dropLandSoundVolume.get()).floatValue(), 1.0f, false);
                }
                if (ModConfigs.GENERAL.dropLandInFluidRipples) {
                    this.f_107208_.m_7106_((ParticleOptions)new FloatParticleOptions(this.subtleEffects$isLava ? ModParticles.LAVA_RIPPLE.get() : ModParticles.WATER_RIPPLE.get(), Math.max(this.f_107663_, Math.max(this.f_107221_, this.f_107222_)) + 0.90000004f), this.f_107212_ + MathUtil.nextNonAbsDouble(this.f_107223_, 0.07), fluidSurface, this.f_107214_ + MathUtil.nextNonAbsDouble(this.f_107223_, 0.07), 0.0, 0.0, 0.0);
                }
                this.subtleEffects$dripIntoFluidEffectsPlayed = true;
            }
        }
    }

    @Override
    public void subtleEffects$setSilent() {
        this.subtleEffects$isSilent = true;
    }

    @Override
    public boolean subtleEffects$isSilent() {
        return this.subtleEffects$isSilent;
    }
}

