/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.configs.CommandBlockSpawnType;
import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.configs.items.ItemRarityConfigs;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.particle.SparkParticle;
import einstein.subtle_effects.particle.option.BooleanParticleOptions;
import einstein.subtle_effects.ticking.tickers.entity.DrowningTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityCauldronTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityFireTicker;
import einstein.subtle_effects.ticking.tickers.entity.EntityTickerManager;
import einstein.subtle_effects.ticking.tickers.entity.FrostyBreathTicker;
import einstein.subtle_effects.ticking.tickers.entity.HeartbeatTicker;
import einstein.subtle_effects.ticking.tickers.entity.HumanoidPotionRingTicker;
import einstein.subtle_effects.ticking.tickers.entity.IronGolemTicker;
import einstein.subtle_effects.ticking.tickers.entity.ItemRarityTicker;
import einstein.subtle_effects.ticking.tickers.entity.MinecartSparksTicker;
import einstein.subtle_effects.ticking.tickers.entity.MobSkullShaderTicker;
import einstein.subtle_effects.ticking.tickers.entity.SlimeTrailTicker;
import einstein.subtle_effects.ticking.tickers.entity.StomachGrowlingTicker;
import einstein.subtle_effects.ticking.tickers.entity.WitchPotionRingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.BatSleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.CatSleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.FoxSleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.PlayerSleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.SleepingTicker;
import einstein.subtle_effects.ticking.tickers.entity.sleeping.VillagerSleepingTicker;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.SparkType;
import einstein.subtle_effects.util.Util;
import java.util.function.Predicate;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ModEntityTickers {
    private static final Predicate<Entity> LOCAL_PLAYER = entity -> entity.equals((Object)Minecraft.m_91087_().f_91074_);

    public static void init() {
        EntityTickerManager.register(entity -> true, EntityCauldronTicker::new);
        EntityTickerManager.register(entity -> !(entity instanceof LightningBolt), EntityFireTicker::new);
        EntityTickerManager.register(entity -> entity instanceof LivingEntity, ModEntityTickers::getSleepingTicker);
        EntityTickerManager.register(entity -> entity instanceof AbstractMinecart && ModConfigs.ENTITIES.minecartSparksDisplayType != ModEntityConfigs.MinecartSparksDisplayType.OFF, MinecartSparksTicker::new);
        EntityTickerManager.register(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.stomachGrowlingThreshold.get() > 0), StomachGrowlingTicker::new);
        EntityTickerManager.register(LOCAL_PLAYER.and(entity -> ModConfigs.GENERAL.mobSkullShaders), MobSkullShaderTicker::new);
        EntityTickerManager.register(LOCAL_PLAYER.and(entity -> (Integer)ModConfigs.ENTITIES.humanoids.player.heartBeatingThreshold.get() > 0), HeartbeatTicker::new);
        EntityTickerManager.register(entity -> ModEntityTickers.isHumanoid(entity, !entity.m_9236_().m_46472_().equals((Object)Level.f_46429_)) && ModConfigs.ENTITIES.humanoids.drowningBubblesDisplayType.isEnabled(), DrowningTicker::new);
        EntityTickerManager.register(entity -> ModEntityTickers.isHumanoid(entity, !entity.m_9236_().m_46472_().equals((Object)Level.f_46429_)) && ModConfigs.ENTITIES.humanoids.frostyBreath.displayType.isEnabled(), FrostyBreathTicker::new);
        EntityTickerManager.register(entity -> entity.m_6095_().equals(EntityType.f_20526_) && ModConfigs.ENTITIES.slimeTrails, entity -> new SlimeTrailTicker<Slime>((Slime)entity, ModParticles.SLIME_TRAIL));
        EntityTickerManager.register(entity -> entity.m_6095_().equals(EntityType.f_20468_) && ModConfigs.ENTITIES.magmaCubeTrails, entity -> new SlimeTrailTicker<MagmaCube>((MagmaCube)entity, ModParticles.MAGMA_CUBE_TRAIL));
        EntityTickerManager.register(entity -> entity.m_6095_().equals(EntityType.f_20460_) && ModConfigs.ENTITIES.ironGolemCrackParticles, IronGolemTicker::new);
        EntityTickerManager.register(entity -> entity instanceof ItemEntity && ModConfigs.ITEMS.itemRarity.particlesDisplayType != ItemRarityConfigs.DisplayType.OFF, ItemRarityTicker::new);
        EntityTickerManager.register(entity -> entity instanceof Witch && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), WitchPotionRingTicker::new);
        EntityTickerManager.register(entity -> ModEntityTickers.isNPC(entity, true) && ModConfigs.ENTITIES.humanoids.NPCsHavePotionRings && ModConfigs.ENTITIES.humanoids.potionRingsDisplayType.isEnabled(), entity -> new HumanoidPotionRingTicker<LivingEntity>((LivingEntity)entity));
        EntityTickerManager.registerSimple(entity -> entity instanceof Player && ModConfigs.ENTITIES.dustClouds.playerRunning, true, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.dustClouds.preventWhenRaining && level.m_46758_(entity.m_20183_())) {
                return;
            }
            Player player = (Player)entity;
            if (ModConfigs.ENTITIES.dustClouds.playerRunningRequiresSpeed && !player.m_21023_(MobEffects.f_19596_)) {
                return;
            }
            if (player.m_5843_() && player.m_20096_() && !player.m_6117_() && random.m_188499_()) {
                level.m_7106_((ParticleOptions)ModParticles.SMALL_DUST_CLOUD.get(), entity.m_20208_(1.0), entity.m_20186_() + Math.max(Math.min((double)random.m_188501_(), 0.3), 0.2), entity.m_20262_(1.0), 0.0, random.m_188500_(), 0.0);
            }
        });
        EntityTickerManager.registerSimple(entity -> entity instanceof FallingBlockEntity && ModConfigs.BLOCKS.fallingBlocks.whileFallingDust, false, (entity, level, random) -> {
            BlockState state;
            Block block;
            boolean isInWater;
            FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
            int startDistance = (Integer)ModConfigs.BLOCKS.fallingBlocks.whileFallingDustStartDistance.get();
            float fallDistance = fallingBlock.f_19789_;
            boolean bl = isInWater = fallingBlock.m_20069_() && ModConfigs.BLOCKS.fallingBlocks.replaceDustWithBubblesUnderwater;
            if (fallDistance <= (float)startDistance && !isInWater) {
                return;
            }
            if (!fallingBlock.m_20096_() && !fallingBlock.m_20068_() && ModConfigs.BLOCKS.fallingBlocks.dustyBlocks.contains((Object)(block = (state = fallingBlock.m_31980_()).m_60734_()))) {
                double size = startDistance > 0 ? (fallDistance <= (float)startDistance + (float)startDistance / 3.0f * 2.0f ? 0.5 : 1.0) : 1.0;
                for (int i = 0; i < (size == 1.0 ? 2 : 1); ++i) {
                    SimpleParticleType simpleParticleType;
                    if (isInWater) {
                        simpleParticleType = ParticleTypes.f_123795_;
                    } else {
                        BlockState blockState;
                        if (block instanceof BrushableBlock) {
                            BrushableBlock brushableBlock = (BrushableBlock)block;
                            blockState = brushableBlock.m_277074_().m_49966_();
                        } else {
                            blockState = state;
                        }
                        simpleParticleType = new BlockParticleOption(ParticleTypes.f_123814_, blockState);
                    }
                    level.m_7106_((ParticleOptions)simpleParticleType, entity.m_20208_(size), entity.m_20186_() + 0.05, entity.m_20262_(size), 0.0, 0.0, 0.0);
                }
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20477_, false, () -> (Double)ModConfigs.ITEMS.projectiles.snowballTrailDensity.get() > 0.0, (entity, level, random) -> {
            if (ModEntityTickers.shouldSpawn(random, ModConfigs.ITEMS.projectiles.snowballTrailDensity)) {
                Vec3 deltaMovement = entity.m_20184_();
                level.m_7106_((ParticleOptions)ModParticles.SNOWBALL_TRAIL.get(), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), deltaMovement.f_82479_ * 0.5, deltaMovement.f_82480_, deltaMovement.f_82481_ * 0.5);
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20484_, false, () -> ModConfigs.ITEMS.projectiles.enderPearlTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, entity.m_20208_(2.0), entity.m_20187_(), entity.m_20262_(2.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_217014_, true, () -> (Double)ModConfigs.ENTITIES.allayMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModEntityTickers.shouldSpawn(random, ModConfigs.ENTITIES.allayMagicDensity)) {
                level.m_7106_((ParticleOptions)ModParticles.ALLAY_MAGIC.get(), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20491_, true, () -> (Double)ModConfigs.ENTITIES.vexMagicDensity.get() > 0.0, (entity, level, random) -> {
            if (ModEntityTickers.shouldSpawn(random, ModConfigs.ENTITIES.vexMagicDensity)) {
                level.m_7106_((ParticleOptions)new BooleanParticleOptions(ModParticles.VEX_MAGIC.get(), entity.m_34028_()), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), MathUtil.nextNonAbsDouble(random, 0.04), 0.0, MathUtil.nextNonAbsDouble(random, 0.04));
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_243976_, true, () -> ModConfigs.ENTITIES.dustClouds.mobRunning, (entity, level, random) -> {
            if (entity.m_245293_() && entity.m_20096_()) {
                for (int i = 0; i < 10; ++i) {
                    ParticleSpawnUtil.spawnCreatureMovementDustCloudsNoConfig((LivingEntity)entity, level, random, 5);
                }
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20561_, false, () -> ModConfigs.ENTITIES.improvedDragonFireballTrail, (entity, level, random) -> {
            for (int i = 0; i < 10; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123799_, entity.m_20208_(2.0), entity.m_20187_(), entity.m_20262_(2.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20471_, false, () -> ModConfigs.ENTITIES.commandBlockMinecartParticles != CommandBlockSpawnType.OFF, (entity, level, random) -> {
            if (ModConfigs.ENTITIES.commandBlockMinecartParticles.canTick() && random.m_188503_(10) == 0) {
                ParticleSpawnUtil.spawnCmdBlockParticles(level, entity.m_20182_().m_82520_(0.0, (double)(-(entity.m_38183_() - 8)) / 16.0 + 0.4266666666666667, 0.0), random, (direction, relativePos) -> true);
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20515_, false, () -> ModConfigs.ENTITIES.explosives.tntSparks, (entity, level, random) -> level.m_7106_((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.m_20208_(0.5), entity.m_20227_(1.0), entity.m_20262_(0.5), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01)));
        EntityTickerManager.registerSimple(EntityType.f_20515_, false, () -> (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get() > 0, (entity, level, random) -> {
            if (random.m_188503_(10) == 0) {
                int density = (Integer)ModConfigs.ENTITIES.explosives.tntFlamesDensity.get();
                if (density == 1) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20185_(), entity.m_20227_(1.1), entity.m_20189_(), 0.0, 0.0, 0.0);
                    return;
                }
                for (int i = 0; i < density; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20208_(0.7), entity.m_20187_(), entity.m_20262_(0.7), 0.0, 0.0, 0.0);
                }
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20564_, false, () -> ModConfigs.ENTITIES.endCrystalParticles, (entity, level, random) -> {
            if (level.m_8055_(entity.m_20183_()).m_60734_() instanceof BaseFireBlock || random.m_188503_(3) == 0) {
                level.m_7106_((ParticleOptions)ModParticles.END_CRYSTAL.get(), entity.m_20208_(1.0), entity.m_20187_() + MathUtil.nextNonAbsDouble(random), entity.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20478_, false, () -> ModConfigs.ENTITIES.spectralArrowParticles, (entity, level, random) -> {
            if (random.m_188503_(3) == 0) {
                level.m_7106_((ParticleOptions)Util.GLOWSTONE_DUST_PARTICLES, entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20558_, true, () -> ModConfigs.ENTITIES.explosives.creeperSparks, (entity, level, random) -> {
            if (entity.m_32311_()) {
                for (int i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)SparkParticle.create(SparkType.SHORT_LIFE, random), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
                }
            }
        });
        EntityTickerManager.registerSimple(EntityType.f_20558_, true, () -> ModConfigs.ENTITIES.explosives.creeperSmoke.isEnabled(), (entity, level, random) -> {
            if (entity.m_32311_()) {
                level.m_7106_(ModConfigs.ENTITIES.explosives.creeperSmoke.getParticle().get(), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01), MathUtil.nextNonAbsDouble(random, 0.01));
            }
        });
        EntityTickerManager.registerSimple(entity -> entity instanceof LivingEntity && entity.m_142079_() && ModConfigs.ENTITIES.freezingSnowFlakes, false, (entity, level, random) -> {
            if (entity.m_203117_() || entity.m_146888_() > 0 || level.m_8055_(entity.m_20183_()).m_60713_(Blocks.f_152478_)) {
                level.m_7106_((ParticleOptions)ModParticles.FREEZING.get(), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        });
    }

    public static boolean shouldSpawn(RandomSource random, ValidatedDouble chanceConfig) {
        return (double)Math.min(random.m_188501_(), 1.0f) < (Double)chanceConfig.get();
    }

    private static SleepingTicker<?> getSleepingTicker(LivingEntity entity) {
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            return new VillagerSleepingTicker(villager);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return new PlayerSleepingTicker(player);
        }
        if (entity instanceof Bat) {
            Bat bat = (Bat)entity;
            return new BatSleepingTicker(bat);
        }
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            return new CatSleepingTicker(cat);
        }
        if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            return new FoxSleepingTicker(fox);
        }
        return new SleepingTicker<LivingEntity>(entity);
    }

    private static boolean isHumanoid(Entity entity, boolean includePiglins) {
        return entity instanceof Player || ModEntityTickers.isNPC(entity, includePiglins) || entity instanceof Witch;
    }

    private static boolean isNPC(Entity entity, boolean includePiglins) {
        return entity instanceof AbstractVillager || entity instanceof AbstractIllager || includePiglins && entity instanceof AbstractPiglin;
    }
}

