/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.entity.block;

import com.ldtteam.domumornamentum.block.decorative.DynamicTimberFrameBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.client.model.properties.ModProperties;
import com.ldtteam.domumornamentum.entity.block.AbstractMateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.entity.block.ModBlockEntityTypes;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DynamicTimberFrameBlockEntity
extends AbstractMateriallyTexturedBlockEntity {
    public static final ResourceLocation NORTH_UP = new ResourceLocation("block/white_wool");
    public static final ResourceLocation NORTH_DOWN = new ResourceLocation("block/orange_wool");
    public static final ResourceLocation SOUTH_UP = new ResourceLocation("block/magenta_wool");
    public static final ResourceLocation SOUTH_DOWN = new ResourceLocation("block/light_blue_wool");
    public static final ResourceLocation EAST_DOWN = new ResourceLocation("block/yellow_wool");
    public static final ResourceLocation EAST_UP = new ResourceLocation("block/lime_wool");
    public static final ResourceLocation WEST_DOWN = new ResourceLocation("block/pink_wool");
    public static final ResourceLocation WEST_UP = new ResourceLocation("block/gray_wool");
    public static final ResourceLocation NORTH_EAST_DOWN = new ResourceLocation("block/light_gray_wool");
    public static final ResourceLocation NORTH_EAST_UP = new ResourceLocation("block/cyan_wool");
    public static final ResourceLocation NORTH_EAST_CORNER = new ResourceLocation("block/purple_wool");
    public static final ResourceLocation NORTH_WEST_DOWN = new ResourceLocation("block/blue_wool");
    public static final ResourceLocation NORTH_WEST_UP = new ResourceLocation("block/brown_wool");
    public static final ResourceLocation NORTH_WEST_CORNER = new ResourceLocation("block/green_wool");
    public static final ResourceLocation SOUTH_EAST_DOWN = new ResourceLocation("block/red_wool");
    public static final ResourceLocation SOUTH_EAST_UP = new ResourceLocation("block/black_wool");
    public static final ResourceLocation SOUTH_EAST_CORNER = new ResourceLocation("block/white_terracotta");
    public static final ResourceLocation SOUTH_WEST_DOWN = new ResourceLocation("block/orange_terracotta");
    public static final ResourceLocation SOUTH_WEST_UP = new ResourceLocation("block/magenta_terracotta");
    public static final ResourceLocation SOUTH_WEST_CORNER = new ResourceLocation("block/light_blue_terracotta");
    public static final ResourceLocation CENTER = new ResourceLocation("block/yellow_terracotta");
    public static final ResourceLocation BOTTOM_CENTER = new ResourceLocation("block/lime_terracotta");
    public static final ResourceLocation BOTTOM_SOUTH_CENTER = new ResourceLocation("block/pink_terracotta");
    public static final ResourceLocation BOTTOM_NORTH_CENTER = new ResourceLocation("block/gray_terracotta");
    public static final ResourceLocation TOP_NORTH_CENTER = new ResourceLocation("block/light_gray_terracotta");
    public static final ResourceLocation TOP_SOUTH_CENTER = new ResourceLocation("block/cyan_terracotta");
    public static final ResourceLocation TOP_CENTER = new ResourceLocation("block/purple_terracotta");
    public static final ResourceLocation NORTH_WEST_CENTER = new ResourceLocation("block/blue_terracotta");
    public static final ResourceLocation NORTH_EAST_CENTER = new ResourceLocation("block/brown_terracotta");
    public static final ResourceLocation NORTH_WEST_UP_CENTER = new ResourceLocation("block/green_terracotta");
    public static final ResourceLocation NORTH_EAST_UP_CENTER = new ResourceLocation("block/red_terracotta");
    public static final ResourceLocation NORTH_EAST_DOWN_CENTER = new ResourceLocation("block/black_terracotta");
    public static final ResourceLocation NORTH_WEST_DOWN_CENTER = new ResourceLocation("block/white_concrete");
    public static final ResourceLocation SOUTH_EAST_CENTER = new ResourceLocation("block/orange_concrete");
    public static final ResourceLocation SOUTH_WEST_CENTER = new ResourceLocation("block/magenta_concrete");
    public static final ResourceLocation SOUTH_WEST_UP_CENTER = new ResourceLocation("block/light_blue_concrete");
    public static final ResourceLocation SOUTH_EAST_UP_CENTER = new ResourceLocation("block/yellow_concrete");
    public static final ResourceLocation SOUTH_EAST_DOWN_CENTER = new ResourceLocation("block/lime_concrete");
    public static final ResourceLocation SOUTH_WEST_DOWN_CENTER = new ResourceLocation("block/pink_concrete");
    public static final ResourceLocation EAST_NORTH_CENTER = new ResourceLocation("block/gray_concrete");
    public static final ResourceLocation EAST_SOUTH_CENTER = new ResourceLocation("block/light_gray_concrete");
    public static final ResourceLocation EAST_SOUTH_UP_CENTER = new ResourceLocation("block/cyan_concrete");
    public static final ResourceLocation EAST_NORTH_UP_CENTER = new ResourceLocation("block/purple_concrete");
    public static final ResourceLocation EAST_SOUTH_DOWN_CENTER = new ResourceLocation("block/blue_concrete");
    public static final ResourceLocation EAST_NORTH_DOWN_CENTER = new ResourceLocation("block/brown_concrete");
    public static final ResourceLocation WEST_NORTH_CENTER = new ResourceLocation("block/green_concrete");
    public static final ResourceLocation WEST_SOUTH_CENTER = new ResourceLocation("block/red_concrete");
    public static final ResourceLocation WEST_SOUTH_UP_CENTER = new ResourceLocation("block/black_concrete");
    public static final ResourceLocation WEST_NORTH_UP_CENTER = new ResourceLocation("block/glowstone");
    public static final ResourceLocation WEST_SOUTH_DOWN_CENTER = new ResourceLocation("block/cherry_planks");
    public static final ResourceLocation WEST_NORTH_DOWN_CENTER = new ResourceLocation("block/shroomlight");
    private MaterialTextureData textureDataCache = new MaterialTextureData(Map.of());
    private final Map<ResourceLocation, Block> textureMapping = new TreeMap<ResourceLocation, Block>();
    private Object2BooleanOpenHashMap<DynamicTimberFrameBlock.Offset> offsets = new Object2BooleanOpenHashMap();
    private Block centerBlock;
    private Block frameBlock;
    private boolean checkedAfterStartup = false;
    @NotNull
    private MaterialTextureData originalTextureData = new MaterialTextureData(new HashMap<ResourceLocation, Block>());

    public DynamicTimberFrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.DYNAMIC_TIMBERFRAME.get(), pos, state);
        this.centerBlock = Blocks.f_50705_;
        this.frameBlock = Blocks.f_50745_;
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(Objects.requireNonNull(packet.m_131708_()));
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("originalTextureData", (Tag)this.originalTextureData.serializeNBT());
        compound.m_128359_("primaryBlock", ForgeRegistries.BLOCKS.getKey((Object)this.centerBlock).toString());
        compound.m_128359_("secondaryBlock", ForgeRegistries.BLOCKS.getKey((Object)this.frameBlock).toString());
        ListTag listTag = new ListTag();
        for (Object2BooleanMap.Entry mapEntry : this.offsets.object2BooleanEntrySet()) {
            CompoundTag localCompound = new CompoundTag();
            localCompound.m_128405_("offset", ((DynamicTimberFrameBlock.Offset)((Object)mapEntry.getKey())).ordinal());
            localCompound.m_128379_("bool", mapEntry.getBooleanValue());
            listTag.add((Object)localCompound);
        }
        compound.m_128365_("offsets", (Tag)listTag);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        ResourceLocation secondaryBlockName;
        ResourceLocation primaryBlockName;
        super.m_142466_(nbt);
        if (nbt.m_128441_("originalTextureData")) {
            this.originalTextureData.deserializeNBT(nbt.m_128469_("originalTextureData"));
        }
        if (ForgeRegistries.BLOCKS.getValue(primaryBlockName = new ResourceLocation(nbt.m_128461_("primaryBlock"))) != Blocks.f_50016_) {
            this.centerBlock = (Block)ForgeRegistries.BLOCKS.getValue(primaryBlockName);
        }
        if (ForgeRegistries.BLOCKS.getValue(secondaryBlockName = new ResourceLocation(nbt.m_128461_("secondaryBlock"))) != Blocks.f_50016_) {
            this.frameBlock = (Block)ForgeRegistries.BLOCKS.getValue(secondaryBlockName);
        }
        this.offsets.clear();
        for (Tag tag : nbt.m_128437_("offsets", 10)) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.offsets.put((Object)DynamicTimberFrameBlock.Offset.values()[compoundTag.m_128451_("offset")], compoundTag.m_128471_("bool"));
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.refreshTextureCache();
        }
    }

    @Override
    public void updateTextureDataWith(MaterialTextureData materialTextureData) {
        this.centerBlock = materialTextureData.getTexturedComponents().get(new ResourceLocation("block/dark_oak_planks"));
        this.frameBlock = materialTextureData.getTexturedComponents().get(new ResourceLocation("block/oak_planks"));
        this.handleTextureMapping();
        this.originalTextureData = materialTextureData;
    }

    private void handleTextureMapping() {
        this.textureMapping.put(NORTH_UP, this.frameBlock);
        this.textureMapping.put(NORTH_DOWN, this.frameBlock);
        this.textureMapping.put(SOUTH_UP, this.frameBlock);
        this.textureMapping.put(SOUTH_DOWN, this.frameBlock);
        this.textureMapping.put(EAST_DOWN, this.frameBlock);
        this.textureMapping.put(EAST_UP, this.frameBlock);
        this.textureMapping.put(WEST_DOWN, this.frameBlock);
        this.textureMapping.put(WEST_UP, this.frameBlock);
        this.textureMapping.put(NORTH_EAST_DOWN, this.frameBlock);
        this.textureMapping.put(NORTH_EAST_UP, this.frameBlock);
        this.textureMapping.put(NORTH_EAST_CORNER, this.frameBlock);
        this.textureMapping.put(NORTH_WEST_DOWN, this.frameBlock);
        this.textureMapping.put(NORTH_WEST_UP, this.frameBlock);
        this.textureMapping.put(NORTH_WEST_CORNER, this.frameBlock);
        this.textureMapping.put(SOUTH_EAST_DOWN, this.frameBlock);
        this.textureMapping.put(SOUTH_EAST_UP, this.frameBlock);
        this.textureMapping.put(SOUTH_EAST_CORNER, this.frameBlock);
        this.textureMapping.put(SOUTH_WEST_DOWN, this.frameBlock);
        this.textureMapping.put(SOUTH_WEST_UP, this.frameBlock);
        this.textureMapping.put(SOUTH_WEST_CORNER, this.frameBlock);
        this.textureMapping.put(CENTER, this.centerBlock);
        this.textureMapping.put(BOTTOM_CENTER, this.centerBlock);
        this.textureMapping.put(BOTTOM_SOUTH_CENTER, this.centerBlock);
        this.textureMapping.put(BOTTOM_NORTH_CENTER, this.centerBlock);
        this.textureMapping.put(TOP_NORTH_CENTER, this.centerBlock);
        this.textureMapping.put(TOP_SOUTH_CENTER, this.centerBlock);
        this.textureMapping.put(TOP_CENTER, this.centerBlock);
        this.textureMapping.put(NORTH_WEST_CENTER, Blocks.f_50016_);
        this.textureMapping.put(NORTH_EAST_CENTER, Blocks.f_50016_);
        this.textureMapping.put(NORTH_WEST_UP_CENTER, Blocks.f_50016_);
        this.textureMapping.put(NORTH_EAST_UP_CENTER, Blocks.f_50016_);
        this.textureMapping.put(NORTH_EAST_DOWN_CENTER, Blocks.f_50016_);
        this.textureMapping.put(NORTH_WEST_DOWN_CENTER, Blocks.f_50016_);
        this.textureMapping.put(SOUTH_EAST_CENTER, Blocks.f_50016_);
        this.textureMapping.put(SOUTH_WEST_CENTER, Blocks.f_50016_);
        this.textureMapping.put(SOUTH_WEST_UP_CENTER, Blocks.f_50016_);
        this.textureMapping.put(SOUTH_EAST_UP_CENTER, Blocks.f_50016_);
        this.textureMapping.put(SOUTH_EAST_DOWN_CENTER, Blocks.f_50016_);
        this.textureMapping.put(SOUTH_WEST_DOWN_CENTER, Blocks.f_50016_);
        this.textureMapping.put(EAST_NORTH_CENTER, Blocks.f_50016_);
        this.textureMapping.put(EAST_SOUTH_CENTER, Blocks.f_50016_);
        this.textureMapping.put(EAST_SOUTH_UP_CENTER, Blocks.f_50016_);
        this.textureMapping.put(EAST_NORTH_UP_CENTER, Blocks.f_50016_);
        this.textureMapping.put(EAST_SOUTH_DOWN_CENTER, Blocks.f_50016_);
        this.textureMapping.put(EAST_NORTH_DOWN_CENTER, Blocks.f_50016_);
        this.textureMapping.put(WEST_NORTH_CENTER, Blocks.f_50016_);
        this.textureMapping.put(WEST_SOUTH_CENTER, Blocks.f_50016_);
        this.textureMapping.put(WEST_SOUTH_UP_CENTER, Blocks.f_50016_);
        this.textureMapping.put(WEST_NORTH_UP_CENTER, Blocks.f_50016_);
        this.textureMapping.put(WEST_SOUTH_DOWN_CENTER, Blocks.f_50016_);
        this.textureMapping.put(WEST_NORTH_DOWN_CENTER, Blocks.f_50016_);
    }

    public void refreshTextureCache() {
        this.textureMapping.clear();
        this.handleTextureMapping();
        for (Object2BooleanMap.Entry offset : this.offsets.object2BooleanEntrySet()) {
            if (!offset.getBooleanValue()) continue;
            switch ((DynamicTimberFrameBlock.Offset)((Object)offset.getKey())) {
                case UP: {
                    this.textureMapping.put(NORTH_UP, Blocks.f_50016_);
                    this.textureMapping.put(EAST_UP, Blocks.f_50016_);
                    this.textureMapping.put(SOUTH_UP, Blocks.f_50016_);
                    this.textureMapping.put(WEST_UP, Blocks.f_50016_);
                    break;
                }
                case DOWN: {
                    this.textureMapping.put(NORTH_DOWN, Blocks.f_50016_);
                    this.textureMapping.put(EAST_DOWN, Blocks.f_50016_);
                    this.textureMapping.put(SOUTH_DOWN, Blocks.f_50016_);
                    this.textureMapping.put(WEST_DOWN, Blocks.f_50016_);
                    break;
                }
                case EAST: {
                    this.textureMapping.put(NORTH_EAST_CORNER, Blocks.f_50016_);
                    this.textureMapping.put(SOUTH_EAST_CORNER, Blocks.f_50016_);
                    this.textureMapping.put(SOUTH_EAST_CENTER, this.centerBlock);
                    this.textureMapping.put(NORTH_EAST_CENTER, this.centerBlock);
                    break;
                }
                case WEST: {
                    this.textureMapping.put(NORTH_WEST_CORNER, Blocks.f_50016_);
                    this.textureMapping.put(SOUTH_WEST_CORNER, Blocks.f_50016_);
                    this.textureMapping.put(SOUTH_WEST_CENTER, this.centerBlock);
                    this.textureMapping.put(NORTH_WEST_CENTER, this.centerBlock);
                    break;
                }
                case NORTH: {
                    this.textureMapping.put(NORTH_EAST_CORNER, Blocks.f_50016_);
                    this.textureMapping.put(NORTH_WEST_CORNER, Blocks.f_50016_);
                    this.textureMapping.put(EAST_NORTH_CENTER, this.centerBlock);
                    this.textureMapping.put(WEST_NORTH_CENTER, this.centerBlock);
                    break;
                }
                case SOUTH: {
                    this.textureMapping.put(SOUTH_EAST_CORNER, Blocks.f_50016_);
                    this.textureMapping.put(SOUTH_WEST_CORNER, Blocks.f_50016_);
                    this.textureMapping.put(EAST_SOUTH_CENTER, this.centerBlock);
                    this.textureMapping.put(WEST_SOUTH_CENTER, this.centerBlock);
                }
            }
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.NORTH)) {
            this.textureMapping.put(NORTH_UP, this.centerBlock);
            this.textureMapping.put(NORTH_DOWN, this.centerBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.SOUTH)) {
            this.textureMapping.put(SOUTH_UP, this.centerBlock);
            this.textureMapping.put(SOUTH_DOWN, this.centerBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.EAST)) {
            this.textureMapping.put(EAST_UP, this.centerBlock);
            this.textureMapping.put(EAST_DOWN, this.centerBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.WEST)) {
            this.textureMapping.put(WEST_UP, this.centerBlock);
            this.textureMapping.put(WEST_DOWN, this.centerBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.EAST) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP_EAST)) {
                this.textureMapping.put(SOUTH_EAST_UP, Blocks.f_50016_);
                this.textureMapping.put(NORTH_EAST_UP, Blocks.f_50016_);
                this.textureMapping.put(SOUTH_EAST_UP_CENTER, this.centerBlock);
                this.textureMapping.put(NORTH_EAST_UP_CENTER, this.centerBlock);
            }
            this.textureMapping.put(EAST_UP, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.NORTH) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP_NORTH)) {
                this.textureMapping.put(NORTH_WEST_UP, Blocks.f_50016_);
                this.textureMapping.put(NORTH_EAST_UP, Blocks.f_50016_);
                this.textureMapping.put(WEST_NORTH_UP_CENTER, this.centerBlock);
                this.textureMapping.put(EAST_NORTH_UP_CENTER, this.centerBlock);
            }
            this.textureMapping.put(NORTH_UP, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.SOUTH) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP_SOUTH)) {
                this.textureMapping.put(SOUTH_WEST_UP, Blocks.f_50016_);
                this.textureMapping.put(SOUTH_EAST_UP, Blocks.f_50016_);
                this.textureMapping.put(EAST_SOUTH_UP_CENTER, this.centerBlock);
                this.textureMapping.put(WEST_SOUTH_UP_CENTER, this.centerBlock);
            }
            this.textureMapping.put(SOUTH_UP, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.WEST) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.UP_WEST)) {
                this.textureMapping.put(NORTH_WEST_UP, Blocks.f_50016_);
                this.textureMapping.put(SOUTH_WEST_UP, Blocks.f_50016_);
                this.textureMapping.put(NORTH_WEST_UP_CENTER, this.centerBlock);
                this.textureMapping.put(SOUTH_WEST_UP_CENTER, this.centerBlock);
            }
            this.textureMapping.put(WEST_UP, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.EAST) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN_EAST)) {
                this.textureMapping.put(NORTH_EAST_DOWN, Blocks.f_50016_);
                this.textureMapping.put(SOUTH_EAST_DOWN, Blocks.f_50016_);
                this.textureMapping.put(NORTH_EAST_DOWN_CENTER, this.centerBlock);
                this.textureMapping.put(SOUTH_EAST_DOWN_CENTER, this.centerBlock);
            }
            this.textureMapping.put(EAST_DOWN, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.NORTH) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN_NORTH)) {
                this.textureMapping.put(NORTH_WEST_DOWN, Blocks.f_50016_);
                this.textureMapping.put(NORTH_EAST_DOWN, Blocks.f_50016_);
                this.textureMapping.put(WEST_NORTH_DOWN_CENTER, this.centerBlock);
                this.textureMapping.put(EAST_NORTH_DOWN_CENTER, this.centerBlock);
            }
            this.textureMapping.put(NORTH_DOWN, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.SOUTH) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN_SOUTH)) {
                this.textureMapping.put(SOUTH_WEST_DOWN, Blocks.f_50016_);
                this.textureMapping.put(SOUTH_EAST_DOWN, Blocks.f_50016_);
                this.textureMapping.put(WEST_SOUTH_DOWN_CENTER, this.centerBlock);
                this.textureMapping.put(EAST_SOUTH_DOWN_CENTER, this.centerBlock);
            }
            this.textureMapping.put(SOUTH_DOWN, this.frameBlock);
        }
        if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.WEST) && this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN)) {
            if (this.offsets.getBoolean((Object)DynamicTimberFrameBlock.Offset.DOWN_WEST)) {
                this.textureMapping.put(SOUTH_WEST_DOWN, Blocks.f_50016_);
                this.textureMapping.put(NORTH_WEST_DOWN, Blocks.f_50016_);
                this.textureMapping.put(SOUTH_WEST_DOWN_CENTER, this.centerBlock);
                this.textureMapping.put(NORTH_WEST_DOWN_CENTER, this.centerBlock);
            }
            this.textureMapping.put(WEST_DOWN, this.frameBlock);
        }
        this.textureDataCache = new MaterialTextureData(this.textureMapping);
        this.requestModelDataUpdate();
        if (this.f_58857_ != null) {
            this.m_6596_();
            this.f_58857_.m_6325_(this.f_58858_.m_123341_() >> 4, this.f_58858_.m_123343_() >> 4).m_8092_(true);
            this.f_58857_.m_7260_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_(), 3);
        }
    }

    @NotNull
    public ModelData getModelData() {
        if (!this.checkedAfterStartup && this.f_58857_ != null) {
            this.checkedAfterStartup = true;
            this.refreshTextureCache();
        }
        return ModelData.builder().with(ModProperties.MATERIAL_TEXTURE_PROPERTY, (Object)this.textureDataCache).build();
    }

    @Override
    @NotNull
    public MaterialTextureData getTextureData() {
        return this.originalTextureData;
    }

    public void onNeighborUpdate(DynamicTimberFrameBlockEntity newNeighbor, DynamicTimberFrameBlock.Offset offset, boolean added) {
        if (newNeighbor != null && (newNeighbor.frameBlock != this.frameBlock || newNeighbor.centerBlock != this.centerBlock)) {
            return;
        }
        this.offsets.put((Object)offset, added);
        this.refreshTextureCache();
    }

    public void resetOffsets() {
        this.offsets.clear();
    }

    public Block getFrameBlock() {
        return this.frameBlock;
    }

    public Block getCenterBlock() {
        return this.centerBlock;
    }

    public void rotate(int rotation) {
        Object2BooleanOpenHashMap resultMap = new Object2BooleanOpenHashMap();
        for (Map.Entry entry : this.offsets.entrySet()) {
            DynamicTimberFrameBlock.Offset offset = (DynamicTimberFrameBlock.Offset)((Object)entry.getKey());
            for (int i = 0; i < rotation; ++i) {
                offset = offset.rotate();
            }
            resultMap.put((Object)offset, (Boolean)entry.getValue());
        }
        this.offsets.clear();
        this.offsets.putAll((Map)resultMap);
    }
}

