/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import java.text.DecimalFormat;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ElementProgress
implements IElement {
    private final long current;
    private final long max;
    private final IProgressStyle style;
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    public ElementProgress(long current, long max, IProgressStyle style) {
        this.current = current;
        this.max = max;
        this.style = style;
    }

    public ElementProgress(FriendlyByteBuf buf) {
        this.current = buf.readLong();
        this.max = buf.readLong();
        this.style = new ProgressStyle().width(buf.readInt()).height(buf.readInt()).prefix(buf.m_130238_()).suffix(buf.m_130238_()).borderColor(buf.readInt()).filledColor(buf.readInt()).alternateFilledColor(buf.readInt()).backgroundColor(buf.readInt()).showText(buf.readBoolean()).numberFormat(NumberFormat.values()[buf.readByte()]).lifeBar(buf.readBoolean()).armorBar(buf.readBoolean()).alignment((ElementAlignment)buf.m_130066_(ElementAlignment.class));
    }

    public IProgressStyle getStyle() {
        return this.style;
    }

    public static Component format(long in, NumberFormat style, Component suffix) {
        switch (style) {
            case FULL: {
                return Component.m_237113_((String)Long.toString(in)).m_7220_(suffix);
            }
            case COMPACT: {
                if (in < 1000L) {
                    return Component.m_237113_((String)(Long.toString(in) + " ")).m_7220_(suffix);
                }
                int unit = 1000;
                int exp = (int)(Math.log(in) / Math.log(unit));
                String s = suffix.getString();
                if (s.startsWith("m")) {
                    s = s.substring(1);
                    if (exp - 2 >= 0) {
                        char pre = "kMGTPE".charAt(exp - 2);
                        return Component.m_237113_((String)String.format("%.1f %s", (double)in / Math.pow(unit, exp), Character.valueOf(pre))).m_7220_((Component)Component.m_237113_((String)s).m_130948_(suffix.m_7383_()));
                    }
                    return Component.m_237113_((String)String.format("%.1f", (double)in / Math.pow(unit, exp))).m_7220_((Component)Component.m_237113_((String)s).m_130948_(suffix.m_7383_()));
                }
                char pre = "kMGTPE".charAt(exp - 1);
                return Component.m_237113_((String)String.format("%.1f %s", (double)in / Math.pow(unit, exp), Character.valueOf(pre))).m_7220_(suffix);
            }
            case COMMAS: {
                return Component.m_237113_((String)dfCommas.format(in)).m_7220_(suffix);
            }
            case NONE: {
                return suffix;
            }
        }
        return Component.m_237113_((String)Long.toString(in));
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        ElementProgressRender.render(this.style, this.current, this.max, graphics, x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public int getWidth() {
        if (this.style.isLifeBar()) {
            if (this.current * 4L >= (long)this.style.getWidth()) {
                return 100;
            }
            return (int)(this.current * 4L + 2L);
        }
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeLong(this.current);
        buf.writeLong(this.max);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.m_130083_(this.style.getPrefixComp());
        buf.m_130083_(this.style.getSuffixComp());
        buf.writeInt(this.style.getBorderColor());
        buf.writeInt(this.style.getFilledColor());
        buf.writeInt(this.style.getAlternatefilledColor());
        buf.writeInt(this.style.getBackgroundColor());
        buf.writeBoolean(this.style.isShowText());
        buf.writeByte(this.style.getNumberFormat().ordinal());
        buf.writeBoolean(this.style.isLifeBar());
        buf.writeBoolean(this.style.isArmorBar());
        buf.m_130068_((Enum)this.style.getAlignment());
    }

    @Override
    public ResourceLocation getID() {
        return TheOneProbeImp.ELEMENT_PROGRESS;
    }
}

