/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IEntityStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementEntityRender;
import mcjty.theoneprobe.apiimpl.styles.EntityStyle;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class ElementEntity
implements IElement {
    private final String entityName;
    private final Integer playerID;
    private final CompoundTag entityNBT;
    private final IEntityStyle style;

    public ElementEntity(String entityName, IEntityStyle style) {
        this.entityName = entityName;
        this.entityNBT = null;
        this.style = style;
        this.playerID = null;
    }

    public ElementEntity(Entity entity, IEntityStyle style) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.entityNBT = null;
            this.playerID = player.m_19879_();
        } else {
            this.entityNBT = new CompoundTag();
            entity.m_20240_(this.entityNBT);
            this.playerID = null;
        }
        ResourceLocation registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (registryName == null) {
            registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        }
        this.entityName = registryName == null ? "<null>" : registryName.toString();
        this.style = style;
    }

    public ElementEntity(FriendlyByteBuf buf) {
        this.entityName = NetworkTools.readString(buf);
        this.style = new EntityStyle().width(buf.readInt()).height(buf.readInt()).scale(buf.readFloat());
        this.entityNBT = buf.m_130260_();
        this.playerID = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        if (this.playerID != null) {
            ElementEntityRender.renderPlayer(this.entityName, this.playerID, this.style, graphics, x, y);
        } else {
            ElementEntityRender.render(this.entityName, this.entityNBT, this.style, graphics, x, y);
        }
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        NetworkTools.writeString(buf, this.entityName);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.writeFloat(this.style.getScale());
        buf.m_130079_(this.entityNBT);
        if (this.playerID != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.playerID.intValue());
        } else {
            buf.writeBoolean(false);
        }
    }

    @Override
    public ResourceLocation getID() {
        return TheOneProbeImp.ELEMENT_ENTITY;
    }
}

