/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IEntityDisplayOverride;
import mcjty.theoneprobe.api.IOverlayRenderer;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.IStyleManager;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.apiimpl.DefaultOverlayRenderer;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.apiimpl.elements.ElementEntity;
import mcjty.theoneprobe.apiimpl.elements.ElementHorizontal;
import mcjty.theoneprobe.apiimpl.elements.ElementIcon;
import mcjty.theoneprobe.apiimpl.elements.ElementItemLabel;
import mcjty.theoneprobe.apiimpl.elements.ElementItemStack;
import mcjty.theoneprobe.apiimpl.elements.ElementPadding;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.apiimpl.elements.ElementTank;
import mcjty.theoneprobe.apiimpl.elements.ElementText;
import mcjty.theoneprobe.apiimpl.elements.ElementVertical;
import mcjty.theoneprobe.apiimpl.styles.StyleManager;
import mcjty.theoneprobe.config.Config;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class TheOneProbeImp
implements ITheOneProbe {
    public static final ResourceLocation ELEMENT_TEXT = new ResourceLocation("theoneprobe", "text");
    public static final ResourceLocation ELEMENT_ITEM = new ResourceLocation("theoneprobe", "item");
    public static final ResourceLocation ELEMENT_PROGRESS = new ResourceLocation("theoneprobe", "progress");
    public static final ResourceLocation ELEMENT_HORIZONTAL = new ResourceLocation("theoneprobe", "hor");
    public static final ResourceLocation ELEMENT_VERTICAL = new ResourceLocation("theoneprobe", "ver");
    public static final ResourceLocation ELEMENT_ENTITY = new ResourceLocation("theoneprobe", "ent");
    public static final ResourceLocation ELEMENT_ICON = new ResourceLocation("theoneprobe", "icon");
    public static final ResourceLocation ELEMENT_ITEMLABEL = new ResourceLocation("theoneprobe", "itemlabel");
    public static final ResourceLocation ELEMENT_TANK = new ResourceLocation("theoneprobe", "tank");
    public static final ResourceLocation ELEMENT_PADDING = new ResourceLocation("theoneprobe", "pad");
    private final StyleManager styleManager = new StyleManager();
    private List<IProbeConfigProvider> configProviders = new ArrayList<IProbeConfigProvider>();
    private List<IProbeInfoProvider> providers = new ArrayList<IProbeInfoProvider>();
    private List<IProbeInfoEntityProvider> entityProviders = new ArrayList<IProbeInfoEntityProvider>();
    private List<IBlockDisplayOverride> blockOverrides = new ArrayList<IBlockDisplayOverride>();
    private List<IEntityDisplayOverride> entityOverrides = new ArrayList<IEntityDisplayOverride>();
    private Map<ResourceLocation, IElementFactory> factories = new HashMap<ResourceLocation, IElementFactory>();

    private static IElementFactory create(final ResourceLocation id, final Function<FriendlyByteBuf, IElement> factory) {
        return new IElementFactory(){

            @Override
            public IElement createElement(FriendlyByteBuf buf) {
                return (IElement)factory.apply(buf);
            }

            @Override
            public ResourceLocation getId() {
                return id;
            }
        };
    }

    public static void registerElements() {
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_TEXT, ElementText::new));
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_ITEM, ElementItemStack::new));
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_PROGRESS, ElementProgress::new));
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_HORIZONTAL, ElementHorizontal::new));
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_VERTICAL, ElementVertical::new));
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_ENTITY, ElementEntity::new));
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_ICON, ElementIcon::new));
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_ITEMLABEL, ElementItemLabel::new));
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_TANK, ElementTank::new));
        TheOneProbe.theOneProbeImp.registerElementFactory(TheOneProbeImp.create(ELEMENT_PADDING, ElementPadding::new));
    }

    private int findProvider(ResourceLocation id) {
        for (int i = 0; i < this.providers.size(); ++i) {
            if (!id.equals((Object)this.providers.get(i).getID())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void registerProvider(IProbeInfoProvider provider) {
        int idx = this.findProvider(provider.getID());
        if (idx != -1) {
            this.providers.set(idx, provider);
        } else {
            this.providers.add(provider);
        }
    }

    private int findEntityProvider(String id) {
        for (int i = 0; i < this.entityProviders.size(); ++i) {
            if (!id.equals(this.entityProviders.get(i).getID())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void registerEntityProvider(IProbeInfoEntityProvider provider) {
        int idx = this.findEntityProvider(provider.getID());
        if (idx != -1) {
            this.entityProviders.set(idx, provider);
        } else {
            this.entityProviders.add(provider);
        }
    }

    @Override
    public IElementFactory getElementFactory(ResourceLocation id) {
        return this.factories.get(id);
    }

    public ProbeInfo create() {
        return new ProbeInfo();
    }

    public List<IProbeInfoProvider> getProviders() {
        return this.providers;
    }

    public List<IProbeInfoEntityProvider> getEntityProviders() {
        return this.entityProviders;
    }

    private IProbeInfoProvider getProviderByID(ResourceLocation id) {
        for (IProbeInfoProvider provider : this.providers) {
            if (!provider.getID().equals((Object)id)) continue;
            return provider;
        }
        return null;
    }

    private IProbeInfoEntityProvider getEntityProviderByID(String id) {
        for (IProbeInfoEntityProvider provider : this.entityProviders) {
            if (!provider.getID().equals(id)) continue;
            return provider;
        }
        return null;
    }

    public void configureProviders(ResourceLocation[] sortedProviders, Set<String> excludedProviders) {
        ArrayList<IProbeInfoProvider> newProviders = new ArrayList<IProbeInfoProvider>();
        for (ResourceLocation id : sortedProviders) {
            IProbeInfoProvider provider;
            if (excludedProviders.contains(id) || (provider = this.getProviderByID(id)) == null) continue;
            newProviders.add(provider);
        }
        for (IProbeInfoProvider provider : this.providers) {
            if (newProviders.contains(provider) || excludedProviders.contains(provider.getID())) continue;
            newProviders.add(provider);
        }
        this.providers = newProviders;
    }

    public void configureEntityProviders(String[] sortedProviders, Set<String> excludedProviders) {
        ArrayList<IProbeInfoEntityProvider> newProviders = new ArrayList<IProbeInfoEntityProvider>();
        for (String id : sortedProviders) {
            IProbeInfoEntityProvider provider;
            if (excludedProviders.contains(id) || (provider = this.getEntityProviderByID(id)) == null) continue;
            newProviders.add(provider);
        }
        for (IProbeInfoEntityProvider provider : this.entityProviders) {
            if (newProviders.contains(provider) || excludedProviders.contains(provider.getID())) continue;
            newProviders.add(provider);
        }
        this.entityProviders = newProviders;
    }

    @Override
    public void registerElementFactory(IElementFactory factory) {
        this.factories.put(factory.getId(), factory);
    }

    @Override
    public IOverlayRenderer getOverlayRenderer() {
        return new DefaultOverlayRenderer();
    }

    @Override
    public IProbeConfig createProbeConfig() {
        return Config.getDefaultConfig().lazyCopy();
    }

    @Override
    public void registerProbeConfigProvider(IProbeConfigProvider provider) {
        this.configProviders.add(provider);
    }

    public List<IProbeConfigProvider> getConfigProviders() {
        return this.configProviders;
    }

    @Override
    public void registerBlockDisplayOverride(IBlockDisplayOverride override) {
        this.blockOverrides.add(override);
    }

    public List<IBlockDisplayOverride> getBlockOverrides() {
        return this.blockOverrides;
    }

    @Override
    public void registerEntityDisplayOverride(IEntityDisplayOverride override) {
        this.entityOverrides.add(override);
    }

    public List<IEntityDisplayOverride> getEntityOverrides() {
        return this.entityOverrides;
    }

    @Override
    public IStyleManager getStyleManager() {
        return this.styleManager;
    }
}

