/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageShaderManual
implements IMessage {
    private MessageType key;
    private ResourceLocation[] args;

    public MessageShaderManual(MessageType key, ResourceLocation ... args) {
        this.key = key;
        this.args = args;
    }

    public MessageShaderManual(FriendlyByteBuf buf) {
        this.key = MessageType.values()[buf.readInt()];
        int l = buf.readInt();
        this.args = new ResourceLocation[l];
        for (int i = 0; i < l; ++i) {
            this.args[i] = new ResourceLocation(buf.m_130136_(1000));
        }
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.key.ordinal());
        if (this.args != null) {
            buf.writeInt(this.args.length);
            for (ResourceLocation rl : this.args) {
                buf.m_130070_(rl.toString());
            }
        } else {
            buf.writeInt(0);
        }
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ServerPlayer player = ctx.getSender();
            assert (player != null);
            UUID playerId = player.m_20148_();
            ctx.enqueueWork(() -> {
                if (this.key == MessageType.SYNC) {
                    Collection received = ShaderRegistry.receivedShaders.get((Object)playerId);
                    ResourceLocation[] ss = received.toArray(new ResourceLocation[0]);
                    ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageShaderManual(MessageType.SYNC, ss));
                } else if (this.key == MessageType.UNLOCK && this.args.length > 0) {
                    ShaderRegistry.receivedShaders.put((Object)playerId, (Object)this.args[0]);
                } else if (this.key == MessageType.SPAWN && this.args.length > 0) {
                    if (!player.m_150110_().f_35937_) {
                        IngredientUtils.consumePlayerIngredient((Player)player, ShaderRegistry.shaderRegistry.get((Object)this.args[0]).replicationCost.get());
                    }
                    ItemStack shaderStack = new ItemStack((ItemLike)ShaderRegistry.itemShader);
                    ItemNBTHelper.putString(shaderStack, "shader_name", this.args[0].toString());
                    ItemEntity entityitem = player.m_36176_(shaderStack, false);
                    if (entityitem != null) {
                        entityitem.m_32061_();
                        entityitem.m_32052_(player.m_20148_());
                    }
                }
            });
        } else {
            ctx.enqueueWork(() -> {
                Player player;
                if (this.key == MessageType.SYNC && (player = ImmersiveEngineering.proxy.getClientPlayer()) != null) {
                    UUID name = player.m_20148_();
                    for (ResourceLocation shader : this.args) {
                        if (shader == null) continue;
                        ShaderRegistry.receivedShaders.put((Object)name, (Object)shader);
                    }
                }
            });
        }
    }

    public static enum MessageType {
        SYNC,
        UNLOCK,
        SPAWN;

    }
}

