/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.biome.builder;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.regions_unexplored.data.worldgen.RuBiomeDefaultFeatures;
import net.regions_unexplored.data.worldgen.placement.RuMiscOverworldPlacements;
import net.regions_unexplored.data.worldgen.placement.RuTreePlacements;
import net.regions_unexplored.data.worldgen.placement.RuVegetationPlacements;

public class TaigaBiomes {
    protected static final int NORMAL_WATER_COLOR = 4159204;
    protected static final int NORMAL_WATER_FOG_COLOR = 329011;
    private static final int OVERWORLD_FOG_COLOR = 12638463;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static MobSpawnSettings.Builder baseTaigaSpawning() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20499_, 8, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 4, 2, 3)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 8, 2, 4));
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        return spawnBuilder;
    }

    private static BiomeGenerationSettings.Builder baseTaigaGeneration(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter, boolean hasSweetBerries) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(featureGetter, carverGetter);
        RuBiomeDefaultFeatures.globalOverworldGeneration(biomeBuilder);
        RuBiomeDefaultFeatures.mediumGrass(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        RuBiomeDefaultFeatures.addDefaultSoftDisks(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        if (hasSweetBerries) {
            BiomeDefaultFeatures.m_194737_((BiomeGenerationSettings.Builder)biomeBuilder);
        }
        return biomeBuilder;
    }

    public static Biome blackwoodTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(11454879).m_48019_(11454879).m_48034_(3108258).m_48037_(4220035).m_48043_(4347179).m_48045_(4089639).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.005f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215732_));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, true);
        RuBiomeDefaultFeatures.blackwoodTrees(biomeBuilder);
        RuBiomeDefaultFeatures.addBlackwoodBioshrooms(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.BLACKWOOD_VEGETATION);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.BLACKWOOD_DARK_OAK_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.825f).m_47611_(0.765f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome borealTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(TaigaBiomes.calculateSkyColor(0.55f)).m_48019_(12638463).m_48034_(-12619852).m_48037_(7436392).m_48043_(8103502).m_48045_(8957796).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215732_));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.LARCH_TREE_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GOLDEN_LARCH_TREE_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIRCH_TREE_ASPEN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_LARCH_TREE);
        RuBiomeDefaultFeatures.addTaigaFlowerPatch(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.LARCH_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.5f).m_47611_(0.4f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome goldenBorealTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(TaigaBiomes.calculateSkyColor(0.65f)).m_48019_(12638463).m_48034_(-12619852).m_48037_(7436392).m_48043_(12562512).m_48045_(10400607).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215732_));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GOLDEN_LARCH_TREE_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.LARCH_TREE_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.BIRCH_TREE_ASPEN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_LARCH_TREE);
        RuBiomeDefaultFeatures.addTaigaFlowerPatch(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.GOLDEN_LARCH_SHRUB_MIX);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.45f).m_47611_(0.3f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome pineTaiga(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(TaigaBiomes.calculateSkyColor(0.7f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(7702086).m_48045_(8693594).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215732_));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, true);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_ON_DIRT);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_TALL_ON_DIRT);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.PINE_TREE_SHRUB_ON_GRASS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuMiscOverworldPlacements.FALLEN_PINE_TREE_ON_DIRT);
        RuBiomeDefaultFeatures.addTaigaFlowerPatch(biomeBuilder);
        RuBiomeDefaultFeatures.addDirtSurfaceVegetation(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.PINE_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.6f).m_47611_(0.4f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome redwoods(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(TaigaBiomes.calculateSkyColor(0.8f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(7512632).m_48045_(8240185).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215732_));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, false);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.ULTRA_REDWOOD_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_REDWOOD_TREE_DENSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.REDWOOD_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_DENSE);
        RuBiomeDefaultFeatures.redwoodDecoration(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.REDWOOD_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(1.0f).m_47611_(0.8f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static Biome sparseRedwoods(HolderGetter<PlacedFeature> featureGetter, HolderGetter<ConfiguredWorldCarver<?>> carverGetter) {
        BiomeSpecialEffects.Builder effectBuilder = new BiomeSpecialEffects.Builder().m_48040_(TaigaBiomes.calculateSkyColor(0.8f)).m_48019_(12638463).m_48034_(4159204).m_48037_(329011).m_48043_(7512632).m_48045_(8240185).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(Musics.m_263184_((Holder)SoundEvents.f_215732_));
        BiomeGenerationSettings.Builder biomeBuilder = TaigaBiomes.baseTaigaGeneration(featureGetter, carverGetter, false);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.GIANT_REDWOOD_TREE_SPARSE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.REDWOOD_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuTreePlacements.OAK_BUSH_SPARSE);
        RuBiomeDefaultFeatures.redwoodDecoration(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RuVegetationPlacements.REDWOOD_SHRUB);
        MobSpawnSettings.Builder spawnBuilder = TaigaBiomes.baseTaigaSpawning();
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.95f).m_47611_(0.8f).m_47603_(effectBuilder.m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }
}

