/*
 * Decompiled with CFR 0.152.
 */
package com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen;

import com.bisecthosting.mods.bhmenu.ModRef;
import com.bisecthosting.mods.bhmenu.config.GlobalConfigs;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.PublicServerList;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.data.ServerListData;
import com.bisecthosting.mods.bhmenu.modules.publicserverlist.screen.PublicServersScreen;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class PublicServerSelectionList
extends ObjectSelectionList<Entry> {
    static final Logger LOGGER = LogUtils.getLogger();
    static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    static final ResourceLocation ICON_OVERLAY_LOCATION = ModRef.res("textures/publicserverlist/gui/server_select_widgets.png");
    static final Component LAST_PLAYED_LABEL = Component.m_237115_((String)"modules.public_server_list.last_played_label");
    static final Component PUBLIC_SERVERS_LABEL = Component.m_237115_((String)"modules.public_server_list.public_servers_label");
    static final Component CANT_RESOLVE_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_resolve").m_130940_(ChatFormatting.DARK_RED);
    static final Component CANT_CONNECT_TEXT = Component.m_237115_((String)"multiplayer.status.cannot_connect").m_130940_(ChatFormatting.DARK_RED);
    static final Component INCOMPATIBLE_TOOLTIP = Component.m_237115_((String)"multiplayer.status.incompatible");
    static final Component NO_CONNECTION_TOOLTIP = Component.m_237115_((String)"multiplayer.status.no_connection");
    static final Component PINGING_TOOLTIP = Component.m_237115_((String)"multiplayer.status.pinging");
    static final Component NO_SERVER = Component.m_237115_((String)"modules.public_server_list.no_servers");
    static final Component FIRST_TO_ADD_SERVER = Component.m_237115_((String)"modules.public_server_list.first_server");
    private final ThreadPoolExecutor serverPingerThreadPool = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Public Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private long ticks = 15L;
    private final PublicServersScreen screen;
    protected final List<ServerData> allServers = Lists.newArrayList();
    protected final List<ServerData> pingedServers = Lists.newArrayList();
    protected final List<ServerEntry> filteredEntries = Lists.newArrayList();
    private final Header lastPlayedHeader = new Header(LAST_PLAYED_LABEL);
    private final Header pingingHeader = new PingingHeader(PUBLIC_SERVERS_LABEL);
    private final Header noServersHeader = new Header(NO_SERVER, FIRST_TO_ADD_SERVER);
    protected ServerEntry lastJoined;
    private boolean noServers;
    protected boolean filterPing;
    protected boolean filterPlayerCount;
    protected String filterName;

    public PublicServerSelectionList(PublicServersScreen parent, Minecraft minecraft, int width, int height, int y0, int y1, int itemHeight) {
        super(minecraft, width, height, y0, y1, itemHeight);
        this.screen = parent;
        this.noServersHeader.onClick(this.screen::openHowToPage);
        this.load();
    }

    protected void refreshEntries() {
        Entry lastEntry = (Entry)this.m_93511_();
        this.m_93516_();
        if (this.lastJoined != null) {
            this.m_7085_((AbstractSelectionList.Entry)this.lastPlayedHeader);
            this.m_7085_((AbstractSelectionList.Entry)this.lastJoined);
        }
        this.m_7085_((AbstractSelectionList.Entry)this.pingingHeader);
        if (this.noServers) {
            this.m_7085_((AbstractSelectionList.Entry)this.noServersHeader);
        } else {
            this.filterEntries();
            this.filteredEntries.forEach(entry -> {
                this.m_7085_((AbstractSelectionList.Entry)entry);
                if (lastEntry instanceof ServerEntry) {
                    ServerEntry lastServerEntry = (ServerEntry)lastEntry;
                    if (lastServerEntry.serverData.f_105363_.equals(entry.serverData.f_105363_)) {
                        this.setSelected((ServerEntry)((Object)entry));
                    }
                }
            });
        }
        for (Entry entry2 : this.m_6702_()) {
            if (entry2 != lastEntry) continue;
            this.m_6987_((AbstractSelectionList.Entry)entry2);
        }
        if (this.m_93517_() > (double)this.m_93518_()) {
            this.m_93410_(this.m_93518_());
        }
    }

    public void filterEntries() {
        this.filteredEntries.clear();
        Stream<ServerEntry> filtering = Lists.newArrayList(this.pingedServers).stream().filter(s -> s.f_105366_ > 0L).map(server -> new ServerEntry(this.screen, (ServerData)server));
        if (!StringUtil.m_14408_((String)this.filterName)) {
            filtering = filtering.filter(entry -> entry.serverData.f_105362_.toLowerCase(Locale.ROOT).contains(this.filterName.toLowerCase(Locale.ROOT)));
        }
        if (this.filterPlayerCount) {
            filtering = filtering.sorted((s1, s2) -> {
                int p1 = s1.serverData.f_105370_ == null ? 0 : s1.serverData.f_105370_.size();
                int p2 = s2.serverData.f_105370_ == null ? 0 : s2.serverData.f_105370_.size();
                return p2 - p1;
            });
        }
        if (this.filterPing) {
            filtering = filtering.sorted(Comparator.comparingLong(s -> s.serverData.f_105366_));
        }
        List filtered = filtering.collect(Collectors.toList());
        this.filteredEntries.addAll(filtered);
    }

    public void tick() {
        if (this.ticks++ % 20L == 0L) {
            int lastCount = this.allServers.size();
            this.allServers.removeIf(server -> {
                if (server.f_105365_.equals(CANT_CONNECT_TEXT) || server.f_105365_.equals(CANT_RESOLVE_TEXT)) {
                    return true;
                }
                if (server.f_105366_ > 0L) {
                    this.pingedServers.add((ServerData)server);
                    return true;
                }
                return false;
            });
            if (lastCount != this.allServers.size()) {
                this.refreshEntries();
            }
        }
    }

    public void setSelected(@Nullable ServerEntry entry) {
        super.m_6987_((AbstractSelectionList.Entry)entry);
        this.screen.onSelectedChange();
    }

    public boolean m_7933_(int p_99782_, int p_99783_, int p_99784_) {
        Entry entry = (Entry)this.m_93511_();
        return entry != null && entry.m_7933_(p_99782_, p_99783_, p_99784_) || super.m_7933_(p_99782_, p_99783_, p_99784_);
    }

    public void setNameFilter(String filter) {
        this.filterName = filter;
        this.refreshEntries();
    }

    public void togglePingSort() {
        this.filterPing = !this.filterPing;
        this.refreshEntries();
    }

    public void togglePlayerCountSort() {
        this.filterPlayerCount = !this.filterPlayerCount;
        this.refreshEntries();
    }

    public void updateOnlineServers(ServerListData servers) {
        if (servers.size() == 0) {
            this.noServers = true;
            this.refreshEntries();
            return;
        }
        this.noServers = false;
        this.pingedServers.clear();
        for (int i = 0; i < servers.size(); ++i) {
            ServerData server = servers.get(i);
            this.pingServer(server);
            this.allServers.add(server);
        }
        this.refreshEntries();
    }

    private void pingServer(ServerData server) {
        if (!server.f_105369_) {
            server.f_105369_ = true;
            server.f_105366_ = -2L;
            server.f_105365_ = CommonComponents.f_237098_;
            server.f_105364_ = CommonComponents.f_237098_;
            this.serverPingerThreadPool.submit(() -> {
                try {
                    this.screen.getPinger().m_105459_(server, () -> {});
                }
                catch (UnknownHostException unknownhostexception) {
                    server.f_105366_ = -1L;
                    server.f_105365_ = CANT_RESOLVE_TEXT;
                }
                catch (Exception exception) {
                    server.f_105366_ = -1L;
                    server.f_105365_ = CANT_CONNECT_TEXT;
                }
            });
        }
    }

    protected int m_5756_() {
        return this.f_93392_ - 4;
    }

    public int m_5759_() {
        return (int)((float)this.screen.f_96543_ * 0.6f) - 8;
    }

    public boolean m_93696_() {
        return this.screen.m_7222_() == this;
    }

    public void setLastJoined(ServerEntry entry) {
        this.lastJoined = new ServerEntry(this.screen, entry.serverData);
        this.save();
        this.refreshEntries();
    }

    public void save() {
        try {
            File configFolder = GlobalConfigs.MOD_CONFIG_FOLDER;
            File temp = File.createTempFile("last_joined", ".dat", configFolder);
            NbtIo.m_128955_((CompoundTag)this.lastJoined.getServerData().m_105378_(), (File)temp);
            File old = new File(configFolder, "last_joined.dat_old");
            File current = new File(configFolder, "last_joined.dat");
            Util.m_137462_((File)current, (File)temp, (File)old);
        }
        catch (Exception exception) {
            PublicServerList.LOGGER.error("Couldn't save last joined server", (Throwable)exception);
        }
    }

    public void load() {
        try {
            File configFolder = GlobalConfigs.MOD_CONFIG_FOLDER;
            CompoundTag tag = NbtIo.m_128953_((File)new File(configFolder, "last_joined.dat"));
            if (tag != null) {
                ServerData serverdata = ServerData.m_105385_((CompoundTag)tag);
                this.pingServer(serverdata);
                this.lastJoined = new ServerEntry(this.screen, serverdata);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load last joined server", (Throwable)exception);
        }
    }

    public void stopPingingServer() {
        this.serverPingerThreadPool.shutdownNow();
    }

    public static class Header
    extends Entry {
        protected final Minecraft minecraft = Minecraft.m_91087_();
        protected final Component[] displays;
        protected MutableComponent allDisplays;
        private Runnable click;

        public Header(Component ... displays) {
            this.displays = displays;
            this.allDisplays = displays[0].m_6881_();
            for (int i = 1; i < displays.length; ++i) {
                this.allDisplays.m_7220_(displays[i]);
            }
        }

        private Header onClick(Runnable onClick) {
            this.click = onClick;
            return this;
        }

        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            int n = top + innerHeight / 2;
            int n2 = this.displays.length;
            Objects.requireNonNull(this.minecraft.f_91062_);
            int drawY = n - n2 * 9 / 2;
            for (Component display : this.displays) {
                graphics.m_280430_(this.minecraft.f_91062_, display, left + (width - this.minecraft.f_91062_.m_92852_((FormattedText)display)) / 2, drawY, 0xFFFFFF);
                Objects.requireNonNull(this.minecraft.f_91062_);
                drawY += 9;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.click != null && this.m_5953_(mouseX, mouseY) && button == 0) {
                this.click.run();
            }
            return false;
        }

        public Component m_142172_() {
            return this.allDisplays;
        }
    }

    public class PingingHeader
    extends Header {
        public PingingHeader(Component display) {
            super(display);
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            super.m_6311_(graphics, index, top, left, width, innerHeight, mouseX, mouseY, hovered, delta);
            int drawY = top + innerHeight / 2 - 4;
            if (PublicServerSelectionList.this.allServers.isEmpty()) {
                return;
            }
            String s = switch ((int)(Util.m_137550_() / 300L % 4L)) {
                default -> "O o o";
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
            };
            graphics.m_280488_(this.minecraft.f_91062_, s, left + width - this.minecraft.f_91062_.m_92895_(s) - 7, drawY, 0xFFFFFF);
        }
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }

    public class ServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int ICON_TEX_WIDTH = 64;
        private static final int ICON_TEX_HEIGHT = 64;
        private static final int ICON_OVERLAY_X_PLAY = 0;
        private static final int ICON_OVERLAY_X_ADD = 32;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private final PublicServersScreen screen;
        private final Minecraft minecraft;
        private final ServerData serverData;
        private final ResourceLocation iconLocation;
        @Nullable
        private byte[] lastIconBytes;
        @Nullable
        private DynamicTexture icon;
        protected long lastClickTime;

        protected ServerEntry(PublicServersScreen screen, ServerData data) {
            this.screen = screen;
            this.serverData = data;
            this.minecraft = Minecraft.m_91087_();
            this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)data.f_105363_) + "/icon");
            AbstractTexture abstracttexture = this.minecraft.m_91097_().m_174786_(this.iconLocation, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
            if (abstracttexture != MissingTextureAtlasSprite.m_118080_() && abstracttexture instanceof DynamicTexture) {
                this.icon = (DynamicTexture)abstracttexture;
            }
        }

        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int width, int innerHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            List playerList;
            Component pingTooltip;
            int signal;
            int mouseOverX = mouseX - left;
            int mouseOverY = mouseY - top;
            boolean invalidVersion = this.serverData.f_105367_ != SharedConstants.m_183709_().m_132495_();
            graphics.m_280488_(this.minecraft.f_91062_, this.serverData.f_105362_, left + 32 + 3, top + 1, 0xFFFFFF);
            List list = this.minecraft.f_91062_.m_92923_((FormattedText)this.serverData.f_105365_, width - 32 - 2);
            for (int i = 0; i < Math.min(list.size(), 2); ++i) {
                graphics.m_280648_(this.minecraft.f_91062_, (FormattedCharSequence)list.get(i), left + 32 + 3, top + 12 + 9 * i, 0x808080);
            }
            Component invalidVersionErrorText = invalidVersion ? this.serverData.f_105368_.m_6881_().m_130940_(ChatFormatting.RED) : this.serverData.f_105364_;
            int textWidth = this.minecraft.f_91062_.m_92852_((FormattedText)invalidVersionErrorText);
            graphics.m_280430_(this.minecraft.f_91062_, invalidVersionErrorText, left + width - textWidth - 15 - 2, top + 1, 0x808080);
            int signalTexOffset = 0;
            if (invalidVersion) {
                signal = 5;
                pingTooltip = INCOMPATIBLE_TOOLTIP;
                playerList = this.serverData.f_105370_;
            } else if (this.serverData.f_105369_ && this.serverData.f_105366_ != -2L) {
                signal = this.serverData.f_105366_ < 0L ? 5 : (this.serverData.f_105366_ < 150L ? 0 : (this.serverData.f_105366_ < 300L ? 1 : (this.serverData.f_105366_ < 600L ? 2 : (this.serverData.f_105366_ < 1000L ? 3 : 4))));
                if (this.serverData.f_105366_ < 0L) {
                    pingTooltip = NO_CONNECTION_TOOLTIP;
                    playerList = Collections.emptyList();
                } else {
                    pingTooltip = Component.m_237110_((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.f_105366_});
                    playerList = this.serverData.f_105370_;
                }
            } else {
                signalTexOffset = 1;
                signal = (int)(Util.m_137550_() / 100L + (long)(index * 2) & 7L);
                if (signal > 4) {
                    signal = 8 - signal;
                }
                pingTooltip = PINGING_TOOLTIP;
                playerList = Collections.emptyList();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280163_(ModRef.Resources.GUI_ICONS_LOCATION, left + width - 15, top, (float)(signalTexOffset * 10), (float)(176 + signal * 8), 10, 8, 256, 256);
            byte[] iconBytes = this.serverData.m_271916_();
            if (!Arrays.equals(iconBytes, this.lastIconBytes)) {
                if (this.uploadServerIcon(iconBytes)) {
                    this.lastIconBytes = iconBytes;
                } else {
                    this.serverData.m_271813_(null);
                }
            }
            if (this.icon == null) {
                this.drawIcon(graphics, left, top, ICON_MISSING);
            } else {
                this.drawIcon(graphics, left, top, this.iconLocation);
            }
            if (mouseOverX >= width - 15 && mouseOverX <= width - 5 && mouseOverY >= 0 && mouseOverY <= 8) {
                this.screen.setTooltip(Collections.singletonList(pingTooltip));
            } else if (mouseOverX >= width - textWidth - 15 - 2 && mouseOverX <= width - 15 - 2 && mouseOverY >= 0 && mouseOverY <= 8) {
                this.screen.setTooltip(playerList);
            }
            if (((Boolean)this.minecraft.f_91066_.m_231828_().m_231551_()).booleanValue() || hovered) {
                graphics.m_280509_(left, top, left + 32, top + 32, -1601138544);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.canJoin()) {
                    if (mouseOverX > 16 && mouseOverX < 32) {
                        graphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 0.0f, 32.0f, 32, 32, 64, 64);
                    } else {
                        graphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 0.0f, 0.0f, 32, 32, 64, 64);
                    }
                }
                if (mouseOverX < 16) {
                    graphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 32.0f, 32.0f, 32, 32, 64, 64);
                } else {
                    graphics.m_280163_(ICON_OVERLAY_LOCATION, left, top, 32.0f, 0.0f, 32, 32, 64, 64);
                }
            }
        }

        protected void drawIcon(GuiGraphics graphics, int mouseX, int mouseY, ResourceLocation texture) {
            RenderSystem.enableBlend();
            graphics.m_280163_(texture, mouseX, mouseY, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        protected boolean canJoin() {
            return true;
        }

        private boolean uploadServerIcon(@Nullable byte[] iconBytes) {
            if (iconBytes == null) {
                this.minecraft.m_91097_().m_118513_(this.iconLocation);
                if (this.icon != null && this.icon.m_117991_() != null) {
                    this.icon.m_117991_().close();
                }
                this.icon = null;
            } else {
                try {
                    NativeImage nativeimage = NativeImage.m_271751_((byte[])iconBytes);
                    Validate.validState((nativeimage.m_84982_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeimage.m_85084_() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.icon == null) {
                        this.icon = new DynamicTexture(nativeimage);
                    } else {
                        this.icon.m_117988_(nativeimage);
                        this.icon.m_117985_();
                    }
                    this.minecraft.m_91097_().m_118495_(this.iconLocation, (AbstractTexture)this.icon);
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.f_105362_, this.serverData.f_105363_, throwable});
                    return false;
                }
            }
            return true;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            int serverIndex = PublicServerSelectionList.this.m_6702_().indexOf((Object)this);
            double mouseOverX = mouseX - (double)PublicServerSelectionList.this.m_5747_();
            if (mouseOverX <= 32.0) {
                if (mouseOverX > 16.0 && this.canJoin()) {
                    this.screen.setSelected(this);
                    this.screen.joinSelectedServer();
                    return true;
                }
                if (mouseOverX < 16.0) {
                    this.screen.setSelected(this);
                    this.screen.addSelectedServer();
                }
            }
            this.screen.setSelected(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }

        public ServerData getServerData() {
            return this.serverData;
        }

        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.serverData.f_105362_});
        }
    }
}

