/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.inventory;

import forestry.sorting.tiles.TileGeneticFilter;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemHandlerFilter
implements IItemHandler {
    private final TileGeneticFilter filter;
    private final IItemHandler itemHandler;
    private final Direction facing;

    public ItemHandlerFilter(TileGeneticFilter filter, Direction facing) {
        this.filter = filter;
        this.facing = facing;
        this.itemHandler = new InvWrapper((Container)filter);
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack remaining = stack;
        for (Direction facing : this.filter.getValidDirections(stack, this.facing)) {
            remaining = this.itemHandler.insertItem(facing.m_122411_(), stack, simulate);
            if (!remaining.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remaining;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }
}

