/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.tiles.TileUtil;
import forestry.sorting.features.SortingMenuTypes;
import forestry.sorting.gui.SlotFilterFacing;
import forestry.sorting.gui.SlotGeneticFilter;
import forestry.sorting.network.packets.PacketGuiFilterUpdate;
import forestry.sorting.tiles.TileGeneticFilter;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.BlockGetter;

public class ContainerGeneticFilter
extends ContainerTile<TileGeneticFilter> {
    private boolean guiNeedsUpdate = true;

    public static ContainerGeneticFilter fromNetwork(int windowId, Inventory inv, FriendlyByteBuf data) {
        TileGeneticFilter tile = TileUtil.getTile((BlockGetter)inv.f_35978_.m_9236_(), data.m_130135_(), TileGeneticFilter.class);
        return new ContainerGeneticFilter(windowId, inv, tile);
    }

    public ContainerGeneticFilter(int windowId, Inventory playerInventory, TileGeneticFilter tile) {
        super(windowId, SortingMenuTypes.GENETIC_FILTER.menuType(), tile, playerInventory.f_35978_);
        this.addInventory(playerInventory, 26, 140);
    }

    protected void addInventory(Inventory playerInventory, int xInv, int yInv) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new SlotGeneticFilter((Container)playerInventory, column + row * 9 + 9, xInv + column * 18, yInv + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new SlotGeneticFilter((Container)playerInventory, column, xInv + column * 18, yInv + 58));
        }
        for (int x = 0; x < 6; ++x) {
            this.m_38897_(new SlotFilterFacing((Container)this.tile, x, 8, 18 + x * 18));
        }
    }

    public void setGuiNeedsUpdate(boolean guiNeedsUpdate) {
        this.guiNeedsUpdate = guiNeedsUpdate;
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        if (this.guiNeedsUpdate) {
            PacketGuiFilterUpdate packet = ((TileGeneticFilter)this.tile).getLogic().createGuiUpdatePacket(((TileGeneticFilter)this.tile).m_58899_());
            this.sendPacketToListeners(packet);
            this.guiNeedsUpdate = false;
        }
    }

    public boolean hasSameTile(ContainerGeneticFilter openContainer) {
        return this.tile == openContainer.tile;
    }
}

