/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network.packets;

import forestry.api.mail.IMailAddress;
import forestry.api.modules.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import forestry.mail.MailAddress;
import forestry.mail.tiles.TileTrader;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;

public record PacketTraderAddressResponse(BlockPos pos, IMailAddress address) implements IForestryPacketClient
{
    @Override
    public ResourceLocation id() {
        return PacketIdClient.TRADING_ADDRESS_RESPONSE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.m_130070_(this.address.getName());
    }

    public static PacketTraderAddressResponse decode(FriendlyByteBuf buffer) {
        return new PacketTraderAddressResponse(buffer.m_130135_(), new MailAddress(buffer.m_130277_()));
    }

    public static void handle(PacketTraderAddressResponse msg, Player player) {
        TileUtil.actOnTile((LevelReader)player.m_9236_(), msg.pos, TileTrader.class, tile -> tile.setAddress(msg.address));
    }
}

