/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.items;

import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.genetics.ButterflyLifeStage;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.core.genetics.ItemGE;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.SpeciesUtil;
import forestry.core.utils.TreeUtil;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.features.LepidopterologyEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class ItemButterflyGE
extends ItemGE
implements IColoredItem {
    public static final String NBT_AGE = "Age";

    public ItemButterflyGE(ButterflyLifeStage stage) {
        super(new Item.Properties(), stage);
    }

    protected IButterflySpecies getSpecies(ItemStack stack) {
        return (IButterflySpecies)IIndividualHandlerItem.getSpecies(stack, (ISpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get());
    }

    @Override
    protected ISpeciesType<?, ?> getType() {
        return (ISpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get();
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entityItem) {
        if (this.stage != ButterflyLifeStage.BUTTERFLY) {
            return false;
        }
        Level level = entityItem.m_9236_();
        if (level.f_46443_ || entityItem.f_19797_ < 80) {
            return false;
        }
        if (level.f_46441_.m_188503_(24) != 0) {
            return false;
        }
        IButterfly butterfly = (IButterfly)IIndividualHandlerItem.getIndividual(entityItem.m_32055_());
        if (butterfly == null) {
            return false;
        }
        if (!butterfly.canTakeFlight(level, entityItem.m_20185_(), entityItem.m_20186_(), entityItem.m_20189_())) {
            return false;
        }
        EntityUtil.spawnEntity(entityItem.m_9236_(), EntityButterfly.create(LepidopterologyEntities.BUTTERFLY.entityType(), entityItem.m_9236_(), butterfly, entityItem.m_20183_()), entityItem.m_20185_(), entityItem.m_20186_(), entityItem.m_20189_());
        if (!entityItem.m_32055_().m_41619_()) {
            entityItem.m_32055_().m_41774_(1);
        } else {
            entityItem.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(context.m_43724_());
        IButterfly flutter = (IButterfly)IIndividualHandlerItem.getIndividual(stack);
        BlockState blockState = level.m_8055_(pos);
        if (this.stage == ButterflyLifeStage.COCOON) {
            pos = ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).plantCocoon((LevelAccessor)level, pos, flutter, ItemButterflyGE.getAge(stack), true);
            if (pos != null) {
                BlockUtil.sendPlaceSound(level, pos, blockState);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (this.stage == ButterflyLifeStage.CATERPILLAR) {
            IButterflyNursery nursery = TreeUtil.getOrCreateNursery((LevelAccessor)level, pos, true);
            if (nursery != null) {
                if (!nursery.canNurse(flutter)) {
                    return InteractionResult.PASS;
                }
                nursery.setCaterpillar(flutter);
                BlockUtil.sendDestroyEffects(level, pos, blockState);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public static int getAge(ItemStack cocoon) {
        if (cocoon.m_41619_()) {
            return 0;
        }
        if (((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).getLifeStage(cocoon) != ButterflyLifeStage.COCOON) {
            return 0;
        }
        CompoundTag tagCompound = cocoon.m_41783_();
        if (tagCompound == null) {
            return 0;
        }
        return Mth.m_14045_((int)tagCompound.m_128451_(NBT_AGE), (int)0, (int)2);
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int tintIndex) {
        if (tintIndex == 1 && stack.m_41782_()) {
            IButterflySpecies species = this.getSpecies(stack);
            return species.getSerumColor();
        }
        return 0xFFFFFF;
    }
}

