/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology;

import forestry.api.core.HumidityType;
import forestry.api.core.IProduct;
import forestry.api.core.TemperatureType;
import forestry.api.core.tooltips.TextCollection;
import forestry.api.core.tooltips.TextCompound;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.api.plugin.IButterflySpeciesBuilder;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.Species;
import forestry.lepidopterology.genetics.Butterfly;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class ButterflySpecies
extends Species<IButterflySpeciesType, IButterfly>
implements IButterflySpecies {
    private final TemperatureType temperature;
    private final HumidityType humidity;
    private final boolean nocturnal;
    private final boolean moth;
    private final float rarity;
    @Nullable
    private final TagKey<Biome> spawnBiomes;
    private final float flightDistance;
    private final int serumColor;
    private final List<IProduct> products;
    private final List<IProduct> caterpillarProducts;

    public ButterflySpecies(ResourceLocation id, IButterflySpeciesType speciesType, IGenome defaultGenome, IButterflySpeciesBuilder builder) {
        super(id, speciesType, defaultGenome, builder);
        this.temperature = builder.getTemperature();
        this.humidity = builder.getHumidity();
        this.nocturnal = builder.isNocturnal();
        this.moth = builder.isMoth();
        this.rarity = builder.getRarity();
        this.spawnBiomes = builder.getSpawnBiomes();
        this.flightDistance = builder.getFlightDistance();
        this.serumColor = builder.getSerumColor();
        this.products = builder.buildProducts();
        this.caterpillarProducts = builder.buildCaterpillarProducts();
    }

    @Override
    public IButterfly createIndividual(IGenome genome) {
        return new Butterfly(genome);
    }

    @Override
    public void addTooltip(IButterfly butterfly, List<Component> tooltip) {
        IButterflySpecies secondary;
        ToolTip toolTip = new ToolTip();
        if (!butterfly.isAnalyzed()) {
            ((TextCompound)((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().text("<")).translated("for.gui.unknown", new Object[0])).text(">")).style(ChatFormatting.GRAY)).create();
            return;
        }
        IGenome genome = butterfly.getGenome();
        IButterflySpecies primary = butterfly.getSpecies();
        if (primary != (secondary = butterfly.getInactiveSpecies())) {
            ((TextCollection)toolTip.translated("for.butterflies.hybrid", primary.getDisplayName(), secondary.getDisplayName())).style(ChatFormatting.BLUE);
        }
        if (butterfly.getMate() != null) {
            toolTip.add((Component)Component.m_237115_((String)"for.gui.fecundated").m_130940_(ChatFormatting.RED));
        }
        toolTip.add((Component)genome.getActiveName(ButterflyChromosomes.SIZE).m_130940_(ChatFormatting.YELLOW));
        toolTip.add((Component)genome.getActiveName(ButterflyChromosomes.SPEED).m_130940_(ChatFormatting.DARK_GREEN));
        toolTip.add((Component)genome.getActiveName(ButterflyChromosomes.LIFESPAN).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"for.gui.life").m_130940_(ChatFormatting.GRAY)));
        MutableComponent tempTolerance = genome.getActiveName(ButterflyChromosomes.TEMPERATURE_TOLERANCE);
        MutableComponent humidTolerance = genome.getActiveName(ButterflyChromosomes.HUMIDITY_TOLERANCE);
        ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().text("T: ")).add((Component)ClimateHelper.toDisplay(primary.getTemperature())).text(" / ")).add((Component)tempTolerance).style(ChatFormatting.GREEN)).create();
        ((TextCompound)((TextCompound)((TextCompound)toolTip.singleLine().text("H: ")).add((Component)ClimateHelper.toDisplay(primary.getHumidity())).text(" / ")).add((Component)humidTolerance).style(ChatFormatting.GREEN)).create();
        toolTip.add((Component)GenericRatings.rateActivityTime(genome.getActiveValue(ButterflyChromosomes.NEVER_SLEEPS), primary.isNocturnal()).m_130940_(ChatFormatting.RED));
        if (genome.getActiveValue(ButterflyChromosomes.TOLERATES_RAIN)) {
            ((TextCollection)toolTip.translated("for.gui.flyer.tooltip", new Object[0])).style(ChatFormatting.WHITE);
        }
        tooltip.addAll(toolTip.getLines());
    }

    @Override
    public TemperatureType getTemperature() {
        return this.temperature;
    }

    @Override
    public HumidityType getHumidity() {
        return this.humidity;
    }

    @Override
    @Nullable
    public TagKey<Biome> getSpawnBiomes() {
        return this.spawnBiomes;
    }

    @Override
    public float getRarity() {
        return this.rarity;
    }

    @Override
    public float getFlightDistance() {
        return this.flightDistance;
    }

    @Override
    public boolean isMoth() {
        return this.moth;
    }

    @Override
    public boolean isNocturnal() {
        return this.nocturnal;
    }

    @Override
    public List<IProduct> getButterflyLoot() {
        return this.products;
    }

    @Override
    public List<IProduct> getCaterpillarProducts() {
        return this.caterpillarProducts;
    }

    @Override
    public int getSerumColor() {
        return this.serumColor;
    }

    @Override
    public int getEscritoireColor() {
        return this.escritoireColor == -1 ? this.serumColor : this.escritoireColor;
    }
}

