/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.api.genetics.IFruitBearer;
import forestry.core.tiles.TileUtil;
import forestry.farming.logic.FarmLogic;
import forestry.farming.logic.crops.CropFruit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FarmLogicOrchard
extends FarmLogic {
    public FarmLogicOrchard(IFarmType properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public Collection<ICrop> harvest(Level level, IFarmHousing housing, Direction direction, int extent, BlockPos pos) {
        BlockPos position = housing.getValidPosition(direction, pos, extent, pos.m_7494_());
        Collection<ICrop> crops = this.getHarvestBlocks(level, position);
        housing.increaseExtent(direction, pos, extent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(Level world, BlockPos position) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        ArrayDeque<ICrop> crops = new ArrayDeque<ICrop>();
        if (!world.m_46805_(position)) {
            return Collections.emptyList();
        }
        BlockState state = world.m_8055_(position);
        if (!state.m_204336_(BlockTags.f_13106_) && !this.isFruitBearer(world, position, state)) {
            return crops;
        }
        List<BlockPos> candidates = this.processHarvestBlock(world, crops, seen, position, position);
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (BlockPos candidate : candidates) {
                temp.addAll(this.processHarvestBlock(world, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<BlockPos> processHarvestBlock(Level world, ArrayDeque<ICrop> crops, Set<BlockPos> seen, BlockPos start, BlockPos position) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int i = -2; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos candidate = position.m_7918_(i, j, k);
                    if (Math.abs(candidate.m_123341_() - start.m_123341_()) > 5 || Math.abs(candidate.m_123343_() - start.m_123343_()) > 5 || seen.contains(candidate) || !world.m_46805_(candidate) || world.m_46859_(candidate)) continue;
                    BlockState state = world.m_8055_(candidate);
                    if (state.m_204336_(BlockTags.f_13106_)) {
                        candidates.add(candidate);
                        seen.add(candidate);
                    }
                    if (!this.isFruitBearer(world, candidate, state)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                    ICrop crop = this.getCropAt(world, candidate);
                    if (crop == null) continue;
                    crops.addFirst(crop);
                }
            }
        }
        return candidates;
    }

    private boolean isFruitBearer(Level world, BlockPos pos, BlockState state) {
        IFruitBearer tile = TileUtil.getTile((BlockGetter)world, pos, IFruitBearer.class);
        if (tile != null) {
            return true;
        }
        for (IFarmable farmable : this.getFarmables()) {
            if (!farmable.isSaplingAt(world, pos, state)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private ICrop getCropAt(Level world, BlockPos position) {
        IFruitBearer fruitBearer = TileUtil.getTile((BlockGetter)world, position, IFruitBearer.class);
        if (fruitBearer != null) {
            if (fruitBearer.hasFruit() && fruitBearer.getRipeness() >= 0.9f) {
                return new CropFruit(world, position);
            }
        } else {
            return this.getCrop(world, position);
        }
        return null;
    }
}

