/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorSmeltingRecipe
implements IFabricatorSmeltingRecipe {
    private final ResourceLocation id;
    private final Ingredient resource;
    private final FluidStack product;
    private final int meltingPoint;

    public FabricatorSmeltingRecipe(ResourceLocation id, Ingredient resource, FluidStack molten, int meltingPoint) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((!resource.m_43947_() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)molten);
        this.id = id;
        this.resource = resource;
        this.product = molten;
        this.meltingPoint = meltingPoint;
    }

    @Override
    public Ingredient getInput() {
        return this.resource;
    }

    @Override
    public FluidStack getResultFluid() {
        return this.product;
    }

    @Override
    public int getMeltingPoint() {
        return this.meltingPoint;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Override
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return FactoryRecipeTypes.FABRICATOR_SMELTING.serializer();
    }

    @Override
    public RecipeType<?> m_6671_() {
        return FactoryRecipeTypes.FABRICATOR_SMELTING.type();
    }

    public static class Serializer
    implements RecipeSerializer<FabricatorSmeltingRecipe> {
        public FabricatorSmeltingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient resource = RecipeSerializers.deserialize(json.get("resource"));
            FluidStack product = RecipeSerializers.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)"product"));
            int meltingPoint = GsonHelper.m_13927_((JsonObject)json, (String)"melting");
            return new FabricatorSmeltingRecipe(recipeId, resource, product, meltingPoint);
        }

        public FabricatorSmeltingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient resource = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            FluidStack product = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            int meltingPoint = buffer.m_130242_();
            return new FabricatorSmeltingRecipe(recipeId, resource, product, meltingPoint);
        }

        public void toNetwork(FriendlyByteBuf buffer, FabricatorSmeltingRecipe recipe) {
            recipe.resource.m_43923_(buffer);
            recipe.product.writeToPacket(buffer);
            buffer.m_130130_(recipe.meltingPoint);
        }
    }
}

