/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forestry.api.ForestryConstants;
import forestry.core.blocks.BlockBase;
import forestry.core.render.ForestryModelLayers;
import forestry.core.tiles.TileNaturalistChest;
import forestry.core.utils.RenderUtil;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RenderNaturalistChest
implements BlockEntityRenderer<TileNaturalistChest> {
    private static final String LID = "lid";
    private static final String BASE = "base";
    private static final String LOCK = "lock";
    private final ModelPart lid;
    private final ModelPart base;
    private final ModelPart lock;
    private final ResourceLocation texture;

    public RenderNaturalistChest(BlockEntityRendererProvider.Context ctx, String textureName) {
        ModelPart root = ctx.m_173582_(ForestryModelLayers.NATURALIST_CHEST_LAYER);
        this.lid = root.m_171324_(LID);
        this.base = root.m_171324_(BASE);
        this.lock = root.m_171324_(LOCK);
        this.texture = ForestryConstants.forestry("textures/block/" + textureName + ".png");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(BASE, CubeListBuilder.m_171558_().m_171514_(0, 19).m_171481_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_(LID, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)1.0f));
        partdefinition.m_171599_(LOCK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(TileNaturalistChest chest, float partialTick, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        float rotation;
        stack.m_85836_();
        RenderUtil.rotateByHorizontalDirection(stack, (Direction)chest.m_58900_().m_61143_(BlockBase.FACING));
        float prevLidAngle = chest.prevLidAngle;
        float lidAngle = chest.lidAngle;
        float angle = prevLidAngle + (lidAngle - prevLidAngle) * partialTick;
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        this.lid.f_104203_ = rotation = -(angle * 1.5707964f);
        this.lock.f_104203_ = rotation;
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110452_((ResourceLocation)this.texture));
        this.lid.m_104301_(stack, buffer, light, overlay);
        this.lock.m_104301_(stack, buffer, light, overlay);
        this.base.m_104301_(stack, buffer, light, overlay);
        stack.m_85849_();
    }
}

