/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.api.IForestryApi;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.ISpeciesType;
import forestry.api.modules.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public record PacketGenomeTrackerSync(@Nullable CompoundTag nbt) implements IForestryPacketClient
{
    @Override
    public ResourceLocation id() {
        return PacketIdClient.GENOME_TRACKER_UPDATE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.nbt);
    }

    public static PacketGenomeTrackerSync decode(FriendlyByteBuf buffer) {
        return new PacketGenomeTrackerSync(buffer.m_130260_());
    }

    public static void handle(PacketGenomeTrackerSync msg, Player player) {
        if (msg.nbt != null) {
            String type = msg.nbt.m_128461_("TYPE");
            ISpeciesType<?, ?> root = IForestryApi.INSTANCE.getGeneticManager().getSpeciesTypeSafe(new ResourceLocation(type));
            if (root != null) {
                IBreedingTracker tracker = root.getBreedingTracker((LevelAccessor)player.m_20193_(), player.m_36316_());
                tracker.readFromNbt(msg.nbt);
                MinecraftForge.EVENT_BUS.post((Event)new ForestryEvent.SyncedBreedingTracker(tracker, player));
            }
        }
    }
}

