/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.base.Preconditions;
import forestry.core.tiles.IFilterSlotDelegate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class ItemInventory
implements Container,
IFilterSlotDelegate,
ICapabilityProvider {
    private static final String KEY_SLOTS = "Slots";
    private static final String KEY_UID = "UID";
    private static final Random rand = new Random();
    private final IItemHandler itemHandler = new InvWrapper((Container)this);
    protected final Player player;
    private ItemStack parent;
    private final NonNullList<ItemStack> inventoryStacks;

    public ItemInventory(Player player, int size, ItemStack parent) {
        Preconditions.checkArgument((!parent.m_41619_() ? 1 : 0) != 0, (Object)"Parent cannot be empty.");
        this.player = player;
        this.parent = parent;
        this.inventoryStacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        CompoundTag nbt = parent.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            parent.m_41751_(nbt);
        }
        this.setUID(nbt);
        CompoundTag nbtSlots = nbt.m_128469_(KEY_SLOTS);
        for (int i = 0; i < this.inventoryStacks.size(); ++i) {
            String slotKey = ItemInventory.getSlotNBTKey(i);
            if (nbtSlots.m_128441_(slotKey)) {
                CompoundTag itemNbt = nbtSlots.m_128469_(slotKey);
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)itemNbt);
                this.inventoryStacks.set(i, (Object)itemStack);
                continue;
            }
            this.inventoryStacks.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public static int getOccupiedSlotCount(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt == null) {
            return 0;
        }
        CompoundTag slotNbt = nbt.m_128469_(KEY_SLOTS);
        return slotNbt.m_128440_();
    }

    private void setUID(CompoundTag nbt) {
        if (!nbt.m_128441_(KEY_UID)) {
            nbt.m_128405_(KEY_UID, rand.nextInt());
        }
    }

    public boolean isParentItemInventory(ItemStack itemStack) {
        ItemStack parent = this.getParent();
        return ItemInventory.isSameItemInventory(parent, itemStack);
    }

    protected ItemStack getParent() {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack held = this.player.m_21120_(hand);
            if (!ItemInventory.isSameItemInventory(held, this.parent)) continue;
            return held;
        }
        return this.parent;
    }

    protected void setParent(ItemStack parent) {
        this.parent = parent;
    }

    @Nullable
    protected InteractionHand getHand() {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack held = this.player.m_21120_(hand);
            if (!ItemInventory.isSameItemInventory(held, this.parent)) continue;
            return hand;
        }
        return null;
    }

    private static boolean isSameItemInventory(ItemStack base, ItemStack comparison) {
        int comparisonUID;
        if (base.m_41619_() || comparison.m_41619_()) {
            return false;
        }
        if (base.m_41720_() != comparison.m_41720_()) {
            return false;
        }
        CompoundTag baseTagCompound = base.m_41783_();
        CompoundTag comparisonTagCompound = comparison.m_41783_();
        if (baseTagCompound == null || comparisonTagCompound == null) {
            return false;
        }
        if (!baseTagCompound.m_128441_(KEY_UID) || !comparisonTagCompound.m_128441_(KEY_UID)) {
            return false;
        }
        int baseUID = baseTagCompound.m_128451_(KEY_UID);
        return baseUID == (comparisonUID = comparisonTagCompound.m_128451_(KEY_UID));
    }

    private void writeToParentNBT() {
        ItemStack parent = this.getParent();
        CompoundTag nbt = parent.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            parent.m_41751_(nbt);
        }
        CompoundTag slotsNbt = new CompoundTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            String slotKey = ItemInventory.getSlotNBTKey(i);
            CompoundTag itemNbt = new CompoundTag();
            itemStack.m_41739_(itemNbt);
            slotsNbt.m_128365_(slotKey, (Tag)itemNbt);
        }
        nbt.m_128365_(KEY_SLOTS, (Tag)slotsNbt);
        this.onWriteNBT(nbt);
    }

    private static String getSlotNBTKey(int i) {
        return Integer.toString(i, 36);
    }

    protected void onWriteNBT(CompoundTag nbt) {
    }

    public void onSlotClick(int slotIndex, Player player) {
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventoryStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.inventoryStacks, (int)index, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public void m_6836_(int index, ItemStack itemstack) {
        CompoundTag slotNbt;
        this.inventoryStacks.set(index, (Object)itemstack);
        ItemStack parent = this.getParent();
        CompoundTag nbt = parent.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            parent.m_41751_(nbt);
        }
        if (!nbt.m_128441_(KEY_SLOTS)) {
            slotNbt = new CompoundTag();
            nbt.m_128365_(KEY_SLOTS, (Tag)slotNbt);
        } else {
            slotNbt = nbt.m_128469_(KEY_SLOTS);
        }
        String slotKey = ItemInventory.getSlotNBTKey(index);
        if (itemstack.m_41619_()) {
            slotNbt.m_128473_(slotKey);
        } else {
            CompoundTag itemNbt = new CompoundTag();
            itemstack.m_41739_(itemNbt);
            slotNbt.m_128365_(slotKey, (Tag)itemNbt);
        }
    }

    public ItemStack m_8020_(int i) {
        return (ItemStack)this.inventoryStacks.get(i);
    }

    public int m_6643_() {
        return this.inventoryStacks.size();
    }

    public int m_6893_() {
        return 64;
    }

    public final void m_6596_() {
        this.writeToParentNBT();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public boolean m_7013_(int slotIndex, ItemStack itemStack) {
        return this.canSlotAccept(slotIndex, itemStack);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public ItemStack m_8016_(int slot) {
        ItemStack toReturn = this.m_8020_(slot);
        if (!toReturn.m_41619_()) {
            this.m_6836_(slot, ItemStack.f_41583_);
        }
        return toReturn;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        return true;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemHandler).cast();
        }
        return LazyOptional.empty();
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void m_6211_() {
        this.inventoryStacks.clear();
    }
}

