/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.IForestryApi;
import forestry.api.circuits.ICircuitBoard;
import forestry.core.circuits.ISocketable;
import forestry.core.circuits.ISolderingIron;
import forestry.core.gui.IContainerSocketed;
import forestry.core.network.packets.PacketChipsetClick;
import forestry.core.network.packets.PacketSocketUpdate;
import forestry.core.network.packets.PacketSolderingIronClick;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NetworkUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerSocketedHelper<T extends BlockEntity>
implements IContainerSocketed {
    private final T tile;

    public ContainerSocketedHelper(T tile) {
        this.tile = tile;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleChipsetClick(int slot) {
        NetworkUtil.sendToServer(new PacketChipsetClick(slot));
    }

    @Override
    public void handleChipsetClickServer(int slot, ServerPlayer player, ItemStack itemstack) {
        if (!((ISocketable)this.tile).getSocket(slot).m_41619_()) {
            return;
        }
        if (!IForestryApi.INSTANCE.getCircuitManager().isCircuitBoard(itemstack)) {
            return;
        }
        ICircuitBoard circuitBoard = IForestryApi.INSTANCE.getCircuitManager().getCircuitBoard(itemstack);
        if (circuitBoard == null) {
            return;
        }
        if (!((ISocketable)this.tile).getSocketType().equals((Object)circuitBoard.getSocketType())) {
            return;
        }
        ItemStack toSocket = itemstack.m_41777_();
        toSocket.m_41764_(1);
        ((ISocketable)this.tile).setSocket(slot, toSocket);
        ItemStack stack = player.f_36096_.m_142621_();
        stack.m_41774_(1);
        player.f_36096_.m_38946_();
        PacketSocketUpdate packet = PacketSocketUpdate.create(this.tile);
        NetworkUtil.sendToPlayer(packet, player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleSolderingIronClick(int slot) {
        NetworkUtil.sendToServer(new PacketSolderingIronClick(slot));
    }

    @Override
    public void handleSolderingIronClickServer(int slot, ServerPlayer player, ItemStack itemstack) {
        ItemStack socket = ((ISocketable)this.tile).getSocket(slot);
        if (socket.m_41619_() || !(itemstack.m_41720_() instanceof ISolderingIron)) {
            return;
        }
        if (!InventoryUtil.stowInInventory(socket, (Container)player.m_150109_(), false)) {
            return;
        }
        ((ISocketable)this.tile).setSocket(slot, ItemStack.f_41583_);
        InventoryUtil.stowInInventory(socket, (Container)player.m_150109_(), true);
        itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
        player.f_36095_.m_38946_();
        PacketSocketUpdate packet = PacketSocketUpdate.create(this.tile);
        NetworkUtil.sendToPlayer(packet, player);
    }
}

