/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.climate.IClimateProvider;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.DayMonth;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class MutationConditionTimeLimited
implements IMutationCondition {
    private final DayMonth start;
    private final DayMonth end;

    public MutationConditionTimeLimited(int startMonth, int startDay, int endMonth, int endDay) {
        this.start = new DayMonth(startDay, startMonth);
        this.end = new DayMonth(endDay, endMonth);
    }

    @Override
    public float modifyChance(Level level, BlockPos pos, IMutation<?> mutation, IGenome genome0, IGenome genome1, IClimateProvider climate, float currentChance) {
        DayMonth now = DayMonth.now();
        if (now.between(this.start, this.end)) {
            return currentChance;
        }
        return 0.0f;
    }

    @Override
    public Component getDescription() {
        return Component.m_237110_((String)"for.mutation.condition.date", (Object[])new Object[]{this.start.getDisplayName(), this.end.getDisplayName()});
    }
}

