/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class PipetteContents {
    private final FluidStack contents;

    @Nullable
    public static PipetteContents create(ItemStack itemStack) {
        FluidStack contents = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        if (contents.isEmpty()) {
            return null;
        }
        return new PipetteContents(contents);
    }

    public PipetteContents(FluidStack contents) {
        this.contents = contents;
    }

    public FluidStack getContents() {
        return this.contents;
    }

    public boolean isFull() {
        return this.contents.getAmount() >= 1000;
    }

    public void addTooltip(List<Component> list) {
        list.add((Component)this.contents.getDisplayName().m_6881_().m_130946_(" (" + this.contents.getAmount() + " mb)").m_130940_(ChatFormatting.GRAY));
    }
}

