/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.models;

import forestry.api.client.IForestryClientApi;
import forestry.apiculture.blocks.BlockBeeHive;
import forestry.apiculture.blocks.BlockHiveType;
import forestry.apiculture.features.ApicultureBlocks;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.core.features.CoreBlocks;
import forestry.core.features.CoreItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.utils.ModUtil;
import forestry.cultivation.blocks.BlockTypePlanter;
import forestry.cultivation.features.CultivationBlocks;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.blocks.EnumFarmMaterial;
import forestry.farming.blocks.FarmBlock;
import forestry.farming.features.FarmingBlocks;
import forestry.modules.features.FeatureBlock;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ForestryBlockStateProvider
extends BlockStateProvider {
    public ForestryBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "forestry", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (FarmBlock block : FarmingBlocks.FARM.getBlocks()) {
            if (block.getType() == EnumFarmBlockType.PLAIN) {
                this.plainFarm(block);
            } else {
                this.singleFarm(block);
            }
            this.generic3d(block);
        }
        for (BlockTypePlanter blockTypePlanter : BlockTypePlanter.values()) {
            ModelFile.ExistingModelFile file = this.models().getExistingFile(this.modBlock(blockTypePlanter.m_7912_()));
            this.horizontalBlock((Block)((FeatureBlock)CultivationBlocks.MANAGED_PLANTER.get(blockTypePlanter)).block(), (ModelFile)file);
            this.horizontalBlock((Block)((FeatureBlock)CultivationBlocks.MANUAL_PLANTER.get(blockTypePlanter)).block(), (ModelFile)file);
        }
        this.simpleBlock(CoreBlocks.BOG_EARTH.block());
        this.simpleBlock(CoreBlocks.HUMUS.block());
        this.simpleBlock(CoreBlocks.APATITE_ORE.block());
        this.simpleBlock(CoreBlocks.DEEPSLATE_APATITE_ORE.block());
        this.simpleBlock(CoreBlocks.TIN_ORE.block());
        this.simpleBlock(CoreBlocks.DEEPSLATE_TIN_ORE.block());
        this.simpleBlock(CoreBlocks.RAW_TIN_BLOCK.block());
        this.generic3d(CoreBlocks.APATITE_ORE.block());
        this.generic3d(CoreBlocks.DEEPSLATE_APATITE_ORE.block());
        this.generic3d(CoreBlocks.TIN_ORE.block());
        this.generic3d(CoreBlocks.DEEPSLATE_TIN_ORE.block());
        this.generic3d(CoreBlocks.RAW_TIN_BLOCK.block());
        this.generic2d(CoreItems.RAW_TIN);
        this.generic2d(CoreItems.INGOT_TIN);
        this.generic2d(CoreItems.GEAR_TIN);
        this.generic2d(CoreItems.INGOT_BRONZE);
        this.generic2d(CoreItems.GEAR_BRONZE);
        this.generic2d(CoreItems.GEAR_COPPER);
        for (Enum enum_ : ForestryFluids.values()) {
            Block block = ((ForestryFluids)enum_).getFeature().fluidBlock().block();
            ModelFile blockModel = ForestryBlockStateProvider.particleOnly(this.models(), ForestryBlockStateProvider.path(block), ((ForestryFluids)enum_).getFeature().properties().resources[0]);
            ForestryBlockStateProvider.singleModelBlock(this, block, blockModel);
        }
        for (ForestryLeafType treeType : ForestryLeafType.values()) {
            Object defaultBlock = ((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT.get(treeType)).block();
            Object b = ((FeatureBlock)ArboricultureBlocks.LEAVES_DEFAULT_FRUIT.get(treeType)).block();
            Object decorativeBlock = ((FeatureBlock)ArboricultureBlocks.LEAVES_DECORATIVE.get(treeType)).block();
            ResourceLocation particle = IForestryClientApi.INSTANCE.getTreeManager().getLeafSprite(treeType.getIndividual().getSpecies()).get(false, true);
            ModelBuilder file = ((BlockModelBuilder)this.models().getBuilder(ForestryBlockStateProvider.path(defaultBlock))).texture("particle", particle);
            ForestryBlockStateProvider.singleModelBlock(this, defaultBlock, (ModelFile)file);
            ForestryBlockStateProvider.singleModelBlock(this, b, (ModelFile)file);
            ForestryBlockStateProvider.singleModelBlock(this, decorativeBlock, (ModelFile)file);
            this.generic3d((Block)defaultBlock);
            this.generic3d((Block)b, (Block)defaultBlock);
            this.generic3d((Block)decorativeBlock, (Block)defaultBlock);
        }
        ForestryBlockStateProvider.singleModelBlock(this, (Block)ArboricultureBlocks.LEAVES.block(), ForestryBlockStateProvider.particleOnly(this.models(), ArboricultureBlocks.LEAVES.getName(), this.blockTexture(Blocks.f_50050_)));
        for (BlockHiveType blockHiveType : BlockHiveType.values()) {
            BlockBeeHive feature = (BlockBeeHive)((Object)((FeatureBlock)ApicultureBlocks.BEEHIVE.get(blockHiveType)).block());
            String path = ForestryBlockStateProvider.path(feature);
            ResourceLocation side = this.modBlock("beehives/" + blockHiveType.m_7912_() + ".side");
            ResourceLocation top = this.modBlock("beehives/" + blockHiveType.m_7912_() + ".top");
            ResourceLocation bottom = this.modBlock("beehives/" + blockHiveType.m_7912_() + ".bottom");
            ForestryBlockStateProvider.singleModelBlock(this, feature, (ModelFile)this.models().cubeBottomTop(path, side, bottom, top));
            this.generic3d(feature);
        }
    }

    public static void singleModelBlock(ForestryBlockStateProvider states, Block defaultBlock, ModelFile file) {
        states.getVariantBuilder(defaultBlock).partialState().modelForState().modelFile(file).addModel();
    }

    public static ModelFile particleOnly(BlockModelProvider models, String path, ResourceLocation particleTexture) {
        return ((BlockModelBuilder)models.getBuilder(path)).texture("particle", particleTexture);
    }

    private void singleFarm(FarmBlock block) {
        EnumFarmMaterial material = block.getFarmMaterial();
        Block base = material.getBase();
        ResourceLocation texture = this.modLoc("block/farm/" + block.getType().m_7912_());
        ForestryBlockStateProvider.singleModelBlock(this, block, this.farmPillar(ForestryBlockStateProvider.path(block), base, texture, texture));
    }

    private void plainFarm(FarmBlock block) {
        EnumFarmMaterial material = block.getFarmMaterial();
        Block base = material.getBase();
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)FarmBlock.BAND, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(this.farmPillar(ForestryBlockStateProvider.path(block), base, this.modLoc("block/farm/top"), this.modLoc("block/farm/plain"))).addModel()).partialState().with((Property)FarmBlock.BAND, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(this.farmPillar(ForestryBlockStateProvider.path(block) + "_band", base, this.modLoc("block/farm/top"), this.modLoc("block/farm/band"))).addModel();
    }

    private ModelFile farmPillar(String path, Block base, ResourceLocation top, ResourceLocation side) {
        ModelFile.UncheckedModelFile baseModel = ForestryBlockStateProvider.file(this.blockTexture(base));
        return ((BlockModelBuilder)((CompositeModelBuilder)((BlockModelBuilder)this.models().getBuilder(path)).customLoader(CompositeModelBuilder::begin)).child("base", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)baseModel)).renderType("solid"))).child("overlay", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)this.mcFile("cube_column"))).texture("end", top)).texture("side", side)).renderType("cutout"))).itemRenderOrder(new String[]{"base", "overlay"}).end()).parent((ModelFile)baseModel);
    }

    protected static ResourceLocation withSuffix(ResourceLocation loc, String suffix) {
        return loc.m_266382_(suffix);
    }

    protected static ResourceLocation withPrefix(String prefix, ResourceLocation loc) {
        String oldPath = loc.m_135815_();
        int slash = oldPath.lastIndexOf(47) + 1;
        if (slash != 0) {
            return loc.m_247449_(oldPath.substring(0, slash) + prefix + oldPath.substring(slash));
        }
        return loc.m_246208_(prefix);
    }

    public void generic3d(Block block, Block otherParent) {
        this.itemModels().withExistingParent(ForestryBlockStateProvider.path(block), this.modLoc("block/" + ForestryBlockStateProvider.path(otherParent)));
    }

    public void generic3d(Block block, ResourceLocation otherParentId) {
        this.itemModels().withExistingParent(ForestryBlockStateProvider.path(block), new ResourceLocation(otherParentId.m_135827_(), "block/" + otherParentId.m_135815_()));
    }

    protected ModelFile existingMcBlock(String path) {
        return this.models().getExistingFile(this.mcBlock(path));
    }

    public void generic3d(Block block) {
        String path = ForestryBlockStateProvider.path(block);
        this.itemModels().withExistingParent(path, this.modLoc("block/" + path));
    }

    public static String path(Block block) {
        return ModUtil.getRegistryName(block).m_135815_();
    }

    public static ModelFile.UncheckedModelFile file(ResourceLocation resourceLoc) {
        return new ModelFile.UncheckedModelFile(resourceLoc);
    }

    public ModelFile.UncheckedModelFile modFile(String path) {
        return ForestryBlockStateProvider.file(this.modBlock(path));
    }

    public ModelFile.UncheckedModelFile mcFile(String path) {
        return ForestryBlockStateProvider.file(this.mcBlock(path));
    }

    public ResourceLocation modBlock(String name) {
        return this.modLoc("block/" + name);
    }

    public ResourceLocation mcBlock(String name) {
        return this.mcLoc("block/" + name);
    }

    public void generic2d(ItemLike item) {
        this.generic2d(ModUtil.getRegistryName(item.m_5456_()));
    }

    public void generic2d(ResourceLocation itemId) {
        this.layer0(itemId, "item/generated");
    }

    public void layer0(ResourceLocation itemId, String parentName) {
        String path = itemId.m_135815_();
        ((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(parentName))).texture("layer0", new ResourceLocation(itemId.m_135827_(), "item/" + path));
    }
}

