/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.genetics.ITree;
import forestry.api.genetics.ISpeciesType;
import forestry.core.ClientsideCode;
import forestry.core.network.IStreamable;
import forestry.core.utils.NBTUtilForestry;
import forestry.core.utils.SpeciesUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileTreeContainer
extends BlockEntity
implements IStreamable {
    @Nullable
    private ITree containedTree;

    public TileTreeContainer(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_183515_(CompoundTag nbt) {
        Tag serialized;
        super.m_183515_(nbt);
        if (this.containedTree != null && (serialized = SpeciesUtil.serializeIndividual(this.containedTree)) != null) {
            nbt.m_128365_("ContainedTree", serialized);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        Tag treeNbt = nbt.m_128423_("ContainedTree");
        if (treeNbt != null) {
            this.containedTree = (ITree)SpeciesUtil.deserializeIndividual((ISpeciesType)SpeciesUtil.TREE_TYPE.get(), treeNbt);
        }
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        ITree tree = this.getTree();
        if (tree != null) {
            data.writeBoolean(true);
            ResourceLocation speciesId = tree.getSpecies().id();
            data.m_130085_(speciesId);
        } else {
            data.writeBoolean(false);
        }
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        if (data.readBoolean()) {
            ResourceLocation speciesId = data.m_130281_();
            ITree tree = (ITree)SpeciesUtil.getTreeSpecies(speciesId).createIndividual();
            this.setTree(tree);
        }
    }

    public void setTree(ITree tree) {
        this.containedTree = tree;
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ClientsideCode.markForUpdate(this.f_58858_);
        }
    }

    @Nullable
    public ITree getTree() {
        return this.containedTree;
    }

    public abstract void onBlockTick(Level var1, BlockPos var2, BlockState var3, RandomSource var4);

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundTag nbt = pkt.m_131708_();
        this.handleUpdateTag(nbt);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        return NBTUtilForestry.writeStreamableToNbt(this, tag);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        NBTUtilForestry.readStreamableFromNbt(this, tag);
    }
}

