/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.IForestryApi;
import forestry.api.arboriculture.ForestryTreeSpecies;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeEffect;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.client.IForestryClientApi;
import forestry.api.climate.IBiomeProvider;
import forestry.api.core.HumidityType;
import forestry.api.core.ISpectacleBlock;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.arboriculture.features.ArboricultureTiles;
import forestry.arboriculture.network.IRipeningPacketReceiver;
import forestry.arboriculture.network.PacketRipeningUpdate;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.ClientsideCode;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.utils.ColourUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class TileLeaves
extends TileTreeContainer
implements IFruitBearer,
IButterflyNursery,
IRipeningPacketReceiver,
IBiomeProvider,
ISpectacleBlock {
    private static final String NBT_RIPENING = "RT";
    private static final String NBT_DAMAGE = "ENC";
    private static final String NBT_FRUIT_LEAF = "FL";
    private static final String NBT_MATURATION = "CATMAT";
    private static final String NBT_CATERPILLAR = "CATER";
    public static final ModelProperty<ITreeSpecies> PROPERTY_SPECIES = new ModelProperty();
    public static final ModelProperty<Boolean> PROPERTY_POLLINATED = new ModelProperty();
    public static final ModelProperty<ResourceLocation> PROPERTY_FRUIT_TEXTURE = new ModelProperty();
    private int colourFruits;
    @Nullable
    private ResourceLocation fruitSprite;
    @Nullable
    private ITreeSpecies species;
    @Nullable
    private IButterfly caterpillar;
    private boolean isFruitLeaf;
    private boolean isPollinatedState;
    private int ripeningTime;
    private short ripeningPeriod = (short)32766;
    private int maturationTime;
    private int damage;
    private IEffectData[] effectData = new IEffectData[2];
    private static final short FLAG_HAS_FRUIT = 1;
    private static final short FLAG_IS_POLLINATED = 2;
    private static final short FLAG_HAS_ACTIVE_EFFECT = 4;
    private static final short FLAG_HAS_INACTIVE_EFFECT = 8;

    public TileLeaves(BlockPos pos, BlockState state) {
        super(ArboricultureTiles.LEAVES.tileType(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        ITree tree;
        super.m_142466_(nbt);
        this.ripeningTime = nbt.m_128451_(NBT_RIPENING);
        this.damage = nbt.m_128451_(NBT_DAMAGE);
        this.isFruitLeaf = nbt.m_128471_(NBT_FRUIT_LEAF);
        boolean checkFruit = !nbt.m_128441_(NBT_FRUIT_LEAF);
        Tag caterpillarNbt = nbt.m_128423_(NBT_CATERPILLAR);
        if (caterpillarNbt != null) {
            this.maturationTime = nbt.m_128451_(NBT_MATURATION);
            this.caterpillar = (IButterfly)SpeciesUtil.deserializeIndividual((ISpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get(), caterpillarNbt);
        }
        if ((tree = this.getTree()) != null) {
            this.setTree(tree);
            if (checkFruit) {
                this.setFruit(tree, false);
            } else if (this.isFruitLeaf) {
                this.setFruit(tree, true);
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_(NBT_RIPENING, this.ripeningTime);
        nbt.m_128405_(NBT_DAMAGE, this.damage);
        nbt.m_128379_(NBT_FRUIT_LEAF, this.isFruitLeaf);
        if (this.caterpillar != null) {
            nbt.m_128405_(NBT_MATURATION, this.maturationTime);
            Tag caterpillarNbt = SpeciesUtil.serializeIndividual(this.caterpillar);
            if (caterpillarNbt != null) {
                nbt.m_128365_(NBT_CATERPILLAR, caterpillarNbt);
            }
        }
    }

    @Override
    public void onBlockTick(Level worldIn, BlockPos pos, BlockState state, RandomSource rand) {
        ITree tree = this.getTree();
        if (tree == null) {
            return;
        }
        IGenome genome = tree.getGenome();
        ITreeSpecies primary = genome.getActiveValue(TreeChromosomes.SPECIES);
        boolean isDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        for (ILeafTickHandler tickHandler : primary.getType().getLeafTickHandlers()) {
            if (!tickHandler.onRandomLeafTick(tree, this.f_58857_, rand, this.m_58899_(), isDestroyed)) continue;
            return;
        }
        if (isDestroyed) {
            return;
        }
        if (this.damage > 0) {
            --this.damage;
        }
        if (this.hasFruit() && this.getRipeningTime() < this.ripeningPeriod) {
            float sappiness = genome.getActiveValue(TreeChromosomes.SAPPINESS);
            if (rand.m_188501_() < sappiness) {
                ++this.ripeningTime;
                this.sendNetworkUpdateRipening();
            }
        }
        if (this.caterpillar != null) {
            this.matureCaterpillar();
        }
        this.effectData = tree.doEffect(this.effectData, this.f_58857_, this.m_58899_());
    }

    @Override
    public void setTree(ITree tree) {
        ITree oldTree = this.getTree();
        super.setTree(tree);
        IGenome genome = tree.getGenome();
        this.species = genome.getActiveValue(TreeChromosomes.SPECIES);
        if (oldTree != null && tree.getSpecies() != oldTree.getSpecies() || this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.setFruit(tree, false);
        }
        this.requestModelDataUpdate();
        this.m_6596_();
    }

    public void setFruit(ITree tree, boolean alwaysFruit) {
        IFruit fruitProvider;
        IGenome genome = tree.getGenome();
        if (tree.hasFruitLeaves() && this.f_58857_ != null && !this.f_58857_.f_46443_ && (fruitProvider = genome.getActiveValue(TreeChromosomes.FRUIT)).isFruitLeaf()) {
            boolean bl = this.isFruitLeaf = alwaysFruit || fruitProvider.getFruitChance(genome, (LevelAccessor)this.f_58857_) >= this.f_58857_.f_46441_.m_188501_();
        }
        if (this.isFruitLeaf) {
            IFruit fruit = genome.getActiveValue(TreeChromosomes.FRUIT);
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.fruitSprite = fruit.getSprite(genome, (BlockGetter)this.f_58857_, this.m_58899_(), this.getRipeningTime());
            }
            this.ripeningPeriod = (short)fruit.getRipeningPeriod();
        } else if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.fruitSprite = null;
        }
    }

    private static boolean isDestroyed(@Nullable ITree tree, int damage) {
        return tree != null && damage > tree.getResilience();
    }

    public boolean isPollinated() {
        ITree tree = this.getTree();
        return tree != null && !TileLeaves.isDestroyed(tree, this.damage) && tree.getMate() != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getFoliageColour() {
        int baseColor = IForestryClientApi.INSTANCE.getTreeManager().getTint(this.species).get((BlockAndTintGetter)this.f_58857_, this.f_58858_);
        ITree tree = this.getTree();
        if (TileLeaves.isDestroyed(tree, this.damage)) {
            return ColourUtil.addRGBComponents(baseColor, 92, 61, 0);
        }
        if (this.caterpillar != null) {
            return ColourUtil.multiplyRGBComponents(baseColor, 1.5f);
        }
        return baseColor;
    }

    public int getFruitColour() {
        if (this.colourFruits == 0 && this.hasFruit()) {
            this.colourFruits = this.determineFruitColour();
        }
        return this.colourFruits;
    }

    private int determineFruitColour() {
        ITree tree = this.getTree();
        if (tree == null) {
            tree = (ITree)SpeciesUtil.getTreeSpecies(ForestryTreeSpecies.HILL_CHERRY).createIndividual();
        }
        IGenome genome = tree.getGenome();
        IFruit fruit = genome.getActiveValue(TreeChromosomes.FRUIT);
        return fruit.getColour(genome, (BlockGetter)this.f_58857_, this.m_58899_(), this.getRipeningTime());
    }

    public ModelData getModelData() {
        ModelData.Builder builder = ModelData.builder();
        builder.with(PROPERTY_SPECIES, (Object)this.species);
        builder.with(PROPERTY_POLLINATED, (Object)this.isPollinatedState);
        builder.with(PROPERTY_FRUIT_TEXTURE, (Object)this.fruitSprite);
        return builder.build();
    }

    public int getRipeningTime() {
        return this.ripeningTime;
    }

    public void setMate(ITree pollen) {
        this.getTree().setMate(pollen.getGenome());
        if (!this.f_58857_.f_46443_) {
            this.sendNetworkUpdate();
        }
    }

    public void sendNetworkUpdate() {
        NetworkUtil.sendNetworkPacket(new PacketTileStream(this), this.f_58858_, this.f_58857_);
    }

    private void sendNetworkUpdateRipening() {
        if (this.m_58901_()) {
            return;
        }
        int newColourFruits = this.determineFruitColour();
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        PacketRipeningUpdate ripeningUpdate = new PacketRipeningUpdate(this);
        NetworkUtil.sendNetworkPacket(ripeningUpdate, this.f_58858_, this.f_58857_);
        this.m_6596_();
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        super.writeData(data);
        int leafState = 0;
        IGenome genome = this.getTree().getGenome();
        AllelePair<ITreeEffect> effects = genome.getAllelePair(TreeChromosomes.EFFECT);
        boolean hasActiveEffect = effects.active() != ForestryAlleles.TREE_EFFECT_NONE;
        boolean hasInactiveEffect = effects.inactive() != ForestryAlleles.TREE_EFFECT_NONE;
        boolean hasFruit = this.hasFruit();
        if (this.isPollinated()) {
            leafState = (byte)(leafState | 2);
        }
        if (hasFruit) {
            leafState = (byte)(leafState | 1);
        }
        if (hasActiveEffect) {
            leafState = (byte)(leafState | 4);
        }
        if (hasInactiveEffect) {
            leafState = (byte)(leafState | 8);
        }
        data.writeByte(leafState);
        if (hasFruit) {
            String fruitAlleleUID = ((IValueAllele)((Object)genome.getActiveAllele(TreeChromosomes.FRUIT))).alleleId().toString();
            int colourFruits = this.getFruitColour();
            data.m_130070_(fruitAlleleUID);
            data.writeInt(colourFruits);
        }
        if (hasActiveEffect) {
            data.m_130070_(((IValueAllele)((Object)effects.active())).alleleId().toString());
        }
        if (hasInactiveEffect) {
            data.m_130070_(((IValueAllele)((Object)effects.inactive())).alleleId().toString());
        }
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        byte leafState;
        ResourceLocation speciesId = null;
        if (data.readBoolean()) {
            speciesId = data.m_130281_();
        }
        this.isPollinatedState = ((leafState = data.readByte()) & 2) != 0;
        this.isFruitLeaf = (leafState & 1) != 0;
        boolean hasActiveEffect = (leafState & 4) != 0;
        boolean hasInactiveEffect = (leafState & 8) != 0;
        ResourceLocation fruitId = null;
        if (this.isFruitLeaf) {
            fruitId = data.m_130281_();
            this.colourFruits = data.readInt();
        }
        ResourceLocation activeEffectAlleleId = hasActiveEffect ? data.m_130281_() : null;
        ResourceLocation inactiveEffectAlleleId = hasInactiveEffect ? data.m_130281_() : null;
        ITreeSpecies treeTemplate = (ITreeSpecies)((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getSpeciesSafe(speciesId);
        if (treeTemplate != null) {
            IdentityHashMap alleles = new IdentityHashMap(2);
            if (fruitId != null) {
                alleles.put(TreeChromosomes.FRUIT, AllelePair.both(Objects.requireNonNull(ForestryAlleles.REGISTRY.getAllele(fruitId))));
            }
            IValueAllele<ITreeEffect> activeEffectAllele = ForestryAlleles.REGISTRY.getAllele(activeEffectAlleleId);
            IValueAllele<ITreeEffect> inactiveEffectAllele = ForestryAlleles.REGISTRY.getAllele(inactiveEffectAlleleId);
            if (activeEffectAllele != null || inactiveEffectAllele != null) {
                alleles.put(TreeChromosomes.EFFECT, new AllelePair<IValueAllele<ITreeEffect>>(activeEffectAllele != null ? activeEffectAllele : ForestryAlleles.TREE_EFFECT_NONE, inactiveEffectAllele != null ? inactiveEffectAllele : ForestryAlleles.TREE_EFFECT_NONE));
            }
            ITree tree = (ITree)treeTemplate.createIndividualFromPairs(alleles);
            if (this.isPollinatedState) {
                tree.setMate(tree.getGenome());
            }
            this.setTree(tree);
            ClientsideCode.markForUpdate(this.f_58858_);
        }
    }

    @Override
    public void fromRipeningPacket(int newColourFruits) {
        if (newColourFruits == this.colourFruits) {
            return;
        }
        this.colourFruits = newColourFruits;
        ClientsideCode.markForUpdate(this.f_58858_);
    }

    @Override
    public List<ItemStack> pickFruit(ItemStack tool) {
        ITree tree = this.getTree();
        if (tree == null || !this.hasFruit()) {
            return List.of();
        }
        List<ItemStack> produceStacks = tree.produceStacks(this.f_58857_, this.f_58858_, this.getRipeningTime());
        this.ripeningTime = 0;
        this.sendNetworkUpdateRipening();
        return produceStacks;
    }

    @Override
    public float getRipeness() {
        if (this.ripeningPeriod == 0) {
            return 1.0f;
        }
        if (this.getTree() == null) {
            return 0.0f;
        }
        return (float)this.ripeningTime / (float)this.ripeningPeriod;
    }

    @Override
    public boolean hasFruit() {
        return this.isFruitLeaf && !TileLeaves.isDestroyed(this.getTree(), this.damage);
    }

    @Override
    public void addRipeness(float add) {
        if (this.getTree() == null || !this.isFruitLeaf || this.getRipeningTime() >= this.ripeningPeriod) {
            return;
        }
        this.ripeningTime = (int)((float)this.ripeningTime + (float)this.ripeningPeriod * add);
        this.sendNetworkUpdateRipening();
    }

    private void matureCaterpillar() {
        if (this.caterpillar == null) {
            return;
        }
        ++this.maturationTime;
        ITree tree = this.getTree();
        boolean wasDestroyed = TileLeaves.isDestroyed(tree, this.damage);
        this.damage += this.caterpillar.getGenome().getActiveValue(ButterflyChromosomes.METABOLISM);
        IGenome caterpillarGenome = this.caterpillar.getGenome();
        int caterpillarMatureTime = Math.round((float)caterpillarGenome.getActiveValue(ButterflyChromosomes.LIFESPAN) / (float)(caterpillarGenome.getActiveValue(ButterflyChromosomes.FERTILITY) * 2));
        if (this.maturationTime >= caterpillarMatureTime) {
            ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).plantCocoon((LevelAccessor)this.f_58857_, this.f_58858_, this.caterpillar, 0, false);
            this.setCaterpillar(null);
        } else if (!wasDestroyed && TileLeaves.isDestroyed(tree, this.damage)) {
            this.sendNetworkUpdate();
        }
    }

    @Override
    public BlockPos getCoordinates() {
        return this.m_58899_();
    }

    @Override
    @Nullable
    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    @Override
    public IIndividual getNanny() {
        return this.getTree();
    }

    @Override
    public void setCaterpillar(@Nullable IButterfly caterpillar) {
        this.maturationTime = 0;
        this.caterpillar = caterpillar;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean canNurse(IButterfly caterpillar) {
        ITree tree = this.getTree();
        return !TileLeaves.isDestroyed(tree, this.damage) && this.caterpillar == null;
    }

    @Override
    public Holder<Biome> getBiome() {
        return this.f_58857_.m_204166_(this.f_58858_);
    }

    @Override
    public TemperatureType temperature() {
        return IForestryApi.INSTANCE.getClimateManager().getTemperature(this.getBiome());
    }

    @Override
    public HumidityType humidity() {
        return IForestryApi.INSTANCE.getClimateManager().getHumidity(this.getBiome());
    }

    @Override
    public Level getWorldObj() {
        return this.f_58857_;
    }

    @Override
    public boolean isHighlighted(Player player) {
        return this.isPollinated();
    }
}

