/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.entities.ForestryBoat;
import forestry.arboriculture.entities.ForestryChestBoat;
import forestry.core.items.ItemForestry;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemForestryBoat
extends ItemForestry {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final ForestryWoodType type;
    private final boolean hasChest;

    public ItemForestryBoat(ForestryWoodType type, boolean hasChest) {
        super(new Item.Properties().m_41487_(1));
        this.type = type;
        this.hasChest = hasChest;
    }

    public Component m_7626_(ItemStack itemstack) {
        return Component.m_237110_((String)("for." + (this.hasChest ? "chest_boat" : "boat") + ".grammar"), (Object[])new Object[]{Component.m_237115_((String)("for.trees.woodType." + this.type))});
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BlockHitResult hit = ItemForestryBoat.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hit.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        Vec3 view = player.m_20252_(1.0f);
        List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(view.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec31)) continue;
                return InteractionResultHolder.m_19098_((Object)stack);
            }
        }
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            ForestryBoat boat = this.getBoat(level, (HitResult)hit);
            boat.setWoodType(this.type);
            boat.m_146922_(player.m_146908_());
            if (!level.m_45756_((Entity)boat, boat.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!level.f_46443_) {
                level.m_7967_((Entity)boat);
                level.m_220400_((Entity)player, GameEvent.f_157810_, hit.m_82450_());
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private ForestryBoat getBoat(Level level, HitResult hit) {
        Vec3 location = hit.m_82450_();
        return this.hasChest ? new ForestryChestBoat(level, location.f_82479_, location.f_82480_, location.f_82481_) : new ForestryBoat(level, location.f_82479_, location.f_82480_, location.f_82481_);
    }
}

