/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.api.arboriculture.ITreeGenData;
import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeEffect;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.core.IProduct;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.core.genetics.Individual;
import forestry.core.genetics.mutations.Mutation;
import forestry.core.utils.SpeciesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class Tree
extends Individual<ITreeSpecies, ITree, ITreeSpeciesType>
implements ITree,
IPlantable {
    public static final Codec<Tree> CODEC = RecordCodecBuilder.create(instance -> {
        Codec<IGenome> genomeCodec = ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getKaryotype().getGenomeCodec();
        return Individual.fields(instance, genomeCodec).apply((Applicative)instance, Tree::new);
    });

    public Tree(IGenome genome) {
        super(genome);
    }

    private Tree(IGenome genome, Optional<IGenome> mate, boolean analyzed) {
        super(genome, mate, analyzed);
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, Level level, BlockPos pos) {
        ITreeEffect effect = this.genome.getActiveValue(TreeChromosomes.EFFECT);
        storedData[0] = this.doEffect(effect, storedData[0], level, pos);
        if (!effect.isCombinable()) {
            return storedData;
        }
        ITreeEffect secondary = this.genome.getInactiveValue(TreeChromosomes.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], level, pos);
        return storedData;
    }

    private IEffectData doEffect(ITreeEffect effect, IEffectData storedData, Level world, BlockPos pos) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.getGenome(), storedData, world, pos);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, Level level, BlockPos pos) {
        return storedData;
    }

    @Override
    public Feature<NoneFeatureConfiguration> getTreeGenerator(WorldGenLevel level, BlockPos pos, boolean wasBonemealed) {
        return ((ITreeSpecies)this.species).getGenerator().getTreeFeature((ITreeGenData)this.getSpecies());
    }

    @Override
    public boolean canStay(BlockGetter level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState state = level.m_8055_(below);
        Block block = state.m_60734_();
        return block.canSustainPlant(state, level, below, Direction.UP, (IPlantable)this);
    }

    public BlockState getPlant(BlockGetter level, BlockPos pos) {
        return level.m_8055_(pos);
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.PLAINS;
    }

    @Override
    public int getRequiredMaturity() {
        return this.genome.getActiveValue(TreeChromosomes.MATURATION);
    }

    @Override
    public int getResilience() {
        int base = (int)(this.getGenome().getActiveValue(TreeChromosomes.SAPLINGS) * this.getGenome().getActiveValue(TreeChromosomes.SAPPINESS) * 100.0f);
        return Math.max(base, 1) * 10;
    }

    @Override
    public List<ITree> getSaplings(Level level, BlockPos pos, @Nullable GameProfile playerProfile, float modifier) {
        ArrayList<ITree> prod = new ArrayList<ITree>();
        float chance = this.genome.getActiveValue(TreeChromosomes.SAPLINGS) * modifier;
        if (level.f_46441_.m_188501_() <= chance) {
            if (this.mate == null) {
                prod.add((ITree)this.copy());
            } else {
                SpeciesUtil.ISpeciesMutator mutator = (p1, p2) -> Tree.mutateSpecies(level, playerProfile, pos, p1, p2);
                prod.add(SpeciesUtil.createOffspring(level.f_46441_, this.genome, this.mate, mutator, Tree::new));
            }
        }
        return prod;
    }

    @Nullable
    private static ImmutableList<AllelePair<?>> mutateSpecies(Level treeLevel, @Nullable GameProfile profile, BlockPos treePos, IGenome parent1, IGenome parent2) {
        return SpeciesUtil.mutateSpecies(treeLevel, treePos, profile, parent1, parent2, TreeChromosomes.SPECIES, Mutation::getChance);
    }

    @Override
    public boolean hasFruitLeaves() {
        return this.genome.getActiveValue(TreeChromosomes.FRUIT).isFruitLeaf();
    }

    @Override
    public List<IProduct> getProducts() {
        return this.genome.getActiveValue(TreeChromosomes.FRUIT).getProducts();
    }

    @Override
    public List<IProduct> getSpecialties() {
        return this.genome.getActiveValue(TreeChromosomes.FRUIT).getSpecialty();
    }

    @Override
    public List<ItemStack> produceStacks(Level level, BlockPos pos, int ripeningTime) {
        return this.genome.getActiveValue(TreeChromosomes.FRUIT).getFruits(this.genome, level, ripeningTime);
    }
}

