/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.arboriculture.ForestryWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.VanillaWoodType;
import forestry.arboriculture.blocks.BlockForestryPlank;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.modules.features.FeatureBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class BlockForestryLog
extends RotatedPillarBlock
implements IWoodTyped {
    private final WoodBlockKind kind;
    private final boolean fireproof;
    private final IWoodType woodType;

    public BlockForestryLog(WoodBlockKind kind, boolean fireproof, IWoodType woodType) {
        super(BlockForestryPlank.createWoodProperties(woodType));
        this.kind = kind;
        this.fireproof = fireproof;
        this.woodType = woodType;
    }

    @Override
    public WoodBlockKind getBlockKind() {
        return this.kind;
    }

    @Override
    public final boolean isFireproof() {
        return this.fireproof;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    public final int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        if (face == Direction.DOWN) {
            return 20;
        }
        if (face != Direction.UP) {
            return 10;
        }
        return 5;
    }

    public final int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        if (toolAction == ToolActions.AXE_STRIP) {
            IWoodType iWoodType = this.woodType;
            if (iWoodType instanceof ForestryWoodType) {
                ForestryWoodType type = (ForestryWoodType)iWoodType;
                if (this.kind == WoodBlockKind.LOG) {
                    return (BlockState)((FeatureBlock)(this.fireproof ? ArboricultureBlocks.STRIPPED_LOGS_FIREPROOF : ArboricultureBlocks.STRIPPED_LOGS).get(type)).defaultState().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)));
                }
                if (this.kind == WoodBlockKind.WOOD) {
                    return (BlockState)((FeatureBlock)(this.fireproof ? ArboricultureBlocks.STRIPPED_WOOD_FIREPROOF : ArboricultureBlocks.STRIPPED_WOOD).get(type)).defaultState().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)));
                }
            } else {
                iWoodType = this.woodType;
                if (iWoodType instanceof VanillaWoodType) {
                    VanillaWoodType type = (VanillaWoodType)iWoodType;
                    if (this.kind == WoodBlockKind.LOG) {
                        return (BlockState)((FeatureBlock)ArboricultureBlocks.STRIPPED_LOGS_VANILLA_FIREPROOF.get(type)).defaultState().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)));
                    }
                    if (this.kind == WoodBlockKind.WOOD) {
                        return (BlockState)((FeatureBlock)ArboricultureBlocks.STRIPPED_WOOD_VANILLA_FIREPROOF.get(type)).defaultState().m_61124_((Property)f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)f_55923_)));
                    }
                }
            }
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }
}

