/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.IForestryApi;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBeeEffect;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.apiculture.genetics.Bee;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.VecUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public abstract class NonStackingBeeEffect
implements IBeeEffect {
    private final HashMap<ResourceKey<Level>, HashSet<BlockPos>> trackedOwners;
    private final boolean dominant;

    public NonStackingBeeEffect(boolean dominant) {
        this.dominant = dominant;
        this.trackedOwners = new HashMap();
        MinecraftForge.EVENT_BUS.addListener(this::performGlobalEffect);
    }

    @Override
    public IEffectData doEffect(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        if ((housing.getWorldObj().m_46467_() & 0x40L) == 0L) {
            this.trackedOwners.computeIfAbsent((ResourceKey<Level>)housing.getWorldObj().m_46472_(), key -> new HashSet()).add(housing.getCoordinates());
        }
        return IBeeEffect.super.doEffect(genome, storedData, housing);
    }

    @Override
    public boolean isDominant() {
        return this.dominant;
    }

    private void performGlobalEffect(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Level level = event.level;
        if (level.f_46443_ || level.m_46467_() % 550L != 0L) {
            return;
        }
        HashSet owners = this.trackedOwners.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> new HashSet());
        HashSet<BlockPos> affectedHives = new HashSet<BlockPos>();
        Iterator iterator = owners.iterator();
        while (iterator.hasNext()) {
            IIndividual queen;
            IGenome genome;
            IIndividualHandlerItem handler;
            BlockPos pos = (BlockPos)iterator.next();
            IBeeHousing housing = TileUtil.getTile((BlockGetter)level, pos, IBeeHousing.class);
            if (!(housing == null || housing.getErrorLogic().hasErrors() || (handler = IIndividualHandlerItem.get(housing.getBeeInventory().getQueen())) == null || handler.getStage() != BeeLifeStage.QUEEN || (genome = (queen = handler.getIndividual()).getGenome()).getActiveValue(BeeChromosomes.EFFECT) != this && genome.getInactiveValue(BeeChromosomes.EFFECT) != this)) {
                IBeeModifier modifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(housing);
                Vec3i territory = Bee.getAdjustedTerritory(genome, modifier);
                this.affectNearbyTiles(affectedHives, level, pos, territory);
                continue;
            }
            iterator.remove();
        }
    }

    private void affectNearbyTiles(HashSet<BlockPos> affectedHives, Level level, BlockPos pos, Vec3i territory) {
        BlockPos topLeft = pos.m_121955_(VecUtil.center(territory));
        BlockPos bottomRight = topLeft.m_121955_(territory);
        int topLeftX = topLeft.m_123341_();
        int topLeftZ = topLeft.m_123343_();
        int bottomRightX = bottomRight.m_123341_();
        int bottomRightZ = bottomRight.m_123343_();
        int territoryX = territory.m_123341_();
        int territoryY = territory.m_123342_();
        int territoryZ = territory.m_123343_();
        for (int x = SectionPos.m_123171_((int)topLeftX); x <= SectionPos.m_123171_((int)bottomRightX); ++x) {
            for (int z = SectionPos.m_123171_((int)topLeftZ); z <= SectionPos.m_123171_((int)bottomRightZ); ++z) {
                if (!level.m_7232_(x, z)) continue;
                for (Map.Entry entry : level.m_6325_(x, z).m_62954_().entrySet()) {
                    int targetZ;
                    int targetY;
                    int targetX;
                    BlockPos targetPos = (BlockPos)entry.getKey();
                    Object v = entry.getValue();
                    if (!(v instanceof IBeeHousing)) continue;
                    IBeeHousing housing = (IBeeHousing)v;
                    if (targetPos.equals((Object)pos) || affectedHives.contains(targetPos) || (targetX = targetPos.m_123341_()) < topLeftX || targetX >= topLeftX + territoryX || (targetY = targetPos.m_123342_()) < topLeft.m_123342_() || targetY >= topLeft.m_123342_() + territoryY || (targetZ = targetPos.m_123343_()) < topLeftZ || targetZ >= topLeftZ + territoryZ || !affectedHives.add(targetPos)) continue;
                    this.doEffectForHive(level, housing);
                }
            }
        }
    }

    protected abstract void doEffectForHive(Level var1, IBeeHousing var2);
}

