/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IActivityType;
import forestry.api.apiculture.LightPreference;
import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import org.joml.Vector2i;

public class CathemeralActivityType
implements IActivityType {
    private static final PerlinNoise NOISE = PerlinNoise.m_230529_((RandomSource)RandomSource.m_216335_((long)13L), List.of(Integer.valueOf(5), Integer.valueOf(3), Integer.valueOf(6)));

    public static Vector2i getSleepPeriod(BlockPos pos) {
        int offset = (int)CathemeralActivityType.getOffset(pos);
        if (offset > 0) {
            return new Vector2i(24000 - offset, -12000 + (24000 - offset));
        }
        return new Vector2i(-offset, 12000 - offset);
    }

    private static long getOffset(BlockPos pos) {
        return (long)(NOISE.m_75408_((double)pos.m_123341_() / 40.0, (double)pos.m_123342_() / 1000.0, (double)pos.m_123343_() / 40.0) * 24000.0);
    }

    @Override
    public boolean isActive(long gameTime, long dayTime, BlockPos pos) {
        long adjustedTime = dayTime + CathemeralActivityType.getOffset(pos);
        return adjustedTime % 24000L < 12000L;
    }

    @Override
    public IError getInactiveError(long gameTime, long dayTime, BlockPos pos) {
        return ForestryError.SLEEPY;
    }

    @Override
    public LightPreference getLightPreference() {
        return LightPreference.ANY;
    }

    @Override
    public boolean isDominant() {
        return false;
    }
}

