/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.core.tooltips;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public interface ITextInstance<I extends ITextInstance<?, ?, ?>, S, R> {
    default public I text(String text) {
        return this.add((Component)Component.m_237113_((String)text));
    }

    default public I translated(String text, Object ... args) {
        return this.add((Component)Component.m_237110_((String)text, (Object[])args));
    }

    default public I style(ChatFormatting ... formatting) {
        this.applyFormatting(component -> component.m_130944_(formatting));
        return this.cast();
    }

    default public I style(ChatFormatting formatting) {
        this.applyFormatting(component -> component.m_130940_(formatting));
        return this.cast();
    }

    default public I style(Style style) {
        this.applyFormatting(component -> component.m_130948_(style));
        return this.cast();
    }

    default public I style(UnaryOperator<Style> style) {
        this.applyFormatting(component -> component.m_130938_(style));
        return this.cast();
    }

    default public I add(Component line, ChatFormatting format) {
        if (line instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)line;
            mutable.m_130940_(format);
        }
        return this.add(line);
    }

    default public I add(Component line, ChatFormatting ... format) {
        if (line instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)line;
            mutable.m_130944_(format);
        }
        return this.add(line);
    }

    default public I add(Component line, Style style) {
        if (line instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)line;
            mutable.m_130948_(style);
        }
        return this.add(line);
    }

    default public I addAll(Component ... lines) {
        for (Component line : lines) {
            this.add(line);
        }
        return this.cast();
    }

    default public I addAll(Collection<Component> lines) {
        for (Component line : lines) {
            this.add(line);
        }
        return this.cast();
    }

    default public I applyFormatting(Consumer<MutableComponent> action) {
        Component last = this.lastComponent();
        if (last instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)last;
            action.accept(mutable);
        }
        return this.cast();
    }

    default public I apply(Consumer<Component> action) {
        Component last = this.lastComponent();
        if (last != null) {
            action.accept(last);
        }
        return this.cast();
    }

    public I cast();

    @Nullable
    public Component lastComponent();

    public I add(Component var1);

    public S singleLine();

    public R create();

    public boolean isEmpty();
}

