/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.TaskListBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.renderers.SpecialFirstEverRenderer;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessaging;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class TaskListPanelTESR
implements BlockEntityRenderer<TaskListBlockEntity> {
    private static final Quaternionf XPlus180 = new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 180.0f);
    private static final Quaternionf YPlus180 = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 180.0f);
    private static final Quaternionf YPlus090 = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 90.0f);
    private static final Quaternionf YPlus270 = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 270.0f);
    private static final Quaternionf ZPlus180 = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 180.0f);
    private static final int textColorMain = 0x444455;
    private static final int textColorGrayed = 0x858585;
    private static final int textColorDividers = 0x9A9A95;

    public TaskListPanelTESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(TaskListBlockEntity tile, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLight, int combinedOverlay) {
        if (!((Boolean)OptionsHolder.CLIENT.TaskListItemsAreDrawnOnWall.get()).booleanValue()) {
            return;
        }
        Direction direction = (Direction)tile.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        poseStack.m_85836_();
        if (direction.equals((Object)Direction.NORTH)) {
            poseStack.m_252781_(ZPlus180);
            poseStack.m_252880_(-1.0f, -1.0f, 0.925f);
        }
        if (direction.equals((Object)Direction.EAST)) {
            poseStack.m_252781_(XPlus180);
            poseStack.m_252781_(YPlus270);
            poseStack.m_252880_(-1.0f, -1.0f, -0.068750024f);
        }
        if (direction.equals((Object)Direction.SOUTH)) {
            poseStack.m_252781_(ZPlus180);
            poseStack.m_252781_(YPlus180);
            poseStack.m_252880_(0.0f, -1.0f, -0.07499999f);
        }
        if (direction.equals((Object)Direction.WEST)) {
            poseStack.m_252781_(XPlus180);
            poseStack.m_252781_(YPlus090);
            poseStack.m_252880_(0.0f, -1.0f, 0.93125f);
        }
        poseStack.m_85841_(0.0035f, 0.0045f, 0.005f);
        int normalTextLight = 0x410041;
        int finishedTextLight = 0x410041;
        combinedLight = this.reduceLightBasedOnDirection(combinedLight, direction);
        normalTextLight = this.reduceLightBasedOnDirection(normalTextLight, direction);
        finishedTextLight = this.reduceLightBasedOnDirection(finishedTextLight, direction);
        float hpixel = 17.0f;
        float vpixel = 13.0f;
        float itemTextStart = 4.5f;
        TaskListMessaging.TaskPageDTO page = tile.getPageForDisplay();
        for (int i = 0; i < 6; ++i) {
            int color = 0x444455;
            int light = normalTextLight;
            if (((Boolean)OptionsHolder.CLIENT.TaskListColoringForFinishedItems.get()).booleanValue() && (page.items().get(i).status().equals("y") || page.items().get(i).status().equals("n"))) {
                color = 0x858585;
                light = finishedTextLight;
            }
            Minecraft.m_91087_().f_91062_.m_271703_(page.items().get(i).line1(), 76.5f, (float)(3 + 2 * i) * 13.0f, color, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, light);
            Minecraft.m_91087_().f_91062_.m_271703_(page.items().get(i).line2(), 76.5f, (float)(3 + 2 * i + 1) * 13.0f, color, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, light);
        }
        Minecraft.m_91087_().f_91062_.m_271703_("<<", 51.0f, 195.0f, 0x444455, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, normalTextLight);
        Minecraft.m_91087_().f_91062_.m_271703_(tile.getFooter(), 136.0f, 195.0f, 0x444455, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, normalTextLight);
        Minecraft.m_91087_().f_91062_.m_271703_(">>", 229.5f, 195.0f, 0x444455, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, normalTextLight);
        int lightColor = tile.m_58904_() != null ? LevelRenderer.m_109541_((BlockAndTintGetter)tile.m_58904_(), (BlockPos)tile.m_58899_()) : -1;
        for (int i = 0; i < 6; ++i) {
            SpecialFirstEverRenderer.render(page.items().get(i).status(), 3.0f, (float)(3 + 2 * i) + 0.5f, poseStack, multiBufferSource, combinedLight, combinedOverlay, lightColor);
        }
        float scaleX = 32.0f;
        poseStack.m_85841_(scaleX, 1.0f, 0.25f);
        float intendedStart = 3.5f;
        float start = 0.0f * intendedStart + 0.115f;
        for (int i = 0; i < 5; ++i) {
            Minecraft.m_91087_().f_91062_.m_271703_("_", start * 17.0f, ((float)(4 + 2 * i) + 0.2f) * 13.0f, 0x9A9A95, false, poseStack.m_85850_().m_252922_(), multiBufferSource, Font.DisplayMode.NORMAL, 0, 0x220022);
        }
        poseStack.m_85849_();
    }

    private int reduceLightBasedOnDirection(int originalLight, Direction direction) {
        int mul = direction.equals((Object)Direction.NORTH) || direction.equals((Object)Direction.SOUTH) ? 80 : 65;
        int byteValue = originalLight >> 16 & 0xFF;
        int result = byteValue = byteValue * mul / 100;
        byteValue = originalLight >> 8 & 0xFF;
        byteValue = byteValue * mul / 100;
        result = (result << 8) + byteValue;
        byteValue = originalLight & 0xFF;
        byteValue = byteValue * mul / 100;
        result = (result << 8) + byteValue;
        return result;
    }
}

