/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities;

import java.util.ArrayList;
import moonfather.workshop_for_handsome_adventurer.items.task_list.RegistrationForTaskList;
import moonfather.workshop_for_handsome_adventurer.items.task_list.block_entities.BasicBlockEntity;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.TaskListItem;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListComponent;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessageSender;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessaging;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.screens.TaskListClientInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TaskListBlockEntity
extends BasicBlockEntity
implements Nameable {
    private int currentPage;
    private TaskListComponent data;
    private String title = "asdfg";
    private Component titleAsComponent = null;
    private boolean isFireResistant = false;
    private ItemStack item;
    private boolean isModified = false;
    private static final TaskListMessaging.TaskPageDTO EMPTY = new TaskListMessaging.TaskPageDTO(1, null);
    private String footer = null;

    public TaskListBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public TaskListBlockEntity(BlockPos pos, BlockState blockState) {
        super(RegistrationForTaskList.TASK_LIST_PANEL_BE.get(), pos, blockState);
    }

    public void setItem(ItemStack taskList) {
        this.item = taskList;
        this.data = TaskListItem.Component.get(taskList);
        if (this.data == null) {
            this.data = new TaskListComponent(1, 1, null);
        }
        this.currentPage = this.data.getLastPageNumber();
        this.title = TaskListItem.Utility.getTitle(this.item);
        this.isFireResistant = TaskListItem.Utility.isFireImmune(this.item);
        this.titleAsComponent = null;
        this.m_6596_();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int newPage) {
        this.currentPage = newPage;
    }

    public TaskListMessaging.TaskPageDTO getPageForDisplay() {
        if (this.data == null) {
            return EMPTY;
        }
        return this.data.getAllPages().get(this.currentPage - 1);
    }

    public int getPageCount() {
        if (this.data == null) {
            return 7;
        }
        return this.data.getPageCount();
    }

    public boolean isFireResistant() {
        return this.isFireResistant;
    }

    public String getTitle() {
        return this.title;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isModified = tag.m_128471_("isModified");
        if (tag.m_128441_("original")) {
            ItemStack op = ItemStack.m_41712_((CompoundTag)tag.m_128469_("original"));
            this.setItem(op);
            this.setCurrentPage(tag.m_128451_("currentPage"));
            return;
        }
        this.setItem(TaskListItem.Utility.createInstance());
        this.setCurrentPage(1);
        if (tag.m_128441_("checkmarks")) {
            int[] checkmarks = tag.m_128465_("checkmarks");
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (this.data.getAllPages().get(i).items().get(j).status().codePointAt(0) == checkmarks[i * 6 + j]) continue;
                    this.data.getAllPages().get(i).items().set(j, new TaskListMessaging.TaskItemDTO(Character.toString(checkmarks[i * 6 + j]), this.data.getAllPages().get(i).items().get(j).line1(), this.data.getAllPages().get(i).items().get(j).line2()));
                }
            }
        }
    }

    @Override
    protected CompoundTag saveInternal(CompoundTag compoundTag) {
        compoundTag.m_128379_("isModified", this.isModified);
        compoundTag.m_128405_("currentPage", this.getCurrentPage());
        compoundTag.m_128365_("original", (Tag)this.item.m_41739_(new CompoundTag()));
        ArrayList<Integer> checkmarks = new ArrayList<Integer>(24);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 6; ++j) {
                checkmarks.add(this.data.getAllPages().get(i).items().get(j).status().codePointAt(0));
            }
        }
        compoundTag.m_128408_("checkmarks", checkmarks);
        return compoundTag;
    }

    public String getFooter() {
        if (this.data == null) {
            return "1/8";
        }
        if (this.footer == null) {
            this.footer = this.getCurrentPage() + "/" + this.getPageCount();
        }
        return this.footer;
    }

    public void onArrowPrev() {
        if (this.getCurrentPage() > 1) {
            this.setCurrentPage(this.getCurrentPage() - 1);
            this.m_6596_();
        }
    }

    public void onArrowNext() {
        if (this.getCurrentPage() < this.getPageCount()) {
            this.setCurrentPage(this.getCurrentPage() + 1);
            this.m_6596_();
        }
    }

    public void onClientArrowNext() {
        if (this.getCurrentPage() < this.getPageCount()) {
            this.onArrowNext();
            this.footer = null;
            TaskListMessageSender.sendBlockClickPageRightToServer(this.m_58899_());
        }
    }

    public void onClientArrowPrev() {
        if (this.getCurrentPage() > 1) {
            this.onArrowPrev();
            this.footer = null;
            TaskListMessageSender.sendBlockClickPageLeftToServer(this.m_58899_());
        }
    }

    public void checkmarkClickedOnBlock(int index) {
        this.updateCheckmark(index, this.getCurrentPage());
        TaskListMessageSender.sendBlockCheckmarkToServer(this.m_58899_(), index, this.getCurrentPage());
    }

    public void updateCheckmark(int index, int pageNumber) {
        if (this.getCurrentPage() != pageNumber) {
            this.setCurrentPage(pageNumber);
        }
        TaskListMessaging.TaskItemDTO old = this.data.getAllPages().get(pageNumber - 1).items().get(index);
        String newValue = switch (old.status()) {
            case "e" -> "y";
            case "y" -> "n";
            case "n" -> "q";
            default -> "e";
        };
        this.data.getAllPages().get(pageNumber - 1).items().set(index, new TaskListMessaging.TaskItemDTO(newValue, old.line1(), old.line2()));
        this.m_6596_();
    }

    public void invokeGUI() {
        TaskListMessaging.TaskListExtraDTO extra = new TaskListMessaging.TaskListExtraDTO(this.m_58899_(), this.data.getLastPageNumber(), this.getTitle());
        TaskListClientInvoker.invokeScreen(this.data.getAllPages(), this.data.getPageCount(), extra, this.isFireResistant);
    }

    @Nullable
    public Component m_7770_() {
        if (this.titleAsComponent == null) {
            this.titleAsComponent = Component.m_237113_((String)this.title);
        }
        return this.titleAsComponent;
    }

    public Component m_7755_() {
        if (this.titleAsComponent == null) {
            this.titleAsComponent = Component.m_237113_((String)this.title);
        }
        return this.titleAsComponent;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getItemForDrop() {
        ItemStack result = this.item.m_41777_();
        this.data.setLastPage(this.currentPage);
        TaskListItem.Component.set(result, this.data);
        TaskListItem.Utility.setTitle(result, this.title);
        return result;
    }
}

