/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.initialization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import moonfather.workshop_for_handsome_adventurer.block_entities.BookShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.DualTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.DualTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.PotionShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomPrimary;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomSecondary;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableTopSecondary;
import moonfather.workshop_for_handsome_adventurer.blocks.BookShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.DualToolRack;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.SimpleTable;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.SecondCreativeTab;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeLister;
import moonfather.workshop_for_handsome_adventurer.initialization.ExternalWoodSupport;
import moonfather.workshop_for_handsome_adventurer.items.BlockItemEx;
import moonfather.workshop_for_handsome_adventurer.items.WorkstationPlacerItem;
import moonfather.workshop_for_handsome_adventurer.other.CreativeTab;
import moonfather.workshop_for_handsome_adventurer.other.UnsupportedWoodRecipe;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class Registration {
    private static final DeferredRegister<Block> BLOCKS;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    private static final DeferredRegister<MenuType<?>> CONTAINER_TYPES;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES;
    private static final DeferredRegister<CreativeModeTab> CREATIVE_TABS;
    public static final List<Supplier<Block>> blocks_table1;
    public static final List<Supplier<Block>> blocks_table2;
    public static final List<Supplier<Block>> blocks_rack;
    public static final List<Supplier<Block>> blocks_pshelf;
    public static final List<Supplier<Block>> blocks_bshelf;
    public static final List<RegistryObject<Item>> items_table1;
    public static final List<RegistryObject<Item>> items_table2;
    public static final List<RegistryObject<Item>> items_rack1;
    public static final List<RegistryObject<Item>> items_rack2;
    public static final List<RegistryObject<Item>> items_rack3;
    public static final List<RegistryObject<Item>> items_rack4;
    public static final List<RegistryObject<Item>> items_pshelf;
    public static final List<RegistryObject<Item>> items_bshelf1;
    public static final List<RegistryObject<Item>> items_bshelf2;
    public static final List<RegistryObject<Item>> items_bshelf3;
    public static final List<RegistryObject<Item>> items_bshelf4;
    public static final List<RegistryObject<Item>> items_bshelf5;
    public static final List<String> woodTypes;
    public static final RegistryObject<BlockEntityType<ToolRackBlockEntity>> TOOL_RACK_BE;
    public static final RegistryObject<BlockEntityType<SimpleTableBlockEntity>> SIMPLE_TABLE_BE;
    public static final RegistryObject<BlockEntityType<DualTableBlockEntity>> DUAL_TABLE_BE;
    public static final RegistryObject<BlockEntityType<PotionShelfBlockEntity>> POTION_SHELF_BE;
    public static final RegistryObject<BlockEntityType<BookShelfBlockEntity>> BOOK_SHELF_BE;
    public static final RegistryObject<MenuType<SimpleTableMenu>> CRAFTING_SINGLE_MENU_TYPE;
    public static final RegistryObject<MenuType<DualTableMenu>> CRAFTING_DUAL_MENU_TYPE;
    public static final RegistryObject<RecipeSerializer<UnsupportedWoodRecipe>> TABLE_RECIPE;
    public static final RegistryObject<CreativeModeTab> CREATIVE_TAB;

    public static void init() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCK_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINER_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        RECIPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CREATIVE_TABS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static RegistryObject<Item> FromBlock(RegistryObject<Block> block) {
        Item.Properties properties = new Item.Properties();
        return ITEMS.register(block.getId().m_135815_(), () -> new BlockItemEx((Block)block.get(), properties));
    }

    private static Block[] ListToArray(List<Supplier<Block>> list) {
        Block[] result = new Block[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i).get();
        }
        return result;
    }

    public static void registerSingleBlockForThirdPartyWood(Block block, String prefix, String wood, List<Supplier<Block>> listForBlockEntities, List<Item> listForCreativeTab) {
        BlockItemEx item = new BlockItemEx(block, new Item.Properties());
        ForgeRegistries.BLOCKS.register(prefix + wood, (Object)block);
        ForgeRegistries.ITEMS.register(prefix + wood, (Object)item);
        listForCreativeTab.add((Item)item);
        if (listForBlockEntities != null) {
            listForBlockEntities.add(() -> block);
        }
    }

    public static void registerBlocksForThirdPartyWood(RegisterEvent event) {
        try {
            ((ForgeRegistry)ForgeRegistries.BLOCKS).unfreeze();
            for (String wood : WoodTypeLister.getWoodIds()) {
                Registration.registerSingleBlockForThirdPartyWood(new SimpleTable(), "simple_table_", wood, blocks_table1, SecondCreativeTab.items_table1);
                AdvancedTableBottomPrimary primary = new AdvancedTableBottomPrimary();
                ForgeRegistries.BLOCKS.register("dual_table_bottom_left_" + wood, (Object)primary);
                ForgeRegistries.BLOCKS.register("dual_table_bottom_right_" + wood, (Object)new AdvancedTableBottomSecondary());
                ForgeRegistries.BLOCKS.register("dual_table_top_left_" + wood, (Object)new AdvancedTableTopSecondary());
                ForgeRegistries.BLOCKS.register("dual_table_top_right_" + wood, (Object)new AdvancedTableTopSecondary());
                WorkstationPlacerItem placer = new WorkstationPlacerItem(wood);
                ForgeRegistries.ITEMS.register("workstation_placer_" + wood, (Object)placer);
                blocks_table2.add(() -> primary);
                SecondCreativeTab.items_table2.add(placer);
                ExternalWoodSupport.registerHostMod(wood, "workshop_for_handsome_adventurer");
                Registration.registerSingleBlockForThirdPartyWood(ToolRack.create(2, "single"), "tool_rack_single_", wood, blocks_rack, SecondCreativeTab.items_rack1);
                Registration.registerSingleBlockForThirdPartyWood(DualToolRack.create(6, "framed"), "tool_rack_framed_", wood, blocks_rack, SecondCreativeTab.items_rack2);
                Registration.registerSingleBlockForThirdPartyWood(DualToolRack.create(6, "pframed"), "tool_rack_pframed_", wood, blocks_rack, SecondCreativeTab.items_rack3);
                Registration.registerSingleBlockForThirdPartyWood(DualToolRack.create(6, "double"), "tool_rack_double_", wood, blocks_rack, SecondCreativeTab.items_rack4);
                Registration.registerSingleBlockForThirdPartyWood(new PotionShelf(), "potion_shelf_", wood, blocks_pshelf, SecondCreativeTab.items_pshelf);
                Registration.registerSingleBlockForThirdPartyWood(new BookShelf.Dual("double"), "book_shelf_double_", wood, blocks_bshelf, SecondCreativeTab.items_bshelf1);
                Registration.registerSingleBlockForThirdPartyWood(new BookShelf.Dual("open_double"), "book_shelf_open_double_", wood, blocks_bshelf, SecondCreativeTab.items_bshelf2);
                Registration.registerSingleBlockForThirdPartyWood(new BookShelf.TopSimple("minimal"), "book_shelf_minimal_", wood, blocks_bshelf, SecondCreativeTab.items_bshelf3);
                Registration.registerSingleBlockForThirdPartyWood(new BookShelf.TopSimple("open_minimal"), "book_shelf_open_minimal_", wood, blocks_bshelf, SecondCreativeTab.items_bshelf4);
                Registration.registerSingleBlockForThirdPartyWood(new BookShelf.TopWithLanterns("with_lanterns"), "book_shelf_with_lanterns_", wood, blocks_bshelf, SecondCreativeTab.items_bshelf5);
            }
            ((ForgeRegistry)ForgeRegistries.BLOCKS).freeze();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        RegistryObject rack;
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"workshop_for_handsome_adventurer");
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"workshop_for_handsome_adventurer");
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"workshop_for_handsome_adventurer");
        CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"workshop_for_handsome_adventurer");
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"workshop_for_handsome_adventurer");
        CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"workshop_for_handsome_adventurer");
        blocks_table1 = new ArrayList<Supplier<Block>>();
        blocks_table2 = new ArrayList<Supplier<Block>>();
        blocks_rack = new ArrayList<Supplier<Block>>();
        blocks_pshelf = new ArrayList<Supplier<Block>>();
        blocks_bshelf = new ArrayList<Supplier<Block>>();
        items_table1 = new ArrayList<RegistryObject<Item>>();
        items_table2 = new ArrayList<RegistryObject<Item>>();
        items_rack1 = new ArrayList<RegistryObject<Item>>();
        items_rack2 = new ArrayList<RegistryObject<Item>>();
        items_rack3 = new ArrayList<RegistryObject<Item>>();
        items_rack4 = new ArrayList<RegistryObject<Item>>();
        items_pshelf = new ArrayList<RegistryObject<Item>>();
        items_bshelf1 = new ArrayList<RegistryObject<Item>>();
        items_bshelf2 = new ArrayList<RegistryObject<Item>>();
        items_bshelf3 = new ArrayList<RegistryObject<Item>>();
        items_bshelf4 = new ArrayList<RegistryObject<Item>>();
        items_bshelf5 = new ArrayList<RegistryObject<Item>>();
        woodTypes = new ArrayList<String>(Arrays.asList("oak", "spruce", "jungle", "birch", "dark_oak", "mangrove", "cherry"));
        for (String woodType : woodTypes) {
            RegistryObject block = BLOCKS.register("simple_table_" + woodType, () -> new SimpleTable());
            blocks_table1.add((Supplier<Block>)block);
            items_table1.add(Registration.FromBlock((RegistryObject<Block>)block));
        }
        for (String woodType : woodTypes) {
            RegistryObject primary = BLOCKS.register("dual_table_bottom_left_" + woodType, () -> new AdvancedTableBottomPrimary());
            BLOCKS.register("dual_table_bottom_right_" + woodType, () -> new AdvancedTableBottomSecondary());
            BLOCKS.register("dual_table_top_left_" + woodType, () -> new AdvancedTableTopSecondary());
            BLOCKS.register("dual_table_top_right_" + woodType, () -> new AdvancedTableTopSecondary());
            RegistryObject placer = ITEMS.register("workstation_placer_" + woodType, () -> new WorkstationPlacerItem(woodType));
            items_table2.add((RegistryObject<Item>)placer);
            blocks_table2.add((Supplier<Block>)primary);
            ExternalWoodSupport.registerHostMod(woodType, "workshop_for_handsome_adventurer");
        }
        for (String woodType : woodTypes) {
            rack = BLOCKS.register("tool_rack_single_" + woodType, () -> ToolRack.create(2, "single"));
            items_rack1.add(Registration.FromBlock((RegistryObject<Block>)rack));
            blocks_rack.add((Supplier<Block>)rack);
            rack = BLOCKS.register("tool_rack_framed_" + woodType, () -> DualToolRack.create(6, "framed"));
            items_rack2.add(Registration.FromBlock((RegistryObject<Block>)rack));
            blocks_rack.add((Supplier<Block>)rack);
            rack = BLOCKS.register("tool_rack_pframed_" + woodType, () -> DualToolRack.create(6, "pframed"));
            items_rack3.add(Registration.FromBlock((RegistryObject<Block>)rack));
            blocks_rack.add((Supplier<Block>)rack);
            rack = BLOCKS.register("tool_rack_double_" + woodType, () -> DualToolRack.create(6, "double"));
            items_rack4.add(Registration.FromBlock((RegistryObject<Block>)rack));
            blocks_rack.add((Supplier<Block>)rack);
        }
        for (String woodType : woodTypes) {
            RegistryObject shelf = BLOCKS.register("potion_shelf_" + woodType, () -> new PotionShelf());
            items_pshelf.add(Registration.FromBlock((RegistryObject<Block>)shelf));
            blocks_pshelf.add((Supplier<Block>)shelf);
        }
        for (String woodType : woodTypes) {
            rack = BLOCKS.register("book_shelf_double_" + woodType, () -> new BookShelf.Dual("double"));
            items_bshelf1.add(Registration.FromBlock((RegistryObject<Block>)rack));
            blocks_bshelf.add((Supplier<Block>)rack);
            rack = BLOCKS.register("book_shelf_open_double_" + woodType, () -> new BookShelf.Dual("open_double"));
            items_bshelf2.add(Registration.FromBlock((RegistryObject<Block>)rack));
            blocks_bshelf.add((Supplier<Block>)rack);
            rack = BLOCKS.register("book_shelf_minimal_" + woodType, () -> new BookShelf.TopSimple("minimal"));
            items_bshelf3.add(Registration.FromBlock((RegistryObject<Block>)rack));
            blocks_bshelf.add((Supplier<Block>)rack);
            rack = BLOCKS.register("book_shelf_open_minimal_" + woodType, () -> new BookShelf.TopSimple("open_minimal"));
            items_bshelf4.add(Registration.FromBlock((RegistryObject<Block>)rack));
            blocks_bshelf.add((Supplier<Block>)rack);
            rack = BLOCKS.register("book_shelf_with_lanterns_" + woodType, () -> new BookShelf.TopWithLanterns("with_lanterns"));
            items_bshelf5.add(Registration.FromBlock((RegistryObject<Block>)rack));
            blocks_bshelf.add((Supplier<Block>)rack);
        }
        TOOL_RACK_BE = BLOCK_ENTITIES.register("tool_rack_be", () -> BlockEntityType.Builder.m_155273_(ToolRackBlockEntity::new, (Block[])Registration.ListToArray(blocks_rack)).m_58966_(null));
        SIMPLE_TABLE_BE = BLOCK_ENTITIES.register("simple_table_be", () -> BlockEntityType.Builder.m_155273_(SimpleTableBlockEntity::new, (Block[])Registration.ListToArray(blocks_table1)).m_58966_(null));
        DUAL_TABLE_BE = BLOCK_ENTITIES.register("dual_table_be", () -> BlockEntityType.Builder.m_155273_(DualTableBlockEntity::new, (Block[])Registration.ListToArray(blocks_table2)).m_58966_(null));
        POTION_SHELF_BE = BLOCK_ENTITIES.register("potion_shelf_be", () -> BlockEntityType.Builder.m_155273_(PotionShelfBlockEntity::new, (Block[])Registration.ListToArray(blocks_pshelf)).m_58966_(null));
        BOOK_SHELF_BE = BLOCK_ENTITIES.register("book_shelf_be", () -> BlockEntityType.Builder.m_155273_(BookShelfBlockEntity::new, (Block[])Registration.ListToArray(blocks_bshelf)).m_58966_(null));
        CRAFTING_SINGLE_MENU_TYPE = CONTAINER_TYPES.register("crafting_single", () -> IForgeMenuType.create(SimpleTableMenu::new));
        CRAFTING_DUAL_MENU_TYPE = CONTAINER_TYPES.register("crafting_dual", () -> IForgeMenuType.create(DualTableMenu::new));
        TABLE_RECIPE = RECIPES.register("table_recipe_unknown_planks", () -> new SimpleCraftingRecipeSerializer(UnsupportedWoodRecipe::new));
        CREATIVE_TAB = CREATIVE_TABS.register("tab", CreativeTab::buildTab);
    }
}

