/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources.texture_finder;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.texture_finder.ITextureFinder;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class TextureAutoFinderBackup
implements ITextureFinder {
    private static final Pattern PATTERN_IN_BLOCKSTATE = Pattern.compile("\"(model)\"\\s*:\\s*\"([a-z0-9_]+:)?(.+?)\"");
    private static final Pattern PATTERN_IN_MODEL_ALL = Pattern.compile("\"(all|south)\"\\s*:\\s*\"([a-z0-9_]+:)?(.+?)\"");
    private static final Pattern PATTERN_IN_MODEL_SIDE = Pattern.compile("\"(side|south)\"\\s*:\\s*\"([a-z0-9_]+:)?(.+?)\"");
    private static final Map<String, String> PATH_CACHE = new HashMap<String, String>();

    public static ITextureFinder create() {
        return new TextureAutoFinderBackup();
    }

    @Override
    public String getTexturePathForPlanks(String modId, String wood, String blockNameTemplate) {
        return TextureAutoFinderBackup.getTexturePathInternal(modId, wood, blockNameTemplate, false);
    }

    @Override
    public String getTexturePathForLogs(String modId, String wood, String blockNameTemplate) {
        return TextureAutoFinderBackup.getTexturePathInternal(modId, wood, blockNameTemplate, true);
    }

    private static String getTexturePathInternal(String modId, String wood, String blockTemplate, boolean textureIsSide) {
        String key = "%s:%s/%s".formatted(modId, wood, textureIsSide ? "s" : "a");
        if (PATH_CACHE.containsKey(key)) {
            return PATH_CACHE.get(key);
        }
        try {
            Optional mod1 = ModList.get().getModContainerById(modId);
            if (!mod1.isPresent()) {
                return null;
            }
            InputStream is1 = ((ModContainer)mod1.get()).getMod().getClass().getResourceAsStream("/assets/%s/blockstates/%s.json".formatted(modId, blockTemplate.formatted(wood)));
            BufferedReader br1 = new BufferedReader(new InputStreamReader(is1));
            String file1 = br1.lines().collect(Collectors.joining("\n"));
            Matcher m1 = PATTERN_IN_BLOCKSTATE.matcher(file1);
            m1.find();
            String path1 = m1.group(3);
            InputStream is2 = ((ModContainer)mod1.get()).getMod().getClass().getResourceAsStream("/assets/%s/models/%s.json".formatted(modId, path1));
            BufferedReader br2 = new BufferedReader(new InputStreamReader(is2));
            String file2 = br2.lines().collect(Collectors.joining("\n"));
            Matcher m2 = (textureIsSide ? PATTERN_IN_MODEL_SIDE : PATTERN_IN_MODEL_ALL).matcher(file2);
            m2.find();
            String result = m2.group(3);
            PATH_CACHE.put(key, result);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

