/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources.helpers;

import java.util.List;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.AssetReader;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.DynamicAssetConfig;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeLister;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

public class RecipeWriter {
    private static final String JOIN = "%s:%s";
    private static final String JOIN3 = "%s:%s%s";
    private static final String TEMPLATE_LOG = "%s:stripped_%s_log";
    private static final String[] allRecipes = new String[]{"recipes/book_shelf_double_spruce.json", "recipes/book_shelf_minimal_spruce.json", "recipes/book_shelf_open_double_spruce.json", "recipes/book_shelf_open_minimal_from_double_spruce.json", "recipes/book_shelf_open_minimal_spruce.json", "recipes/book_shelf_with_lanterns_spruce.json", "recipes/potion_shelf_spruce.json", "recipes/simple_table_normal_spruce.json", "recipes/simple_table_replacement_spruce.json", "recipes/tool_rack_double_spruce.json", "recipes/tool_rack_framed_spruce.json", "recipes/tool_rack_pframed_spruce.json", "recipes/tool_rack_single_from_multi_spruce.json", "recipes/tool_rack_single_spruce.json", "recipes/workstation_placer_spruce.json"};
    private static final List<String> conversionRecipes = List.of("recipes/book_shelf_minimal_spruce.json", "recipes/book_shelf_open_double_spruce.json", "recipes/book_shelf_open_minimal_from_double_spruce.json", "recipes/book_shelf_open_minimal_spruce.json", "recipes/book_shelf_with_lanterns_spruce.json", "recipes/tool_rack_double_spruce.json", "recipes/tool_rack_pframed_spruce.json", "recipes/tool_rack_single_from_multi_spruce.json");
    private static final List<String> conversionNames = List.of("book_shelf_double_spruce", "book_shelf_minimal_spruce", "book_shelf_open_double_spruce", "book_shelf_open_minimal_spruce", "tool_rack_double_spruce", "tool_rack_pframed_spruce", "tool_rack_framed_spruce", "tool_rack_single_spruce", "simple_table_spruce");

    public static void writeFiles(Map<ResourceLocation, String> cache) {
        String SPRUCE = "spruce";
        for (String file : allRecipes) {
            StringBuilder newRecipe;
            String original = AssetReader.getInstance(PackType.SERVER_DATA, "workshop_for_handsome_adventurer").getText(new ResourceLocation("workshop_for_handsome_adventurer", file));
            String filePrefix = file.substring("recipe/".length() + 1, file.length() - "spruce.json".length());
            for (String wood : WoodTypeLister.getWoodIds()) {
                newRecipe = new StringBuilder(original);
                RecipeWriter.replace(newRecipe, "minecraft:stripped_spruce_log", RecipeWriter.getStrippedLog(wood));
                RecipeWriter.replace(newRecipe, "minecraft:spruce_slab", RecipeWriter.getSlab(wood));
                RecipeWriter.replace(newRecipe, "minecraft:spruce_planks", RecipeWriter.getPlanks(wood));
                RecipeWriter.replace(newRecipe, filePrefix + "spruce", filePrefix + wood);
                conversionNames.forEach(n -> RecipeWriter.replace(newRecipe, n, n.replace("spruce", wood)));
                cache.put(new ResourceLocation("workshop_for_handsome_adventurer", file.replace("spruce", wood)), newRecipe.toString());
            }
            if (conversionRecipes.contains(file)) continue;
            for (ResourceLocation duplicate : WoodTypeLister.getDuplicateWoods()) {
                newRecipe = new StringBuilder(original);
                RecipeWriter.replace(newRecipe, "minecraft:stripped_spruce", duplicate.m_135827_() + ":stripped_" + duplicate.m_135815_());
                RecipeWriter.replace(newRecipe, "minecraft:spruce", duplicate.toString());
                RecipeWriter.replace(newRecipe, filePrefix + "spruce", filePrefix + duplicate.m_135815_());
                conversionNames.forEach(n -> RecipeWriter.replace(newRecipe, n, n.replace("spruce", duplicate.m_135815_())));
                cache.put(new ResourceLocation("workshop_for_handsome_adventurer", file.replace("spruce", duplicate.m_135815_() + "_" + duplicate.m_135827_())), newRecipe.toString());
            }
        }
    }

    private static void replace(StringBuilder sb, String toFind, String replacement) {
        int pos = sb.indexOf(toFind);
        while (pos != -1) {
            sb.replace(pos, pos + toFind.length(), replacement);
            pos = sb.indexOf(toFind, pos + 1);
        }
    }

    private static String getStrippedLog(String wood) {
        String sub = WoodTypeManager.getLogRecipeSubstitute(wood);
        if (sub != null) {
            return sub;
        }
        DynamicAssetConfig.WoodSet specialSet = DynamicAssetConfig.getWoodSet(wood);
        if (specialSet != null) {
            return JOIN.formatted(specialSet.modId(), specialSet.log());
        }
        return TEMPLATE_LOG.formatted(WoodTypeLister.getHostMod(wood), wood);
    }

    private static String getSlab(String wood) {
        DynamicAssetConfig.WoodSet specialSet = DynamicAssetConfig.getWoodSet(wood);
        if (specialSet != null) {
            return JOIN.formatted(specialSet.modId(), specialSet.slab());
        }
        return JOIN3.formatted(WoodTypeLister.getHostMod(wood), wood, "_slab");
    }

    static String getPlanks(String wood) {
        DynamicAssetConfig.WoodSet specialSet = DynamicAssetConfig.getWoodSet(wood);
        if (specialSet != null) {
            return JOIN.formatted(specialSet.modId(), specialSet.planks());
        }
        return JOIN3.formatted(WoodTypeLister.getHostMod(wood), wood, "_planks");
    }
}

