/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import moonfather.workshop_for_handsome_adventurer.Constants;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.block_entities.BaseContainerBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.integration.PackingTape;
import moonfather.workshop_for_handsome_adventurer.integration.TetraCompatibleToolRackHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class ToolRack
extends Block
implements EntityBlock {
    protected final int itemCount;
    protected MutableComponent Tooltip1;
    protected MutableComponent Tooltip2;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE_PLANK1N = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    private static final VoxelShape SHAPE_PLANK1E = Block.m_49796_((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_PLANK1S = Block.m_49796_((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_PLANK1W = Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);
    protected final Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>(4);
    private final MutableComponent RackMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.invalid_item_for_rack");

    public ToolRack(int itemCount, String type) {
        this(itemCount, "tool_rack", type);
    }

    public ToolRack(int itemCount, String mainType, String subType) {
        this(itemCount, mainType, subType, BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_().m_284180_(MapColor.f_283748_).m_278166_(PushReaction.DESTROY));
    }

    public ToolRack(int itemCount, String mainType, String subType, BlockBehaviour.Properties properties) {
        super(properties);
        this.itemCount = itemCount;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.PrepareListOfShapes();
        String translationKeyStructure = "block.{0}.{1}_{2}.tooltip{3}";
        if (subType == null) {
            translationKeyStructure = "block.{0}.{1}.tooltip{3}";
        }
        String translationKey = MessageFormat.format(translationKeyStructure, "workshop_for_handsome_adventurer", mainType, subType, 1);
        this.Tooltip1 = Component.m_237115_((String)translationKey).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0xAA77DD));
        translationKey = MessageFormat.format(translationKeyStructure, "workshop_for_handsome_adventurer", mainType, subType, 2);
        this.Tooltip2 = Component.m_237115_((String)translationKey).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0xAA77DD));
    }

    public static ToolRack create(int itemCount, String type) {
        if (ModList.get().isLoaded("tetra")) {
            return TetraCompatibleToolRackHelper.create(false, itemCount, type);
        }
        return new ToolRack(itemCount, type);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter p_60579_, BlockPos p_60580_) {
        return this.shapes.get(state.m_61143_((Property)FACING));
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter p_60582_, BlockPos p_60583_) {
        return this.shapes.get(state.m_61143_((Property)FACING));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.shapes.get(state.m_61143_((Property)FACING));
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter p_60548_, BlockPos p_60549_) {
        return this.shapes.get(state.m_61143_((Property)FACING));
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter worldReader, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_5871_(itemStack, worldReader, list, tooltipFlag);
        list.add((Component)this.Tooltip1);
        list.add((Component)this.Tooltip2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43719_() == Direction.DOWN || context.m_43719_() == Direction.UP) {
            return null;
        }
        BlockState result = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_().m_122424_());
        if (this.m_7898_(result, (LevelReader)context.m_43725_(), context.m_8083_())) {
            return result;
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction d = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        BlockPos target = pos.m_121945_(d.m_122424_());
        return world.m_8055_(target).m_60783_((BlockGetter)world, target, d);
    }

    protected void PrepareListOfShapes() {
        this.shapes.put(Direction.NORTH, SHAPE_PLANK1N);
        this.shapes.put(Direction.EAST, SHAPE_PLANK1E);
        this.shapes.put(Direction.SOUTH, SHAPE_PLANK1S);
        this.shapes.put(Direction.WEST, SHAPE_PLANK1W);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        if (!blockState.m_61138_((Property)BlockStateProperties.f_61401_) || blockState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
            return ((BlockEntityType)Registration.TOOL_RACK_BE.get()).m_155264_(pos, blockState);
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_153212_, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return null;
    }

    public void m_6861_(BlockState state, Level level, BlockPos rackPos, Block block, BlockPos wallPos, boolean something) {
        super.m_6861_(state, level, rackPos, block, wallPos, something);
        if (!this.m_7898_(state, (LevelReader)level, rackPos)) {
            level.m_46961_(rackPos, true);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity be = worldIn.m_7702_(pos);
            if (be instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity rack = (BaseContainerBlockEntity)be;
                rack.DropAll();
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (blockState.m_61138_((Property)BlockStateProperties.f_61401_) && blockState.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
            BlockPos above = pos.m_7494_();
            return this.m_6227_(level.m_8055_(above), level, above, player, hand, blockHitResult.m_82430_(above));
        }
        boolean doOffhand = (Boolean)OptionsHolder.COMMON.OffhandInteractsWithToolRack.get();
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int slot = this.getTargetedSlot(blockHitResult);
        if (slot >= this.itemCount) {
            slot -= this.itemCount;
        }
        ToolRackBlockEntity BE = (ToolRackBlockEntity)level.m_7702_(pos);
        ItemStack existing = BE.GetItem(slot);
        ItemStack itemInMainHand = player.m_21205_();
        ItemStack itemInOffHand = player.m_21206_();
        if (existing.m_41619_() && !itemInMainHand.m_41619_()) {
            if (!this.canDepositItem(itemInMainHand)) {
                player.m_5661_((Component)this.RackMessage, true);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            ItemStack toStore = itemInMainHand.m_41777_();
            toStore.m_41764_(1);
            BE.DepositItem(slot, toStore);
            itemInMainHand.m_41774_(1);
            player.m_5496_(SoundEvents.f_12635_, 0.5f, 0.7f);
        } else if (!existing.m_41619_() || !itemInMainHand.m_41619_() || doOffhand && !itemInOffHand.m_41619_()) {
            if (existing.m_41619_() && itemInMainHand.m_41619_() && doOffhand && !itemInOffHand.m_41619_()) {
                if (!this.canDepositItem(itemInOffHand)) {
                    player.m_5661_((Component)this.RackMessage, true);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                ItemStack toStore = itemInOffHand.m_41777_();
                toStore.m_41764_(1);
                BE.DepositItem(slot, toStore);
                itemInOffHand.m_41774_(1);
                player.m_5496_(SoundEvents.f_12635_, 0.5f, 0.7f);
            } else if (!existing.m_41619_() && itemInMainHand.m_41619_() && itemInOffHand.m_41619_() && existing.canPerformAction(ToolActions.SHIELD_BLOCK)) {
                player.m_21008_(InteractionHand.OFF_HAND, existing);
                BE.ClearItem(slot);
                player.m_5496_(SoundEvents.f_12019_, 0.5f, 1.0f);
            } else if (!existing.m_41619_() && itemInMainHand.m_41619_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, existing);
                BE.ClearItem(slot);
                player.m_5496_(SoundEvents.f_12019_, 0.5f, 1.0f);
            } else if (!existing.m_41619_() && !itemInMainHand.m_41619_() && doOffhand && itemInOffHand.m_41619_()) {
                if (!itemInMainHand.canPerformAction(ToolActions.SHIELD_BLOCK)) {
                    player.m_21008_(InteractionHand.OFF_HAND, existing);
                } else {
                    player.m_21008_(InteractionHand.OFF_HAND, itemInMainHand);
                    player.m_21008_(InteractionHand.MAIN_HAND, existing);
                }
                BE.ClearItem(slot);
                player.m_5496_(SoundEvents.f_12019_, 0.5f, 1.0f);
            }
        }
        level.m_7260_(pos, blockState, blockState, 2);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static int getToolRackSlot(ToolRack block, BlockHitResult blockHitResult) {
        return block.getTargetedSlot(blockHitResult);
    }

    protected int getTargetedSlot(BlockHitResult blockHitResult) {
        int aboveThisRow = 0;
        double frac = blockHitResult.m_82450_().f_82480_ - (double)blockHitResult.m_82425_().m_123342_();
        if (frac >= 0.3125) {
            aboveThisRow = 0;
        }
        if (frac < 0.3125 && frac >= -0.3125) {
            aboveThisRow = 2;
        }
        if (frac < -0.3125 && frac >= -0.9375) {
            aboveThisRow = 4;
        }
        int integral = (int)blockHitResult.m_82450_().f_82481_;
        frac = (blockHitResult.m_82450_().f_82481_ - (double)integral) * (double)blockHitResult.m_82434_().m_122429_();
        integral = (int)blockHitResult.m_82450_().f_82479_;
        boolean left = (frac -= (blockHitResult.m_82450_().f_82479_ - (double)integral) * (double)blockHitResult.m_82434_().m_122431_()) >= -0.5 && frac < 0.0 || frac >= 0.5;
        return aboveThisRow + (left ? 0 : 1);
    }

    protected boolean canDepositItem(ItemStack mainHandItem) {
        if (mainHandItem == null || mainHandItem.m_41619_()) {
            return true;
        }
        if (mainHandItem.m_41741_() > 1 && !mainHandItem.m_41720_().equals(Items.f_42655_) && !PackingTape.isTape(mainHandItem)) {
            return false;
        }
        if (mainHandItem.m_41720_() instanceof BlockItem || mainHandItem.m_41720_() instanceof ArmorItem || mainHandItem.m_41720_() instanceof HorseArmorItem) {
            return false;
        }
        if (mainHandItem.m_41720_().m_41473_() != null || mainHandItem.m_41720_() instanceof BucketItem || mainHandItem.m_41720_() instanceof MinecartItem || mainHandItem.m_41720_() instanceof BoatItem) {
            return false;
        }
        if (mainHandItem.m_41783_() != null && mainHandItem.m_41783_().m_128441_("Potion")) {
            return false;
        }
        return !mainHandItem.m_204117_(Constants.Tags.NOT_ALLOWED_ON_TOOLRACK) && !mainHandItem.m_204117_(ItemTags.f_244646_);
    }
}

