/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.renderers.ToolRackTESR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class SimpleTableTESR
implements BlockEntityRenderer<SimpleTableBlockEntity> {
    private static final Quaternionf XPlus90 = new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, 90.0f);
    private static final Quaternionf ZPlus180 = new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 180.0f);
    private static final Map<Integer, Quaternionf> YRotCache = new HashMap<Integer, Quaternionf>();
    private boolean shouldRender = true;

    public SimpleTableTESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(SimpleTableBlockEntity table, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        Direction direction = null;
        double playerDX = (double)table.m_58899_().m_123341_() + 0.5 - Minecraft.m_91087_().f_91074_.m_20182_().f_82479_;
        double playerDZ = (double)table.m_58899_().m_123343_() + 0.5 - Minecraft.m_91087_().f_91074_.m_20182_().f_82481_;
        direction = Math.abs(playerDZ) > 1.0E-4 && Math.abs(Math.abs(playerDX / playerDZ) - 1.0) < 0.2 || table.m_58899_().m_123341_() == Minecraft.m_91087_().f_91074_.m_20183_().m_123341_() && table.m_58899_().m_123343_() == Minecraft.m_91087_().f_91074_.m_20183_().m_123343_() ? Direction.m_122364_((double)(Minecraft.m_91087_().f_91074_.f_20885_ + 180.0f)) : Direction.m_122366_((double)(-1.0 * playerDX), (double)0.0, (double)(-1.0 * playerDZ));
        SimpleTableTESR.render3x3(poseStack, direction, bufferSource, combinedLight, combinedOverlay, table, 0, false, false);
    }

    public static void render3x3(PoseStack poseStack, Direction direction, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, SimpleTableBlockEntity table, int tableInventoryOffset, boolean unused, boolean secondary) {
        for (int j = 0; j < 9; ++j) {
            ItemStack itemstack = ToolRackTESR.RemoveEnchantments(table.GetItem(tableInventoryOffset + j));
            if (itemstack == ItemStack.f_41583_) continue;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 1.01f, 0.0f);
            int tableOffsetX = secondary ? direction.m_122429_() : 0;
            int tableOffsetZ = secondary ? direction.m_122431_() : 0;
            poseStack.m_85837_(0.5 + (double)tableOffsetZ, 0.0, 0.5 - (double)tableOffsetX);
            poseStack.m_252781_(SimpleTableTESR.getYRotation(direction, direction.m_122431_() == 0));
            double positionScale = 0.63f;
            poseStack.m_85837_((double)(j % 3) * 0.3 * positionScale, 0.0, (double)(j / 3) * 0.3 * positionScale);
            poseStack.m_85837_(-0.19, 0.0, -0.19);
            poseStack.m_252781_(XPlus90);
            poseStack.m_252781_(ZPlus180);
            float itemScale = 0.15f;
            poseStack.m_85841_(itemScale, itemScale, itemScale / 3.0f);
            Minecraft.m_91087_().m_91291_().m_269128_(itemstack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, poseStack, bufferSource, null, j);
            poseStack.m_85849_();
        }
    }

    private static Quaternionf getYRotation(Direction directionToPlayer, boolean invert) {
        int one = invert ? -1 : 1;
        int y = (int)directionToPlayer.m_122435_() * one;
        Quaternionf result = YRotCache.getOrDefault(y, null);
        if (result == null) {
            result = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, (float)y);
            YRotCache.put(y, result);
        }
        return result;
    }

    public boolean shouldRender(SimpleTableBlockEntity blockEntity, Vec3 location) {
        if (blockEntity.m_58898_() && blockEntity.m_58904_().m_6106_().m_6793_() % 40L == 7L) {
            this.shouldRender = (Boolean)OptionsHolder.CLIENT.RenderItemsOnTable.get();
        }
        return this.shouldRender;
    }
}

