/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import org.joml.Quaternionf;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ToolRackTESR
implements BlockEntityRenderer<ToolRackBlockEntity> {
    private ItemRenderer itemRenderer = null;
    private final BlockEntityRendererProvider.Context context;
    private final TagKey<Item> itemsThatWeShouldntRotate = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("workshop_for_handsome_adventurer", "dont_rotate_on_toolrack"));

    public ToolRackTESR(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
    }

    public void render(ToolRackBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction direction = ((Direction)tile.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        Direction itemDirection = direction.m_122428_();
        int itemsPerRow = tile.getNumberOfItemsInOneRow();
        if (itemsPerRow == 3) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5 - (double)direction.m_122429_() * 0.42, 0.7, 0.5 - (double)direction.m_122431_() * 0.42);
            matrixStack.m_85841_(0.3f, 0.4f, 0.3f);
            int rowHeight = 15;
            for (int row = 0; row < 3; ++row) {
                for (int i = 0; i < itemsPerRow && tile.getCapacity() > row * itemsPerRow; ++i) {
                    ItemStack itemStack = this.RemoveEnchantments(tile.GetItem(row * itemsPerRow + i));
                    if (itemStack.m_41619_()) continue;
                    matrixStack.m_85836_();
                    double antiZFighting = (double)row * 0.003 + (double)i * 0.001;
                    matrixStack.m_85837_((double)itemDirection.m_122429_() * ((double)i - 1.0) + antiZFighting, (double)(0.0f - (float)row * ((float)rowHeight / 16.0f + 0.1875f) - 0.125f), (double)itemDirection.m_122431_() * ((double)i - 1.0) + antiZFighting);
                    matrixStack.m_252781_(direction.m_253075_());
                    this.renderItemStack(tile, itemStack, matrixStack, buffer, combinedLight, combinedOverlay);
                    matrixStack.m_85849_();
                }
            }
            matrixStack.m_85849_();
        } else {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5 - (double)direction.m_122429_() * 0.42, 0.7, 0.5 - (double)direction.m_122431_() * 0.42);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            int rowHeight = tile.getCapacity() % 4 == 0 ? 15 : 20;
            for (int row = 0; row < 3; ++row) {
                for (int i = 0; i < itemsPerRow && tile.getCapacity() > row * itemsPerRow; ++i) {
                    ItemStack itemStack = this.RemoveEnchantments(tile.GetItem(row * itemsPerRow + i));
                    if (itemStack.m_41619_()) continue;
                    matrixStack.m_85836_();
                    double antiZFighting = (double)row * 0.003 + (double)i * 0.001;
                    matrixStack.m_85837_((double)itemDirection.m_122429_() * ((double)i - 0.5) + antiZFighting, (double)(0.0f - (float)row * ((float)rowHeight / 16.0f)), (double)itemDirection.m_122431_() * ((double)i - 0.5) + antiZFighting);
                    matrixStack.m_252781_(direction.m_253075_());
                    this.renderItemStack(tile, itemStack, matrixStack, buffer, combinedLight, combinedOverlay);
                    matrixStack.m_85849_();
                }
            }
            matrixStack.m_85849_();
        }
    }

    private void renderItemStack(ToolRackBlockEntity tile, ItemStack itemStack, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (itemStack != null && !itemStack.m_41619_()) {
            int renderId = (int)tile.m_58899_().m_121878_();
            if (this.itemRenderer == null) {
                this.itemRenderer = Minecraft.m_91087_().m_91291_();
            }
            BakedModel model = this.itemRenderer.m_174264_(itemStack, tile.m_58904_(), null, combinedLight);
            matrixStack.m_252781_(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, -90.0f));
            matrixStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, 180.0f));
            if (itemStack.m_41720_().canPerformAction(itemStack, ToolActions.SHIELD_BLOCK)) {
                matrixStack.m_85837_(-0.0, -0.1, 0.14);
                matrixStack.m_85841_(1.75f, 1.6f, 1.75f);
            } else if (itemStack.m_41720_().canPerformAction(itemStack, ToolActions.SWORD_SWEEP) || itemStack.m_41720_() instanceof SwordItem) {
                matrixStack.m_85837_(0.0, -0.2, 0.0);
                matrixStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 135.0f));
            } else if (itemStack.m_41720_().getClass().getSimpleName().contains("rossbow") || itemStack.m_41720_() instanceof CrossbowItem) {
                matrixStack.m_85837_(0.0, -0.2, 0.0);
                matrixStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, 225.0f));
            } else if (model.m_7539_()) {
                matrixStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, -45.0f));
            } else if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("Potion") || itemStack.m_150930_(Items.f_42590_)) {
                matrixStack.m_85837_(0.0, 0.1, 0.0);
            } else if (itemStack.m_204117_(this.itemsThatWeShouldntRotate)) {
                matrixStack.m_85837_(0.0, 0.1, 0.0);
            } else {
                matrixStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 0.0f, 1.0f, -45.0f));
            }
            Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.FIXED, combinedLight, combinedOverlay, matrixStack, buffer, tile.m_58904_(), renderId);
        }
    }

    private ItemStack RemoveEnchantments(ItemStack stored) {
        ItemStack result = stored.m_41777_();
        if (!result.m_41782_()) {
            return result;
        }
        if (result.m_41783_().m_128441_("Enchantments")) {
            result.m_41783_().m_128473_("Enchantments");
        }
        return result;
    }
}

