/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.util;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public final class ToolUtil {
    public static void applyToolWear(ByteBuddyEntity byteBuddy, ToolType toolType, float wearMultiplier) {
        if (toolType == ToolType.EMPTY_HAND) {
            return;
        }
        int slot = byteBuddy.getHeldToolSlot();
        if (slot < 0) {
            return;
        }
        ItemStack toolStack = byteBuddy.getHeldTool();
        if (!toolStack.m_41763_()) {
            return;
        }
        boolean baseWear = true;
        int damageValue = Math.max(1, Math.round((float)baseWear * wearMultiplier));
        ItemStack heldTool = byteBuddy.getHeldTool();
        if (!heldTool.m_41619_() && heldTool.m_41763_()) {
            heldTool.m_41622_(damageValue, (LivingEntity)byteBuddy, entity -> entity.m_21190_(InteractionHand.MAIN_HAND));
            byteBuddy.getMainInv().setStackInSlot(slot, heldTool);
        }
    }

    public static boolean matchesToolType(ItemStack toolStack, ToolType toolType) {
        Item toolItem = toolStack.m_41720_();
        return switch (toolType) {
            default -> throw new IncompatibleClassChangeError();
            case ToolType.HOE -> toolItem instanceof HoeItem;
            case ToolType.AXE -> toolItem instanceof AxeItem;
            case ToolType.PICKAXE -> toolItem instanceof PickaxeItem;
            case ToolType.SHOVEL -> toolItem instanceof ShovelItem;
            case ToolType.SHEARS -> toolItem instanceof ShearsItem;
            case ToolType.SWORD -> toolItem instanceof SwordItem;
            case ToolType.BOW -> toolItem instanceof BowItem;
            case ToolType.CROSSBOW -> toolItem instanceof CrossbowItem;
            case ToolType.EMPTY_HAND -> false;
        };
    }

    public static enum ToolType {
        HOE,
        AXE,
        PICKAXE,
        SHOVEL,
        SHEARS,
        SWORD,
        BOW,
        CROSSBOW,
        EMPTY_HAND;

    }
}

