/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.util;

import java.util.Set;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.ItemStackHandler;
import net.turtleboi.bytebuddies.block.custom.DockingStationBlock;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.util.BotDebug;
import net.turtleboi.bytebuddies.util.ToolUtil;

public class GoalUtil {
    private static final Set<Block> TILLABLE = Set.of(Blocks.f_50493_, Blocks.f_50440_, Blocks.f_50546_);

    public static void lockToAnchor(ByteBuddyEntity byteBuddy, Vec3 targetAnchor) {
        if (targetAnchor == null) {
            return;
        }
        byteBuddy.m_21573_().m_26573_();
        AABB bb = byteBuddy.m_20191_();
        Vec3 move = targetAnchor.m_82546_(byteBuddy.m_20182_());
        AABB movedBB = bb.m_82383_(move);
        if (!byteBuddy.m_9236_().m_45772_(movedBB)) {
            AABB upBB = movedBB.m_82386_(0.0, 0.0625, 0.0);
            if (!byteBuddy.m_9236_().m_45772_(upBB)) {
                return;
            }
            targetAnchor = targetAnchor.m_82520_(0.0, 0.0625, 0.0);
        }
        byteBuddy.m_6034_(targetAnchor.f_82479_, targetAnchor.f_82480_, targetAnchor.f_82481_);
        byteBuddy.m_20334_(0.0, 0.0, 0.0);
        byteBuddy.m_183634_();
    }

    public static boolean actionReady(ServerLevel serverLevel, long nextActionTick) {
        return serverLevel.m_46467_() >= nextActionTick;
    }

    public static double hDistSq(Vec3 posA, Vec3 posB) {
        double dx = posA.f_82479_ - posB.f_82479_;
        double dz = posA.f_82481_ - posB.f_82481_;
        return dx * dx + dz * dz;
    }

    public static int toTicks(double seconds) {
        return (int)Math.round(seconds * 20.0);
    }

    @Nullable
    public static Vec3 getEdgeAnchor(BlockPos blockPos, BlockPos standingPos) {
        if (blockPos == null || standingPos == null) {
            return null;
        }
        Vec3 centerPos = blockPos.m_252807_();
        Vec3 standingCenterPos = standingPos.m_252807_();
        Vec3 subtracted = standingCenterPos.m_82546_(centerPos);
        if (subtracted.m_82556_() < 1.0E-6) {
            subtracted = new Vec3(1.0, 0.0, 0.0);
        }
        subtracted = subtracted.m_82541_();
        double inset = 0.55;
        return new Vec3(centerPos.f_82479_ + subtracted.f_82479_ * inset, (double)standingPos.m_123342_(), centerPos.f_82481_ + subtracted.f_82481_ * inset);
    }

    @Nullable
    public static DockingStationBlockEntity dockBlockEntity(ByteBuddyEntity byteBuddy) {
        return byteBuddy.getDock().map(blockPos -> byteBuddy.m_9236_().m_7702_(blockPos)).filter(blockEntity -> blockEntity instanceof DockingStationBlockEntity).orElse(null);
    }

    public static Direction backOfDock(DockingStationBlockEntity be) {
        BlockState state = be.m_58900_();
        Direction front = DockingStationBlock.getHorizontalFacing(state);
        return front.m_122424_();
    }

    public static void renewClaimIfNeeded(ByteBuddyEntity byteBuddy, ServerLevel serverLevel, ByteBuddyEntity.TaskType taskType, @Nullable BlockPos claimedPos, @Nullable BlockPos currentPos, long currentTime, int renewPeriod, int timeOutTicks, LongSupplier nextRenewGetter, LongConsumer nextRenewSetter) {
        if (currentPos == null || !currentPos.equals((Object)claimedPos)) {
            return;
        }
        if (currentTime < nextRenewGetter.getAsLong()) {
            return;
        }
        DockingStationBlockEntity dockBlock = GoalUtil.dockBlockEntity(byteBuddy);
        if (dockBlock == null) {
            return;
        }
        dockBlock.renewClaim(serverLevel, taskType, claimedPos, byteBuddy.m_20148_(), timeOutTicks);
        nextRenewSetter.accept(currentTime + (long)renewPeriod);
    }

    public static boolean isStandableTerrain(Level level, BlockPos blockPos) {
        if (!level.m_46749_(blockPos)) {
            return false;
        }
        BlockState below = level.m_8055_(blockPos.m_7495_());
        boolean solidFloor = !below.m_60812_((BlockGetter)level, blockPos.m_7495_()).m_83281_();
        BlockState feet = level.m_8055_(blockPos);
        boolean feetFree = feet.m_60812_((BlockGetter)level, blockPos).m_83281_();
        BlockState head = level.m_8055_(blockPos.m_7494_());
        boolean headFree = head.m_60812_((BlockGetter)level, blockPos.m_7494_()).m_83281_();
        boolean noLiquid = level.m_6425_(blockPos).m_76178_() && level.m_6425_(blockPos.m_7494_()).m_76178_();
        return solidFloor && feetFree && headFree && noLiquid;
    }

    public static boolean isStandableForMove(ByteBuddyEntity byteBuddy, Level level, BlockPos blockPos) {
        if (!GoalUtil.isStandableTerrain(level, blockPos)) {
            return false;
        }
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos dockPos = byteBuddy.getDock().orElse(null);
        if (dockPos == null) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(dockPos);
        if (!(blockEntity instanceof DockingStationBlockEntity)) {
            return true;
        }
        DockingStationBlockEntity dockBlock = (DockingStationBlockEntity)blockEntity;
        boolean reserved = dockBlock.isReserved(serverLevel, ByteBuddyEntity.TaskType.MOVE, blockPos);
        if (!reserved) {
            return true;
        }
        return dockBlock.isReservedBy(serverLevel, ByteBuddyEntity.TaskType.MOVE, blockPos, byteBuddy.m_20148_());
    }

    public static boolean isAirOrReplaceableAbove(Level level, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        return level.m_8055_(above).m_60812_((BlockGetter)level, above).m_83281_() && level.m_6425_(above).m_76178_();
    }

    public static boolean isPlantable(BlockState blockState) {
        return blockState.m_60734_() instanceof BushBlock || blockState.m_60734_() instanceof CropBlock || blockState.m_204336_(BlockTags.f_13073_);
    }

    public static boolean canPlantAt(Level level, BlockPos blockPos, BlockState plantState) {
        if (blockPos == null) {
            return false;
        }
        if (!level.m_46749_(blockPos)) {
            return false;
        }
        BlockState plantCandidate = level.m_8055_(blockPos);
        if (GoalUtil.isPlantable(plantCandidate)) {
            return false;
        }
        if (!plantCandidate.m_60795_() && !plantCandidate.m_247087_()) {
            return false;
        }
        if (!level.m_6425_(blockPos).m_76178_()) {
            return false;
        }
        BlockPos soilPos = blockPos.m_7495_();
        BlockState soilState = level.m_8055_(soilPos);
        Block block = plantState.m_60734_();
        if (!(block instanceof IPlantable)) {
            return false;
        }
        IPlantable plantable = (IPlantable)block;
        if (!soilState.canSustainPlant((BlockGetter)level, soilPos, Direction.UP, plantable)) {
            return false;
        }
        return plantState.m_60710_((LevelReader)level, blockPos);
    }

    public static boolean canTillAt(Level level, @Nullable BlockPos blockPos) {
        if (level == null || blockPos == null) {
            return false;
        }
        if (!level.m_46749_(blockPos)) {
            return false;
        }
        if (!level.m_46739_(blockPos)) {
            return false;
        }
        BlockState soilCandidate = level.m_8055_(blockPos);
        if (soilCandidate.m_60713_(Blocks.f_50093_)) {
            return false;
        }
        if (!TILLABLE.contains(soilCandidate.m_60734_())) {
            return false;
        }
        BlockPos aboveSoil = blockPos.m_7494_();
        if (!level.m_46749_(aboveSoil)) {
            return false;
        }
        BlockState aboveSoilState = level.m_8055_(aboveSoil);
        return (aboveSoilState.m_60795_() || aboveSoilState.m_247087_()) && level.m_6425_(aboveSoil).m_76178_();
    }

    public static boolean canMineAt(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        if (level.m_7702_(pos) instanceof DockingStationBlockEntity) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (state.m_60713_(Blocks.f_50752_)) {
            return false;
        }
        return !(state.m_60800_((BlockGetter)level, pos) < 0.0f);
    }

    public static long getCurrentTime(LivingEntity livingEntity) {
        long l;
        Level level = livingEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            l = serverLevel.m_46467_();
        } else {
            l = 0L;
        }
        return l;
    }

    public static void reserveCurrentPathIfAny(ServerLevel serverLevel, ByteBuddyEntity byteBuddy, int lookAhead) {
        Path path = byteBuddy.m_21573_().m_26570_();
        if (path != null) {
            ByteBuddyEntity.reservePathAhead(byteBuddy, serverLevel, path, lookAhead);
        }
    }

    public static void releaseCurrentPathIfAny(ByteBuddyEntity byteBuddy) {
        Path path = byteBuddy.m_21573_().m_26570_();
        if (path != null) {
            byteBuddy.releasePath(path);
        }
    }

    public static boolean hasRequiredTool(ByteBuddyEntity byteBuddy, ToolUtil.ToolType toolType) {
        boolean hasRequiredTool;
        if (toolType == ToolUtil.ToolType.EMPTY_HAND) {
            return true;
        }
        ItemStackHandler buddyInventory = byteBuddy.getMainInv();
        int heldToolSlot = byteBuddy.getHeldToolSlot();
        ItemStack toolStack = heldToolSlot >= 0 && heldToolSlot < buddyInventory.getSlots() ? buddyInventory.getStackInSlot(heldToolSlot) : ItemStack.f_41583_;
        boolean bl = hasRequiredTool = !toolStack.m_41619_() && ToolUtil.matchesToolType(toolStack, toolType);
        if (!hasRequiredTool) {
            BotDebug.log(byteBuddy, "CHECK failed: required tool=" + toolType + " heldSlot=" + heldToolSlot + " stack=" + (toolStack.m_41619_() ? "EMPTY" : toolStack.m_41720_().toString()));
        }
        return hasRequiredTool;
    }

    public static boolean hasEnergyForUnit(ByteBuddyEntity byteBuddy, int energyPerUnit) {
        boolean hasEnergyForUnit;
        if (energyPerUnit <= 0) {
            return true;
        }
        int energyStored = byteBuddy.getEnergyStorage().getEnergyStored();
        boolean bl = hasEnergyForUnit = energyStored >= energyPerUnit;
        if (!hasEnergyForUnit) {
            BotDebug.log(byteBuddy, "CHECK failed: energy per unit=" + energyPerUnit + " energyStored=" + energyStored);
        }
        return hasEnergyForUnit;
    }

    public static boolean hasEnergyForMax(ByteBuddyEntity byteBuddy, int energyPerUnit, int maxUnits) {
        boolean hasEnergyForMax;
        long neededEnergyLong = (long)Math.max(0, energyPerUnit) * (long)Math.max(1, maxUnits);
        int neededEnergy = neededEnergyLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)neededEnergyLong;
        int energyStored = byteBuddy.getEnergyStorage().getEnergyStored();
        boolean bl = hasEnergyForMax = energyStored >= neededEnergy;
        if (!hasEnergyForMax) {
            BotDebug.log(byteBuddy, "CHECK failed: energy max batch need=" + neededEnergy + " energyStored=" + energyStored + " unit=" + energyPerUnit + " maxUnits=" + maxUnits);
        }
        return hasEnergyForMax;
    }

    public static boolean ensureUse(ByteBuddyEntity byteBuddy, @Nullable ToolUtil.ToolType requiredTool, int energyPerUnit, int maxUnits) {
        if (requiredTool != null && !GoalUtil.hasRequiredTool(byteBuddy, requiredTool)) {
            BotDebug.log(byteBuddy, "PRECONDITION: missing required tool for goal start");
            return false;
        }
        if (!GoalUtil.hasEnergyForMax(byteBuddy, energyPerUnit, maxUnits)) {
            BotDebug.log(byteBuddy, "PRECONDITION: insufficient energy to complete max batch");
            return false;
        }
        return true;
    }
}

