/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.util;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.turtleboi.bytebuddies.ByteBuddies;
import net.turtleboi.bytebuddies.block.custom.BluestoneOreBlock;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;

public final class BotDebug {
    public static boolean ENABLED = false;
    public static boolean NAMEPLATE = false;
    public static boolean ACTIONBAR = false;
    public static boolean PARTICLES = true;

    public static void log(ByteBuddyEntity byteBuddy, String logMessage) {
        if (ENABLED) {
            Level level;
            ByteBuddies.LOGGER.debug("[ByteBuddy:{}@{}] {}", new Object[]{byteBuddy.m_19879_(), byteBuddy.m_20183_(), logMessage});
            if (NAMEPLATE) {
                byteBuddy.m_6593_((Component)Component.m_237113_((String)BotDebug.shorten(logMessage, 32)));
                byteBuddy.m_20340_(true);
            }
            if (ACTIONBAR && (level = byteBuddy.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BotDebug.nearestPlayer(serverLevel, byteBuddy).ifPresent(player -> player.m_5661_((Component)Component.m_237113_((String)logMessage), true));
            }
        }
    }

    public static void mark(Level level, BlockPos blockPos) {
        if (PARTICLES && !level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 12; ++i) {
                double particleInterval = Math.PI * 2 * (double)i / 12.0;
                serverLevel.m_8767_((ParticleOptions)BluestoneOreBlock.BLUESTONE, (double)blockPos.m_123341_() + 0.5 + Math.cos(particleInterval) * 0.5, (double)blockPos.m_123342_() + 0.1, (double)blockPos.m_123343_() + 0.5 + Math.sin(particleInterval) * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static Optional<Player> nearestPlayer(ServerLevel serverLevel, ByteBuddyEntity byteBuddy) {
        List list = serverLevel.m_45976_(Player.class, new AABB(byteBuddy.m_20183_()).m_82400_(16.0));
        if (!list.isEmpty()) {
            list.sort(Comparator.comparingDouble(a -> a.m_20280_((Entity)byteBuddy)));
            return Optional.of((Player)list.get(0));
        }
        return Optional.empty();
    }

    private static String shorten(String string, int letters) {
        return string.length() <= letters ? string : string.substring(0, letters);
    }

    public static enum FailReason {
        NONE,
        WRONG_ROLE,
        NO_DOCK,
        NO_TARGET,
        OUT_OF_ENERGY,
        NOT_CROP,
        PATH_FAIL,
        INVENTORY_FULL;

    }

    public static enum GoalPhase {
        IDLE,
        SEEKING,
        MOVING,
        ACTING,
        COOLDOWN;

    }
}

