/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom.menu;

import com.mojang.datafixers.util.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.turtleboi.bytebuddies.block.entity.GeneratorBlockEntity;
import net.turtleboi.bytebuddies.screen.ModMenuTypes;
import org.jetbrains.annotations.NotNull;

public class GeneratorMenu
extends AbstractContainerMenu {
    public final GeneratorBlockEntity generatorBlockEntity;
    public final Level level;
    private int clientProgress;
    private int clientMaxProgress;
    private int clientEnergy;
    private int clientMaxEnergy;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 1;
    private static final int SLOT_SIZE = 18;

    public GeneratorMenu(int containerId, Inventory playerInv, BlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.GENERATOR_MENU.get(), containerId);
        this.generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
        this.level = playerInv.f_35978_.m_9236_();
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.addFuelSlot();
        this.addBatterySlot();
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return GeneratorMenu.this.generatorBlockEntity.getProgress();
            }

            public void m_6422_(int value) {
                GeneratorMenu.this.clientProgress = value;
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return GeneratorMenu.this.generatorBlockEntity.getMaxProgress();
            }

            public void m_6422_(int value) {
                GeneratorMenu.this.clientMaxProgress = value;
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return GeneratorMenu.this.generatorBlockEntity.getEnergyStorage().getEnergyStored();
            }

            public void m_6422_(int value) {
                GeneratorMenu.this.clientEnergy = value;
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return GeneratorMenu.this.generatorBlockEntity.getEnergyStorage().getMaxEnergyStored();
            }

            public void m_6422_(int value) {
                GeneratorMenu.this.clientMaxEnergy = value;
            }
        });
    }

    public static GeneratorMenu clientFactory(int containerId, Inventory inventory, FriendlyByteBuf byteBuf) {
        return new GeneratorMenu(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(byteBuf.m_130135_()));
    }

    public BlockEntity getSolarPanel() {
        return this.generatorBlockEntity;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 37, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 37) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.generatorBlockEntity != null && player.m_20275_((double)this.generatorBlockEntity.m_58899_().m_123341_() + 0.5, (double)this.generatorBlockEntity.m_58899_().m_123342_() + 0.5, (double)this.generatorBlockEntity.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int startX = 8;
        int startY = 106;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int startX = 8;
        int startY = 164;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, startX + i * 18, startY));
        }
    }

    private void addFuelSlot() {
        if (this.generatorBlockEntity == null) {
            return;
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.generatorBlockEntity.getFuelSlot(), 0, 90, 42){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_fuel"));
            }
        });
    }

    private void addBatterySlot() {
        if (this.generatorBlockEntity == null) {
            return;
        }
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.generatorBlockEntity.getBatterySlot(), 0, 40, 62){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_battery"));
            }
        });
    }

    public int getProgress() {
        return this.clientProgress;
    }

    public int getMaxProgress() {
        return this.clientMaxProgress;
    }

    public int getEnergyStored() {
        return this.clientEnergy;
    }

    public int getMaxEnergyStored() {
        return this.clientMaxEnergy;
    }
}

