/*
 * Decompiled with CFR 0.152.
 */
package net.turtleboi.bytebuddies.screen.custom.menu;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.turtleboi.bytebuddies.block.entity.DockingStationBlockEntity;
import net.turtleboi.bytebuddies.entity.entities.ByteBuddyEntity;
import net.turtleboi.bytebuddies.screen.ModMenuTypes;
import org.jetbrains.annotations.NotNull;

public class DockingStationMenu
extends AbstractContainerMenu {
    public final DockingStationBlockEntity dockBlock;
    public final Level level;
    private final IntList buddyEntityIds = new IntArrayList();
    private int clientEnergy;
    private int clientMaxEnergy;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 29;
    private static final int SLOT_SIZE = 18;

    public DockingStationMenu(int containerId, Inventory playerInv, BlockEntity blockEntity) {
        super((MenuType)ModMenuTypes.DOCKING_STATION_MENU.get(), containerId);
        this.dockBlock = (DockingStationBlockEntity)blockEntity;
        this.level = playerInv.f_35978_.m_9236_();
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.addStationInventory();
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return DockingStationMenu.this.dockBlock.getEnergyStorage().getEnergyStored();
            }

            public void m_6422_(int value) {
                DockingStationMenu.this.clientEnergy = value;
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return DockingStationMenu.this.dockBlock.getEnergyStorage().getMaxEnergyStored();
            }

            public void m_6422_(int value) {
                DockingStationMenu.this.clientMaxEnergy = value;
            }
        });
    }

    public static DockingStationMenu clientFactory(int containerId, Inventory inventory, FriendlyByteBuf byteBuf) {
        DockingStationMenu dockingStationMenu = new DockingStationMenu(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(byteBuf.m_130135_()));
        int idCount = byteBuf.m_130242_();
        for (int i = 0; i < idCount; ++i) {
            dockingStationMenu.getBuddyEntityIds().add(byteBuf.m_130242_());
        }
        return dockingStationMenu;
    }

    public BlockEntity getDockingStation() {
        return this.dockBlock;
    }

    public IntList getBuddyEntityIds() {
        return this.buddyEntityIds;
    }

    public int getBuddyCount() {
        return this.buddyEntityIds.size();
    }

    @Nullable
    public ByteBuddyEntity getBuddyByIndexClient(int index) {
        if (this.level.f_46443_) {
            ByteBuddyEntity byteBuddy;
            if (index < 0 || index >= this.buddyEntityIds.size()) {
                return null;
            }
            int id = this.buddyEntityIds.getInt(index);
            Entity buddyEntity = this.level.m_6815_(id);
            return buddyEntity instanceof ByteBuddyEntity ? (byteBuddy = (ByteBuddyEntity)buddyEntity) : null;
        }
        return null;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 65, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 65) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.dockBlock != null && player.m_20275_((double)this.dockBlock.m_58899_().m_123341_() + 0.5, (double)this.dockBlock.m_58899_().m_123342_() + 0.5, (double)this.dockBlock.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int startX = 40;
        int startY = 145;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, startX + col * 18, startY + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int startX = 40;
        int startY = 203;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, startX + i * 18, startY));
        }
    }

    private void addStationInventory() {
        if (this.dockBlock == null) {
            return;
        }
        int startX = 40;
        int startY = 63;
        int slot = 2;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.dockBlock.getMainInv(), 0, 6, 109){

            public boolean m_5857_(@NotNull ItemStack itemStack) {
                return DockingStationMenu.this.dockBlock.getMainInv().isItemValid(0, itemStack);
            }

            public int m_5866_(ItemStack itemStack) {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_battery"));
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.dockBlock.getMainInv(), 1, 218, 53){

            public boolean m_5857_(@NotNull ItemStack itemStack) {
                return DockingStationMenu.this.dockBlock.getMainInv().isItemValid(1, itemStack);
            }

            public int m_5866_(ItemStack itemStack) {
                return 1;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)new ResourceLocation("bytebuddies", "item/empty_slot_clipboard"));
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.dockBlock.getMainInv(), slot++, startX + col * 18, startY + row * 18){

                    public int m_5866_(ItemStack itemStack) {
                        return 64;
                    }
                });
            }
        }
    }

    public int getEnergyStored() {
        return this.clientEnergy;
    }

    public int getMaxEnergyStored() {
        return this.clientMaxEnergy;
    }
}

